/*
 * Decompiled with CFR 0.152.
 */
package com.wadpam.open.jsonp;

import com.wadpam.open.jsonp.FilterServletOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericResponseWrapper
extends HttpServletResponseWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(GenericResponseWrapper.class);
    private final ByteArrayOutputStream output = new ByteArrayOutputStream();
    private int contentLength;
    private int httpStatus = 200;
    private String redirectUrl;

    public GenericResponseWrapper(HttpServletResponse response) {
        super(response);
    }

    public void sendError(int sc) throws IOException {
        this.httpStatus = sc;
        super.sendError(sc);
    }

    public void sendError(int sc, String msg) throws IOException {
        this.httpStatus = sc;
        super.sendError(sc, msg);
    }

    public void setStatus(int sc) {
        this.httpStatus = sc;
        super.setStatus(sc);
    }

    public void sendRedirect(String location) throws IOException {
        this.httpStatus = 302;
        this.redirectUrl = location;
        super.sendRedirect(location);
    }

    public int getStatus() {
        return this.httpStatus;
    }

    public byte[] getData() {
        return this.output.toByteArray();
    }

    public ServletOutputStream getOutputStream() {
        return new FilterServletOutputStream(this.output);
    }

    public PrintWriter getWriter() {
        return new PrintWriter((OutputStream)this.getOutputStream(), true);
    }

    public void setContentLength(int length) {
        this.contentLength = length;
        super.setContentLength(length);
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }
}

