/*
 * Decompiled with CFR 0.152.
 */
package com.wadpam.open.jsonp;

import com.wadpam.open.jsonp.GenericResponseWrapper;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonpCallbackFilter
implements Filter {
    public static final String CALLBACK_METHOD_NAME = "callbackMethodName";
    private static final Logger LOG = LoggerFactory.getLogger(JsonpCallbackFilter.class);
    private String callbackParam = "callback";

    public void init(FilterConfig fConfig) throws ServletException {
        String callbackMethodName = fConfig.getInitParameter(CALLBACK_METHOD_NAME);
        if (null != callbackMethodName) {
            this.callbackParam = callbackMethodName;
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String callback = httpRequest.getParameter(this.callbackParam);
        if (null != callback && callback.length() > 0) {
            LOG.debug("Wrapping response with JSONP callback '" + callback + "'");
            GenericResponseWrapper wrapper = new GenericResponseWrapper(httpResponse);
            chain.doFilter(request, (ServletResponse)wrapper);
            httpResponse.setContentType("text/javascript;charset=UTF-8");
            ServletOutputStream out = httpResponse.getOutputStream();
            out.write(callback.getBytes());
            out.write(40);
            byte[] data = wrapper.getData();
            LOG.debug("Wrapped data size is " + data.length);
            out.write(data);
            out.write(41);
            out.write(59);
            out.close();
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }
}

