/*
 * Decompiled with CFR 0.152.
 */
package com.wadpam.open.web;

import com.google.appengine.api.datastore.GeoPt;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.wadpam.open.json.JBaseObject;
import com.wadpam.open.json.JCursorPage;
import com.wadpam.open.json.JLocation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import net.sf.mardao.core.CursorPage;
import net.sf.mardao.core.domain.AbstractCreatedUpdatedEntity;
import net.sf.mardao.core.domain.AbstractLongEntity;
import net.sf.mardao.core.geo.DLocation;

public abstract class BaseConverter {
    public abstract JBaseObject convertBase(Object var1);

    public static void convert(AbstractCreatedUpdatedEntity from, JBaseObject to) {
        if (null == from || null == to) {
            return;
        }
        to.setCreatedBy(from.getCreatedBy());
        to.setCreatedDate(BaseConverter.toLong(from.getCreatedDate()));
        to.setUpdatedBy(from.getUpdatedBy());
        to.setUpdatedDate(BaseConverter.toLong(from.getUpdatedDate()));
    }

    public static void convert(AbstractLongEntity from, JBaseObject to) {
        if (null == from || null == to) {
            return;
        }
        BaseConverter.convert((AbstractCreatedUpdatedEntity)from, to);
        to.setId(BaseConverter.toString(from.getId()));
    }

    public static void convert(JBaseObject from, AbstractCreatedUpdatedEntity to) {
        if (null == from || null == to) {
            return;
        }
        to.setCreatedBy(from.getCreatedBy());
        to.setCreatedDate(BaseConverter.toDate(from.getCreatedDate()));
        to.setUpdatedBy(from.getUpdatedBy());
        to.setUpdatedDate(BaseConverter.toDate(from.getUpdatedDate()));
    }

    public static void convert(JBaseObject from, AbstractLongEntity to) {
        if (null == from || null == to) {
            return;
        }
        BaseConverter.convert(from, (AbstractCreatedUpdatedEntity)to);
        to.setId(BaseConverter.toLong(from.getId()));
    }

    public Collection<?> convert(Iterable<?> from) {
        if (null == from) {
            return new ArrayList();
        }
        ArrayList<JBaseObject> returnValue = new ArrayList<JBaseObject>();
        for (Object o : from) {
            JBaseObject to = this.convertBase(o);
            returnValue.add(to);
        }
        return returnValue;
    }

    public static JLocation convert(GeoPt from) {
        if (null == from) {
            return null;
        }
        return new JLocation(Float.valueOf(from.getLatitude()), Float.valueOf(from.getLongitude()));
    }

    public static JLocation convert(DLocation from) {
        if (null == from) {
            return null;
        }
        return new JLocation(Float.valueOf(from.getLatitude()), Float.valueOf(from.getLongitude()));
    }

    public <D extends AbstractLongEntity> JCursorPage<? extends JBaseObject> convertPage(CursorPage<D> from) {
        JCursorPage to = new JCursorPage();
        to.setPageSize(from.getItems().size());
        to.setCursorKey(from.getCursorKey());
        to.setItems(this.convert(from.getItems()));
        return to;
    }

    public static Long toLong(Date from) {
        if (null == from) {
            return null;
        }
        return from.getTime();
    }

    public static Long toLong(String from) {
        if (null == from) {
            return null;
        }
        return Long.parseLong(from);
    }

    public static Date toDate(Long from) {
        if (null == from) {
            return null;
        }
        return new Date(from);
    }

    public static String toString(Key key) {
        return KeyFactory.keyToString((Key)key);
    }

    public static String toString(Long from) {
        if (null == from) {
            return null;
        }
        return Long.toString(from);
    }

    public static Collection<Long> toLongs(Collection<String> from) {
        if (null == from) {
            return null;
        }
        ArrayList<Long> to = new ArrayList<Long>();
        for (String s : from) {
            try {
                to.add(Long.parseLong(s));
            }
            catch (NumberFormatException sometimes) {
                to.add(null);
            }
        }
        return to;
    }

    public static Collection<String> toString(Collection<Long> from) {
        if (null == from) {
            return null;
        }
        ArrayList<String> to = new ArrayList<String>(from.size());
        for (Long l : from) {
            to.add(l.toString());
        }
        return to;
    }
}

