/*
 * Decompiled with CFR 0.152.
 */
package com.wadpam.open.web;

import com.wadpam.docrest.domain.RestCode;
import com.wadpam.docrest.domain.RestReturn;
import com.wadpam.open.web.AbstractRestController;
import com.wadpam.open.web.UUIDCreatedListener;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"{domain}/common"})
public class UUIDController
extends AbstractRestController {
    private static final Logger LOG = LoggerFactory.getLogger(UUIDController.class);
    private UUIDCreatedListener uuidCallback;

    @RequestMapping(value={"uuid"}, method={RequestMethod.GET})
    @ResponseBody
    @RestReturn(value=Map.class, entity=Map.class, code={@RestCode(code=200, message="OK", description="UUID generated")})
    public Map<String, String> generateUUID4(HttpServletRequest request, @RequestParam String appArg1, @RequestParam String appArg2) {
        LOG.debug("Generate UUID");
        UUID uuid = UUID.randomUUID();
        if (null != this.uuidCallback) {
            this.uuidCallback.uuidCreated(uuid.toString(), appArg1, appArg2);
        }
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("uuid", uuid.toString());
        return response;
    }

    public UUIDCreatedListener getUuidCallback() {
        return this.uuidCallback;
    }

    public void setUuidCallback(UUIDCreatedListener uuidCallback) {
        this.uuidCallback = uuidCallback;
    }
}

