/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.internal_reporter_java.io.dropwizard.metrics5;

import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.Histogram;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.Metric;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.MetricName;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.MetricRegistry;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.Reservoir;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.Snapshot;
import com.wavefront.sdk.entities.histograms.WavefrontHistogramImpl;
import java.io.OutputStream;
import java.util.List;
import java.util.function.Supplier;

public class WavefrontHistogram
extends Histogram
implements Metric {
    private final WavefrontHistogramImpl delegate;

    public static WavefrontHistogram get(MetricRegistry registry, MetricName metricName) {
        return WavefrontHistogram.get(registry, metricName, System::currentTimeMillis);
    }

    public static WavefrontHistogram get(MetricRegistry registry, MetricName metricName, Supplier<Long> clock) {
        TDigestReservoir reservoir = new TDigestReservoir();
        WavefrontHistogram tDigestHistogram = new WavefrontHistogram(reservoir, clock);
        reservoir.set(tDigestHistogram);
        try {
            Metric metric = registry.getMetrics().get(metricName);
            if (metric instanceof WavefrontHistogram) {
                return (WavefrontHistogram)metric;
            }
            return registry.register(metricName, tDigestHistogram);
        }
        catch (IllegalArgumentException e) {
            Histogram existing = registry.histogram(metricName);
            if (existing instanceof WavefrontHistogram) {
                return (WavefrontHistogram)existing;
            }
            throw new IllegalStateException("Existing metric of type: Histogram found registered to metricName: " + metricName);
        }
    }

    private WavefrontHistogram(TDigestReservoir reservoir, Supplier<Long> clockMillis) {
        super(reservoir);
        this.delegate = new WavefrontHistogramImpl(clockMillis);
    }

    @Override
    public void update(int value) {
        this.delegate.update(value);
    }

    @Override
    public void update(long value) {
        this.delegate.update(value);
    }

    public void update(double value) {
        this.delegate.update(value);
    }

    @Override
    public long getCount() {
        return this.delegate.getCount();
    }

    @Override
    public Snapshot getSnapshot() {
        final WavefrontHistogramImpl.Snapshot delegateSnapshot = this.delegate.getSnapshot();
        return new Snapshot(){

            @Override
            public double getMedian() {
                return this.getValue(0.5);
            }

            @Override
            public double get75thPercentile() {
                return this.getValue(0.75);
            }

            @Override
            public double get95thPercentile() {
                return this.getValue(0.95);
            }

            @Override
            public double get98thPercentile() {
                return this.getValue(0.98);
            }

            @Override
            public double get99thPercentile() {
                return this.getValue(0.99);
            }

            @Override
            public double get999thPercentile() {
                return this.getValue(0.999);
            }

            @Override
            public long getMax() {
                return Math.round(delegateSnapshot.getMax());
            }

            @Override
            public double getMean() {
                return delegateSnapshot.getMean();
            }

            @Override
            public long getMin() {
                return (long)delegateSnapshot.getMin();
            }

            @Override
            public double getStdDev() {
                return WavefrontHistogram.this.delegate.stdDev();
            }

            @Override
            public void dump(OutputStream outputStream) {
            }

            @Override
            public double getValue(double quantile) {
                return delegateSnapshot.getValue(quantile);
            }

            @Override
            public long[] getValues() {
                return new long[0];
            }

            @Override
            public int size() {
                return delegateSnapshot.getSize();
            }
        };
    }

    public List<WavefrontHistogramImpl.Distribution> flushDistributions() {
        return this.delegate.flushDistributions();
    }

    private static class TDigestReservoir
    implements Reservoir {
        private WavefrontHistogram wfHist;

        private TDigestReservoir() {
        }

        void set(WavefrontHistogram tdm) {
            this.wfHist = tdm;
        }

        @Override
        public int size() {
            return (int)this.wfHist.getCount();
        }

        @Override
        public void update(long l) {
            this.wfHist.update(l);
        }

        @Override
        public Snapshot getSnapshot() {
            return this.wfHist.getSnapshot();
        }
    }
}

