/*
 * Decompiled with CFR 0.152.
 */
package com.xendit.model;

import com.google.gson.annotations.SerializedName;
import com.xendit.exception.XenditException;
import com.xendit.model.DirectDebitPayment;
import com.xendit.model.DirectDebitPaymentClient;
import com.xendit.model.LinkedAccountEnum;
import java.util.Map;

public class AccessibleLinkedAccount {
    @SerializedName(value="id")
    private String id;
    @SerializedName(value="channel_code")
    private LinkedAccountEnum.ChannelCode channelCode;
    @SerializedName(value="type")
    private LinkedAccountEnum.AccountType type;
    @SerializedName(value="properties")
    private Map<String, Object> properties;
    private static DirectDebitPaymentClient directDebitPaymentClient;

    public static AccessibleLinkedAccount[] retrieveAccessibleLinkedAccounts(String linkedAccountTokenId) throws XenditException {
        DirectDebitPaymentClient client = DirectDebitPayment.getClient();
        return client.retrieveAccessibleLinkedAccounts(linkedAccountTokenId);
    }

    AccessibleLinkedAccount(String id, LinkedAccountEnum.ChannelCode channelCode, LinkedAccountEnum.AccountType type, Map<String, Object> properties) {
        this.id = id;
        this.channelCode = channelCode;
        this.type = type;
        this.properties = properties;
    }

    public static AccessibleLinkedAccountBuilder builder() {
        return new AccessibleLinkedAccountBuilder();
    }

    public String getId() {
        return this.id;
    }

    public LinkedAccountEnum.ChannelCode getChannelCode() {
        return this.channelCode;
    }

    public LinkedAccountEnum.AccountType getType() {
        return this.type;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setChannelCode(LinkedAccountEnum.ChannelCode channelCode) {
        this.channelCode = channelCode;
    }

    public void setType(LinkedAccountEnum.AccountType type) {
        this.type = type;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public static class AccessibleLinkedAccountBuilder {
        private String id;
        private LinkedAccountEnum.ChannelCode channelCode;
        private LinkedAccountEnum.AccountType type;
        private Map<String, Object> properties;

        AccessibleLinkedAccountBuilder() {
        }

        public AccessibleLinkedAccountBuilder id(String id) {
            this.id = id;
            return this;
        }

        public AccessibleLinkedAccountBuilder channelCode(LinkedAccountEnum.ChannelCode channelCode) {
            this.channelCode = channelCode;
            return this;
        }

        public AccessibleLinkedAccountBuilder type(LinkedAccountEnum.AccountType type) {
            this.type = type;
            return this;
        }

        public AccessibleLinkedAccountBuilder properties(Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        public AccessibleLinkedAccount build() {
            return new AccessibleLinkedAccount(this.id, this.channelCode, this.type, this.properties);
        }

        public String toString() {
            return "AccessibleLinkedAccount.AccessibleLinkedAccountBuilder(id=" + this.id + ", channelCode=" + (Object)((Object)this.channelCode) + ", type=" + (Object)((Object)this.type) + ", properties=" + this.properties + ")";
        }
    }
}

