/*
 * Decompiled with CFR 0.152.
 */
package com.xendit.model;

import com.google.gson.annotations.SerializedName;
import com.xendit.Xendit;
import com.xendit.exception.XenditException;
import com.xendit.model.BalanceClient;
import java.util.HashMap;
import java.util.Map;

public class Balance {
    @SerializedName(value="balance")
    private Number balance;
    private static BalanceClient balanceClient;

    public void setBalance(Number balance) {
        this.balance = balance;
    }

    public static Balance get() throws XenditException {
        return Balance.getBalance(new HashMap<String, String>(), null);
    }

    public static Balance get(AccountType accountType) throws XenditException {
        return Balance.getBalance(new HashMap<String, String>(), accountType);
    }

    public static Balance get(Map<String, String> headers, AccountType accountType) throws XenditException {
        return Balance.getBalance(headers, accountType);
    }

    private static Balance getBalance(Map<String, String> headers, AccountType accountType) throws XenditException {
        BalanceClient client = Balance.getClient();
        return client.getBalance(headers, accountType);
    }

    private static BalanceClient getClient() {
        if (Balance.isApiKeyExist()) {
            if (balanceClient == null || !balanceClient.getOpt().getApiKey().trim().equals(Xendit.apiKey.trim())) {
                balanceClient = new BalanceClient(Xendit.Opt.setApiKey(Xendit.apiKey), Xendit.getRequestClient());
                return balanceClient;
            }
        } else if (balanceClient == null || !balanceClient.getOpt().getApiKey().trim().equals(Xendit.Opt.getApiKey().trim())) {
            balanceClient = new BalanceClient(Xendit.Opt, Xendit.getRequestClient());
            return balanceClient;
        }
        return balanceClient;
    }

    private static boolean isApiKeyExist() {
        return Xendit.apiKey != null;
    }

    Balance(Number balance) {
        this.balance = balance;
    }

    public static BalanceBuilder builder() {
        return new BalanceBuilder();
    }

    public Number getBalance() {
        return this.balance;
    }

    public static class BalanceBuilder {
        private Number balance;

        BalanceBuilder() {
        }

        public BalanceBuilder balance(Number balance) {
            this.balance = balance;
            return this;
        }

        public Balance build() {
            return new Balance(this.balance);
        }

        public String toString() {
            return "Balance.BalanceBuilder(balance=" + this.balance + ")";
        }
    }

    public static enum AccountType {
        CASH,
        HOLDING,
        TAX;

    }
}

