/*
 * Decompiled with CFR 0.152.
 */
package com.xendit.model;

import com.google.gson.annotations.SerializedName;
import com.xendit.Xendit;
import com.xendit.exception.XenditException;
import com.xendit.model.AvailableBank;
import com.xendit.model.BatchDisbursementClient;
import com.xendit.model.BatchDisbursementItem;
import java.util.HashMap;
import java.util.Map;

public class BatchDisbursement {
    @SerializedName(value="id")
    private String id;
    @SerializedName(value="created")
    private String created;
    @SerializedName(value="reference")
    private String reference;
    @SerializedName(value="total_uploaded_count")
    private Number totalUploadedCount;
    @SerializedName(value="total_uploaded_amount")
    private Number totalUploadedAmount;
    @SerializedName(value="status")
    private String status;
    private static BatchDisbursementClient batchDisbursementClient;

    public static BatchDisbursement create(String reference, BatchDisbursementItem[] disbursements) throws XenditException {
        return BatchDisbursement.create(new HashMap<String, String>(), reference, disbursements);
    }

    public static BatchDisbursement create(Map<String, String> headers, String reference, BatchDisbursementItem[] disbursements) throws XenditException {
        BatchDisbursementClient client = BatchDisbursement.getClient();
        return client.create(headers, reference, disbursements);
    }

    public static AvailableBank[] getAvailableBanks() throws XenditException {
        BatchDisbursementClient client = BatchDisbursement.getClient();
        return client.getAvailableBanks();
    }

    private static BatchDisbursementClient getClient() {
        if (BatchDisbursement.isApiKeyExist()) {
            if (batchDisbursementClient == null || !batchDisbursementClient.getOpt().getApiKey().trim().equals(Xendit.apiKey.trim())) {
                batchDisbursementClient = new BatchDisbursementClient(Xendit.Opt.setApiKey(Xendit.apiKey), Xendit.getRequestClient());
                return batchDisbursementClient;
            }
        } else if (batchDisbursementClient == null || !batchDisbursementClient.getOpt().getApiKey().trim().equals(Xendit.Opt.getApiKey().trim())) {
            batchDisbursementClient = new BatchDisbursementClient(Xendit.Opt, Xendit.getRequestClient());
            return batchDisbursementClient;
        }
        return batchDisbursementClient;
    }

    private static boolean isApiKeyExist() {
        return Xendit.apiKey != null;
    }

    BatchDisbursement(String id, String created, String reference, Number totalUploadedCount, Number totalUploadedAmount, String status) {
        this.id = id;
        this.created = created;
        this.reference = reference;
        this.totalUploadedCount = totalUploadedCount;
        this.totalUploadedAmount = totalUploadedAmount;
        this.status = status;
    }

    public static BatchDisbursementBuilder builder() {
        return new BatchDisbursementBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getCreated() {
        return this.created;
    }

    public String getReference() {
        return this.reference;
    }

    public Number getTotalUploadedCount() {
        return this.totalUploadedCount;
    }

    public Number getTotalUploadedAmount() {
        return this.totalUploadedAmount;
    }

    public String getStatus() {
        return this.status;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setCreated(String created) {
        this.created = created;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public void setTotalUploadedCount(Number totalUploadedCount) {
        this.totalUploadedCount = totalUploadedCount;
    }

    public void setTotalUploadedAmount(Number totalUploadedAmount) {
        this.totalUploadedAmount = totalUploadedAmount;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public static class BatchDisbursementBuilder {
        private String id;
        private String created;
        private String reference;
        private Number totalUploadedCount;
        private Number totalUploadedAmount;
        private String status;

        BatchDisbursementBuilder() {
        }

        public BatchDisbursementBuilder id(String id) {
            this.id = id;
            return this;
        }

        public BatchDisbursementBuilder created(String created) {
            this.created = created;
            return this;
        }

        public BatchDisbursementBuilder reference(String reference) {
            this.reference = reference;
            return this;
        }

        public BatchDisbursementBuilder totalUploadedCount(Number totalUploadedCount) {
            this.totalUploadedCount = totalUploadedCount;
            return this;
        }

        public BatchDisbursementBuilder totalUploadedAmount(Number totalUploadedAmount) {
            this.totalUploadedAmount = totalUploadedAmount;
            return this;
        }

        public BatchDisbursementBuilder status(String status) {
            this.status = status;
            return this;
        }

        public BatchDisbursement build() {
            return new BatchDisbursement(this.id, this.created, this.reference, this.totalUploadedCount, this.totalUploadedAmount, this.status);
        }

        public String toString() {
            return "BatchDisbursement.BatchDisbursementBuilder(id=" + this.id + ", created=" + this.created + ", reference=" + this.reference + ", totalUploadedCount=" + this.totalUploadedCount + ", totalUploadedAmount=" + this.totalUploadedAmount + ", status=" + this.status + ")";
        }
    }
}

