/*
 * Decompiled with CFR 0.152.
 */
package com.xendit.model;

import com.xendit.Xendit;
import com.xendit.exception.XenditException;
import com.xendit.model.AvailableBank;
import com.xendit.model.BatchDisbursement;
import com.xendit.model.BatchDisbursementItem;
import com.xendit.network.NetworkClient;
import com.xendit.network.RequestResource;
import java.util.HashMap;
import java.util.Map;

public class BatchDisbursementClient {
    private Xendit.Option opt;
    private NetworkClient requestClient;

    public Xendit.Option getOpt() {
        return this.opt;
    }

    public BatchDisbursement create(String reference, BatchDisbursementItem[] disbursements) throws XenditException {
        return this.create(new HashMap<String, String>(), reference, disbursements);
    }

    public BatchDisbursement create(Map<String, String> headers, String reference, BatchDisbursementItem[] disbursements) throws XenditException {
        String url = String.format("%s%s", Xendit.Opt.getXenditURL(), "/batch_disbursements");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("reference", reference);
        params.put("disbursements", disbursements);
        return this.requestClient.request(RequestResource.Method.POST, url, headers, params, this.opt.getApiKey(), BatchDisbursement.class);
    }

    public AvailableBank[] getAvailableBanks() throws XenditException {
        String url = String.format("%s%s", Xendit.Opt.getXenditURL(), "/available_disbursements_banks");
        return this.requestClient.request(RequestResource.Method.GET, url, null, this.opt.getApiKey(), AvailableBank[].class);
    }

    public BatchDisbursementClient(Xendit.Option opt, NetworkClient requestClient) {
        this.opt = opt;
        this.requestClient = requestClient;
    }
}

