/*
 * Decompiled with CFR 0.152.
 */
package com.xendit.model;

import com.google.gson.annotations.SerializedName;
import com.xendit.Xendit;
import com.xendit.exception.XenditException;
import com.xendit.model.CardlessCreditClient;
import com.xendit.model.CardlessCreditCustomer;
import com.xendit.model.CardlessCreditItem;
import com.xendit.model.CardlessCreditShippingAddress;
import java.util.HashMap;
import java.util.Map;

public class CardlessCredit {
    @SerializedName(value="redirect_url")
    private String redirectUrl;
    @SerializedName(value="transaction_id")
    private String transactionId;
    @SerializedName(value="order_id")
    private String orderId;
    @SerializedName(value="external_id")
    private String externalId;
    @SerializedName(value="cardless_credit_type")
    private String cardlessCreditType;
    private static CardlessCreditClient cardlessCreditClient;

    public static CardlessCredit create(String cardlessCreditType, String externalId, Number amount, String paymentType, CardlessCreditItem[] items, CardlessCreditCustomer customerDetails, CardlessCreditShippingAddress shippingAddress, String redirectUrl, String callbackUrl) throws XenditException {
        CardlessCreditClient client = CardlessCredit.getClient();
        return client.create(cardlessCreditType, externalId, amount, paymentType, items, customerDetails, shippingAddress, redirectUrl, callbackUrl);
    }

    public static CardlessCredit create(Map<String, Object> params) throws XenditException {
        return CardlessCredit.create(new HashMap<String, String>(), params);
    }

    public static CardlessCredit create(Map<String, String> headers, Map<String, Object> params) throws XenditException {
        CardlessCreditClient client = CardlessCredit.getClient();
        return client.create(headers, params);
    }

    private static CardlessCreditClient getClient() {
        if (CardlessCredit.isApiKeyExist()) {
            if (cardlessCreditClient == null || !cardlessCreditClient.getOpt().getApiKey().trim().equals(Xendit.apiKey.trim())) {
                cardlessCreditClient = new CardlessCreditClient(Xendit.Opt.setApiKey(Xendit.apiKey), Xendit.getRequestClient());
                return cardlessCreditClient;
            }
        } else if (cardlessCreditClient == null || !cardlessCreditClient.getOpt().getApiKey().trim().equals(Xendit.Opt.getApiKey().trim())) {
            cardlessCreditClient = new CardlessCreditClient(Xendit.Opt, Xendit.getRequestClient());
            return cardlessCreditClient;
        }
        return cardlessCreditClient;
    }

    private static boolean isApiKeyExist() {
        return Xendit.apiKey != null;
    }

    CardlessCredit(String redirectUrl, String transactionId, String orderId, String externalId, String cardlessCreditType) {
        this.redirectUrl = redirectUrl;
        this.transactionId = transactionId;
        this.orderId = orderId;
        this.externalId = externalId;
        this.cardlessCreditType = cardlessCreditType;
    }

    public static CardlessCreditBuilder builder() {
        return new CardlessCreditBuilder();
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public String getCardlessCreditType() {
        return this.cardlessCreditType;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public void setCardlessCreditType(String cardlessCreditType) {
        this.cardlessCreditType = cardlessCreditType;
    }

    public static class CardlessCreditBuilder {
        private String redirectUrl;
        private String transactionId;
        private String orderId;
        private String externalId;
        private String cardlessCreditType;

        CardlessCreditBuilder() {
        }

        public CardlessCreditBuilder redirectUrl(String redirectUrl) {
            this.redirectUrl = redirectUrl;
            return this;
        }

        public CardlessCreditBuilder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public CardlessCreditBuilder orderId(String orderId) {
            this.orderId = orderId;
            return this;
        }

        public CardlessCreditBuilder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public CardlessCreditBuilder cardlessCreditType(String cardlessCreditType) {
            this.cardlessCreditType = cardlessCreditType;
            return this;
        }

        public CardlessCredit build() {
            return new CardlessCredit(this.redirectUrl, this.transactionId, this.orderId, this.externalId, this.cardlessCreditType);
        }

        public String toString() {
            return "CardlessCredit.CardlessCreditBuilder(redirectUrl=" + this.redirectUrl + ", transactionId=" + this.transactionId + ", orderId=" + this.orderId + ", externalId=" + this.externalId + ", cardlessCreditType=" + this.cardlessCreditType + ")";
        }
    }

    public static enum PaymentType {
        THIRTY_DAYS("30_days"),
        THREE_MONTHS("3_months"),
        SIX_MONTHS("6_months"),
        TWELVE_MONTHS("12_months");

        private String val;

        private PaymentType(String val) {
            this.val = val;
        }

        public String getVal() {
            return this.val;
        }
    }
}

