/*
 * Decompiled with CFR 0.152.
 */
package com.xendit.model;

import com.xendit.Xendit;
import com.xendit.exception.XenditException;
import com.xendit.model.CardlessCredit;
import com.xendit.model.CardlessCreditCustomer;
import com.xendit.model.CardlessCreditItem;
import com.xendit.model.CardlessCreditShippingAddress;
import com.xendit.network.NetworkClient;
import com.xendit.network.RequestResource;
import java.util.HashMap;
import java.util.Map;

public class CardlessCreditClient {
    private Xendit.Option opt;
    private NetworkClient requestClient;

    public Xendit.Option getOpt() {
        return this.opt;
    }

    public CardlessCredit create(String cardlessCreditType, String externalId, Number amount, String paymentType, CardlessCreditItem[] items, CardlessCreditCustomer customerDetails, CardlessCreditShippingAddress shippingAddress, String redirectUrl, String callbackUrl) throws XenditException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("cardless_credit_type", cardlessCreditType);
        params.put("external_id", externalId);
        params.put("amount", amount);
        params.put("payment_type", paymentType);
        params.put("items", items);
        params.put("customer_details", customerDetails);
        params.put("shipping_address", shippingAddress);
        params.put("redirect_url", redirectUrl);
        params.put("callback_url", callbackUrl);
        String url = String.format("%s%s", Xendit.Opt.getXenditURL(), "/cardless-credit");
        return this.requestClient.request(RequestResource.Method.POST, url, params, this.opt.getApiKey(), CardlessCredit.class);
    }

    public CardlessCredit create(Map<String, Object> params) throws XenditException {
        return this.create(new HashMap<String, String>(), params);
    }

    public CardlessCredit create(Map<String, String> headers, Map<String, Object> params) throws XenditException {
        String url = String.format("%s%s", Xendit.Opt.getXenditURL(), "/cardless-credit");
        return this.requestClient.request(RequestResource.Method.POST, url, headers, params, this.opt.getApiKey(), CardlessCredit.class);
    }

    public CardlessCreditClient(Xendit.Option opt, NetworkClient requestClient) {
        this.opt = opt;
        this.requestClient = requestClient;
    }
}

