/*
 * Decompiled with CFR 0.152.
 */
package com.xendit.model;

import com.xendit.Xendit;
import com.xendit.exception.XenditException;
import com.xendit.model.CreditCardCharge;
import com.xendit.model.CreditCardClient;
import com.xendit.model.CreditCardRefund;
import com.xendit.model.CreditCardReverseAuth;
import java.util.HashMap;
import java.util.Map;

public class CreditCard {
    private static CreditCardClient creditCardClient;

    public static CreditCardCharge createAuthorization(String tokenId, String externalId, Number amount, String authenticationId, String cardCVN, Boolean capture) throws XenditException {
        CreditCardClient client = CreditCard.getClient();
        return client.createAuthorization(tokenId, externalId, amount, authenticationId, cardCVN, capture);
    }

    public static CreditCardCharge createAuthorization(Map<String, Object> params) throws XenditException {
        return CreditCard.createAuthorization(new HashMap<String, String>(), params);
    }

    public static CreditCardCharge createAuthorization(Map<String, String> headers, Map<String, Object> params) throws XenditException {
        CreditCardClient client = CreditCard.getClient();
        return client.createAuthorization(headers, params);
    }

    public static CreditCardCharge createCharge(String tokenId, String externalId, Number amount, String authenticationId, String cardCVN, String descriptor) throws XenditException {
        CreditCardClient client = CreditCard.getClient();
        return client.createCharge(tokenId, externalId, amount, authenticationId, cardCVN, descriptor);
    }

    public static CreditCardCharge createCharge(Map<String, Object> params) throws XenditException {
        return CreditCard.createCharge(new HashMap<String, String>(), params);
    }

    public static CreditCardCharge createCharge(Map<String, String> headers, Map<String, Object> params) throws XenditException {
        CreditCardClient client = CreditCard.getClient();
        return client.createCharge(headers, params);
    }

    public static CreditCardReverseAuth reverseAuthorization(String chargeId, String externalId) throws XenditException {
        CreditCardClient client = CreditCard.getClient();
        return client.reverseAuthorization(chargeId, externalId);
    }

    public static CreditCardReverseAuth reverseAuthorization(Map<String, String> headers, String chargeId, String externalId) throws XenditException {
        CreditCardClient client = CreditCard.getClient();
        return client.reverseAuthorization(headers, chargeId, externalId);
    }

    public static CreditCardCharge captureCharge(String chargeId, Number amount) throws XenditException {
        return CreditCard.captureCharge(new HashMap<String, String>(), chargeId, amount);
    }

    public static CreditCardCharge captureCharge(Map<String, String> headers, String chargeId, Number amount) throws XenditException {
        CreditCardClient client = CreditCard.getClient();
        return client.captureCharge(headers, chargeId, amount);
    }

    public static CreditCardCharge getCharge(String id) throws XenditException {
        CreditCardClient client = CreditCard.getClient();
        return client.getCharge(id);
    }

    public static CreditCardRefund createRefund(String id, Number amount, String externalId) throws XenditException {
        return CreditCard.createRefund(new HashMap<String, String>(), id, amount, externalId);
    }

    public static CreditCardRefund createRefund(Map<String, String> headers, String id, Number amount, String externalId) throws XenditException {
        CreditCardClient client = CreditCard.getClient();
        return client.createRefund(headers, id, amount, externalId);
    }

    private static CreditCardClient getClient() {
        if (CreditCard.isApiKeyExist()) {
            if (creditCardClient == null || !creditCardClient.getOpt().getApiKey().trim().equals(Xendit.apiKey.trim())) {
                creditCardClient = new CreditCardClient(Xendit.Opt.setApiKey(Xendit.apiKey), Xendit.getRequestClient());
                return creditCardClient;
            }
        } else if (creditCardClient == null || !creditCardClient.getOpt().getApiKey().trim().equals(Xendit.Opt.getApiKey().trim())) {
            creditCardClient = new CreditCardClient(Xendit.Opt, Xendit.getRequestClient());
            return creditCardClient;
        }
        return creditCardClient;
    }

    private static boolean isApiKeyExist() {
        return Xendit.apiKey != null;
    }

    CreditCard() {
    }

    public static CreditCardBuilder builder() {
        return new CreditCardBuilder();
    }

    public static class CreditCardBuilder {
        CreditCardBuilder() {
        }

        public CreditCard build() {
            return new CreditCard();
        }

        public String toString() {
            return "CreditCard.CreditCardBuilder()";
        }
    }
}

