/*
 * Decompiled with CFR 0.152.
 */
package com.xendit.model;

import com.xendit.Xendit;
import com.xendit.exception.XenditException;
import com.xendit.model.CreditCardCharge;
import com.xendit.model.CreditCardRefund;
import com.xendit.model.CreditCardReverseAuth;
import com.xendit.network.NetworkClient;
import com.xendit.network.RequestResource;
import java.util.HashMap;
import java.util.Map;

public class CreditCardClient {
    private Xendit.Option opt;
    private NetworkClient requestClient;

    public Xendit.Option getOpt() {
        return this.opt;
    }

    public CreditCardCharge createAuthorization(String tokenId, String externalId, Number amount, String authenticationId, String cardCVN, Boolean capture) throws XenditException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("token_id", tokenId);
        params.put("external_id", externalId);
        params.put("amount", amount);
        if (this.isNotEmpty(authenticationId)) {
            params.put("authentication_id", authenticationId);
        }
        if (this.isNotEmpty(cardCVN)) {
            params.put("card_cvn", cardCVN);
        }
        params.put("capture", capture);
        String url = String.format("%s%s", Xendit.Opt.getXenditURL(), "/credit_card_charges");
        return this.requestClient.request(RequestResource.Method.POST, url, params, this.opt.getApiKey(), CreditCardCharge.class);
    }

    public CreditCardCharge createAuthorization(Map<String, Object> params) throws XenditException {
        return this.createAuthorization(new HashMap<String, String>(), params);
    }

    public CreditCardCharge createAuthorization(Map<String, String> headers, Map<String, Object> params) throws XenditException {
        String url = String.format("%s%s", Xendit.Opt.getXenditURL(), "/credit_card_charges");
        return this.requestClient.request(RequestResource.Method.POST, url, headers, params, this.opt.getApiKey(), CreditCardCharge.class);
    }

    public CreditCardCharge createCharge(String tokenId, String externalId, Number amount, String authenticationId, String cardCVN, String descriptor) throws XenditException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("token_id", tokenId);
        params.put("external_id", externalId);
        params.put("amount", amount);
        if (this.isNotEmpty(authenticationId)) {
            params.put("authentication_id", authenticationId);
        }
        if (this.isNotEmpty(cardCVN)) {
            params.put("card_cvn", cardCVN);
        }
        if (this.isNotEmpty(descriptor)) {
            params.put("descriptor", descriptor);
        }
        String url = String.format("%s%s", Xendit.Opt.getXenditURL(), "/credit_card_charges");
        return this.requestClient.request(RequestResource.Method.POST, url, params, this.opt.getApiKey(), CreditCardCharge.class);
    }

    public CreditCardCharge createCharge(Map<String, Object> params) throws XenditException {
        return this.createCharge(new HashMap<String, String>(), params);
    }

    public CreditCardCharge createCharge(Map<String, String> headers, Map<String, Object> params) throws XenditException {
        String url = String.format("%s%s", Xendit.Opt.getApiKey(), "/credit_card_charges");
        return this.requestClient.request(RequestResource.Method.POST, url, headers, params, this.opt.getApiKey(), CreditCardCharge.class);
    }

    public CreditCardReverseAuth reverseAuthorization(String chargeId, String externalId) throws XenditException {
        return this.reverseAuthorization(new HashMap<String, String>(), chargeId, externalId);
    }

    public CreditCardReverseAuth reverseAuthorization(Map<String, String> headers, String chargeId, String externalId) throws XenditException {
        String url = String.format("%s%s%s%s", Xendit.Opt.getXenditURL(), "/credit_card_charges/", chargeId, "/auth_reversal");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("external_id", externalId);
        return this.requestClient.request(RequestResource.Method.POST, url, headers, params, this.opt.getApiKey(), CreditCardReverseAuth.class);
    }

    public CreditCardCharge captureCharge(String chargeId, Number amount) throws XenditException {
        return this.captureCharge(new HashMap<String, String>(), chargeId, amount);
    }

    public CreditCardCharge captureCharge(Map<String, String> headers, String chargeId, Number amount) throws XenditException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("amount", amount);
        String url = String.format("%s%s%s%s", Xendit.Opt.getXenditURL(), "/credit_card_charges/", chargeId, "/capture");
        return this.requestClient.request(RequestResource.Method.POST, url, headers, params, this.opt.getApiKey(), CreditCardCharge.class);
    }

    public CreditCardCharge getCharge(String id) throws XenditException {
        String url = String.format("%s%s%s", Xendit.Opt.getXenditURL(), "/credit_card_charges/", id);
        return this.requestClient.request(RequestResource.Method.GET, url, null, this.opt.getApiKey(), CreditCardCharge.class);
    }

    public CreditCardRefund createRefund(String id, Number amount, String externalId) throws XenditException {
        return this.createRefund(new HashMap<String, String>(), id, amount, externalId);
    }

    public CreditCardRefund createRefund(Map<String, String> headers, String id, Number amount, String externalId) throws XenditException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("amount", amount);
        params.put("external_id", externalId);
        String url = String.format("%s%s%s%s", Xendit.Opt.getXenditURL(), "/credit_card_charges/", id, "/refunds");
        return this.requestClient.request(RequestResource.Method.POST, url, headers, params, this.opt.getApiKey(), CreditCardRefund.class);
    }

    private boolean isNotEmpty(String param) {
        return param != null && !"".equals(param);
    }

    public CreditCardClient(Xendit.Option opt, NetworkClient requestClient) {
        this.opt = opt;
        this.requestClient = requestClient;
    }
}

