/*
 * Decompiled with CFR 0.152.
 */
package com.xendit.model;

import com.google.gson.annotations.SerializedName;
import com.xendit.Xendit;
import com.xendit.exception.XenditException;
import com.xendit.model.CustomerAddress;
import com.xendit.model.CustomerClient;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class Customer {
    @SerializedName(value="id")
    private String id;
    @SerializedName(value="reference_id")
    private String referenceId;
    @SerializedName(value="mobile_number")
    private String mobileNumber;
    @SerializedName(value="email")
    private String email;
    @SerializedName(value="given_names")
    private String givenNames;
    @SerializedName(value="middle_name")
    private String middleName;
    @SerializedName(value="surname")
    private String surname;
    @SerializedName(value="description")
    private String description;
    @SerializedName(value="phone_number")
    private String phoneNumber;
    @SerializedName(value="nationality")
    private String nationality;
    @SerializedName(value="addresses")
    private CustomerAddress[] addresses;
    @SerializedName(value="date_of_birth")
    private String dateOfBirth;
    @SerializedName(value="metadata")
    private Map<String, Object> metadata;
    private static CustomerClient customerClient;

    public static Customer createCustomer(String referenceId, String mobileNumber, String email, String givenNames, String middleName, String surname, String description, String phoneNumber, String nationality, CustomerAddress[] addresses, String dateOfBirth, Map<String, Object> metadata) throws XenditException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("reference_id", referenceId);
        params.put("mobile_number", mobileNumber);
        params.put("email", email);
        params.put("given_names", givenNames);
        params.put("middle_name", middleName);
        params.put("surname", surname);
        params.put("description", description);
        params.put("phone_number", phoneNumber);
        params.put("nationality", nationality);
        params.put("addresses", addresses);
        params.put("date_of_birth", dateOfBirth);
        params.put("metadata", metadata);
        return Customer.createCustomerRequest(new HashMap<String, String>(), params);
    }

    public static Customer createCustomer(Map<String, Object> params) throws XenditException {
        return Customer.createCustomerRequest(new HashMap<String, String>(), params);
    }

    public static Customer createCustomer(Map<String, String> headers, Map<String, Object> params) throws XenditException {
        return Customer.createCustomerRequest(headers, params);
    }

    public static Customer[] getCustomerByReferenceId(String referenceId) throws XenditException {
        CustomerClient client = Customer.getClient();
        return client.getCustomerByReferenceId(referenceId);
    }

    private static Customer createCustomerRequest(Map<String, String> headers, Map<String, Object> params) throws XenditException {
        CustomerClient client = Customer.getClient();
        return client.createCustomer(headers, params);
    }

    private static CustomerClient getClient() {
        if (Customer.isApiKeyExist()) {
            if (customerClient == null || !customerClient.getOpt().getApiKey().trim().equals(Xendit.apiKey.trim())) {
                customerClient = new CustomerClient(Xendit.Opt.setApiKey(Xendit.apiKey), Xendit.getRequestClient());
                return customerClient;
            }
        } else if (customerClient == null || !customerClient.getOpt().getApiKey().trim().equals(Xendit.Opt.getApiKey().trim())) {
            customerClient = new CustomerClient(Xendit.Opt, Xendit.getRequestClient());
            return customerClient;
        }
        return customerClient;
    }

    private static boolean isApiKeyExist() {
        return Xendit.apiKey != null;
    }

    Customer(String id, String referenceId, String mobileNumber, String email, String givenNames, String middleName, String surname, String description, String phoneNumber, String nationality, CustomerAddress[] addresses, String dateOfBirth, Map<String, Object> metadata) {
        this.id = id;
        this.referenceId = referenceId;
        this.mobileNumber = mobileNumber;
        this.email = email;
        this.givenNames = givenNames;
        this.middleName = middleName;
        this.surname = surname;
        this.description = description;
        this.phoneNumber = phoneNumber;
        this.nationality = nationality;
        this.addresses = addresses;
        this.dateOfBirth = dateOfBirth;
        this.metadata = metadata;
    }

    public static CustomerBuilder builder() {
        return new CustomerBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public String getMobileNumber() {
        return this.mobileNumber;
    }

    public String getEmail() {
        return this.email;
    }

    public String getGivenNames() {
        return this.givenNames;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public String getSurname() {
        return this.surname;
    }

    public String getDescription() {
        return this.description;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public String getNationality() {
        return this.nationality;
    }

    public CustomerAddress[] getAddresses() {
        return this.addresses;
    }

    public String getDateOfBirth() {
        return this.dateOfBirth;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public void setMobileNumber(String mobileNumber) {
        this.mobileNumber = mobileNumber;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setGivenNames(String givenNames) {
        this.givenNames = givenNames;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public void setSurname(String surname) {
        this.surname = surname;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public void setNationality(String nationality) {
        this.nationality = nationality;
    }

    public void setAddresses(CustomerAddress[] addresses) {
        this.addresses = addresses;
    }

    public void setDateOfBirth(String dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public static class CustomerBuilder {
        private String id;
        private String referenceId;
        private String mobileNumber;
        private String email;
        private String givenNames;
        private String middleName;
        private String surname;
        private String description;
        private String phoneNumber;
        private String nationality;
        private CustomerAddress[] addresses;
        private String dateOfBirth;
        private Map<String, Object> metadata;

        CustomerBuilder() {
        }

        public CustomerBuilder id(String id) {
            this.id = id;
            return this;
        }

        public CustomerBuilder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public CustomerBuilder mobileNumber(String mobileNumber) {
            this.mobileNumber = mobileNumber;
            return this;
        }

        public CustomerBuilder email(String email) {
            this.email = email;
            return this;
        }

        public CustomerBuilder givenNames(String givenNames) {
            this.givenNames = givenNames;
            return this;
        }

        public CustomerBuilder middleName(String middleName) {
            this.middleName = middleName;
            return this;
        }

        public CustomerBuilder surname(String surname) {
            this.surname = surname;
            return this;
        }

        public CustomerBuilder description(String description) {
            this.description = description;
            return this;
        }

        public CustomerBuilder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public CustomerBuilder nationality(String nationality) {
            this.nationality = nationality;
            return this;
        }

        public CustomerBuilder addresses(CustomerAddress[] addresses) {
            this.addresses = addresses;
            return this;
        }

        public CustomerBuilder dateOfBirth(String dateOfBirth) {
            this.dateOfBirth = dateOfBirth;
            return this;
        }

        public CustomerBuilder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Customer build() {
            return new Customer(this.id, this.referenceId, this.mobileNumber, this.email, this.givenNames, this.middleName, this.surname, this.description, this.phoneNumber, this.nationality, this.addresses, this.dateOfBirth, this.metadata);
        }

        public String toString() {
            return "Customer.CustomerBuilder(id=" + this.id + ", referenceId=" + this.referenceId + ", mobileNumber=" + this.mobileNumber + ", email=" + this.email + ", givenNames=" + this.givenNames + ", middleName=" + this.middleName + ", surname=" + this.surname + ", description=" + this.description + ", phoneNumber=" + this.phoneNumber + ", nationality=" + this.nationality + ", addresses=" + Arrays.deepToString(this.addresses) + ", dateOfBirth=" + this.dateOfBirth + ", metadata=" + this.metadata + ")";
        }
    }
}

