/*
 * Decompiled with CFR 0.152.
 */
package com.xendit.model;

import com.xendit.Xendit;
import com.xendit.exception.XenditException;
import com.xendit.model.Customer;
import com.xendit.model.CustomerAddress;
import com.xendit.network.NetworkClient;
import com.xendit.network.RequestResource;
import java.util.HashMap;
import java.util.Map;

public class CustomerClient {
    private Xendit.Option opt;
    private NetworkClient requestClient;

    public Xendit.Option getOpt() {
        return this.opt;
    }

    public Customer createCustomer(String referenceId, String mobileNumber, String email, String givenNames, String middleName, String surname, String description, String phoneNumber, String nationality, CustomerAddress[] addresses, String dateOfBirth, Map<String, Object> metadata) throws XenditException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("reference_id", referenceId);
        params.put("mobile_number", mobileNumber);
        params.put("email", email);
        params.put("given_names", givenNames);
        params.put("middle_name", middleName);
        params.put("surname", surname);
        params.put("description", description);
        params.put("phone_number", phoneNumber);
        params.put("nationality", nationality);
        params.put("addresses", addresses);
        params.put("date_of_birth", dateOfBirth);
        params.put("metadata", metadata);
        return this.createCustomerRequest(new HashMap<String, String>(), params);
    }

    public Customer createCustomer(Map<String, Object> params) throws XenditException {
        return this.createCustomerRequest(new HashMap<String, String>(), params);
    }

    public Customer createCustomer(Map<String, String> headers, Map<String, Object> params) throws XenditException {
        return this.createCustomerRequest(headers, params);
    }

    public Customer[] getCustomerByReferenceId(String referenceId) throws XenditException {
        String url = String.format("%s%s%s", this.opt.getXenditURL(), "/customers?reference_id=", referenceId);
        return this.requestClient.request(RequestResource.Method.GET, url, null, this.opt.getApiKey(), Customer[].class);
    }

    private Customer createCustomerRequest(Map<String, String> headers, Map<String, Object> params) throws XenditException {
        String url = String.format("%s%s", this.opt.getXenditURL(), "/customers");
        return this.requestClient.request(RequestResource.Method.POST, url, headers, params, this.opt.getApiKey(), Customer.class);
    }

    public CustomerClient(Xendit.Option opt, NetworkClient requestClient) {
        this.opt = opt;
        this.requestClient = requestClient;
    }
}

