/*
 * Decompiled with CFR 0.152.
 */
package com.xendit.model;

import com.google.gson.annotations.SerializedName;
import com.xendit.Xendit;
import com.xendit.exception.XenditException;
import com.xendit.model.DirectDebitBasketItem;
import com.xendit.model.DirectDebitDevice;
import com.xendit.model.DirectDebitPaymentClient;
import com.xendit.model.DirectDebitRefunds;
import com.xendit.model.LinkedAccountEnum;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class DirectDebitPayment {
    @SerializedName(value="id")
    private String id;
    @SerializedName(value="reference_id")
    private String referenceId;
    @SerializedName(value="channel_code")
    private LinkedAccountEnum.ChannelCode channelCode;
    @SerializedName(value="payment_method_id")
    private String paymentMethodId;
    @SerializedName(value="currency")
    private String currency;
    @SerializedName(value="amount")
    private Number amount;
    @SerializedName(value="description")
    private String description;
    @SerializedName(value="status")
    private String status;
    @SerializedName(value="failure_code")
    private String failureCode;
    @SerializedName(value="is_otp_required")
    private Boolean isOtpRequired;
    @SerializedName(value="otp_mobile_number")
    private String otpMobileNumber;
    @SerializedName(value="otp_expiration_timestamp")
    private String otpExpirationTimestamp;
    @SerializedName(value="created")
    private String created;
    @SerializedName(value="updated")
    private String updated;
    @SerializedName(value="basket")
    private DirectDebitBasketItem[] basket;
    @SerializedName(value="metadata")
    private Map<String, Object> metadata;
    @SerializedName(value="device")
    private DirectDebitDevice device;
    @SerializedName(value="refunded_amount")
    private Number refundedAmount;
    @SerializedName(value="refunds")
    private DirectDebitRefunds refunds;
    @SerializedName(value="success_redirect_url")
    private String successRedirectUrl;
    @SerializedName(value="checkout_url")
    private String checkoutUrl;
    @SerializedName(value="failure_redirect_url")
    private String failureRedirectUrl;
    @SerializedName(value="required_action")
    private String requiredAction;
    private static DirectDebitPaymentClient directDebitPaymentClient;

    public static DirectDebitPayment createDirectDebitPayment(String referenceId, String paymentMethodId, String currency, Number amount, String callbackUrl, Boolean enableOtp, String description, DirectDebitBasketItem[] basket, DirectDebitDevice device, String successRedirectUrl, String failureRedirectUrl, Map<String, Object> metadata, String idempotencyKey) throws XenditException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("reference_id", referenceId);
        params.put("payment_method_id", paymentMethodId);
        params.put("currency", currency);
        params.put("amount", amount);
        params.put("callback_url", callbackUrl);
        params.put("enable_otp", enableOtp);
        params.put("description", description);
        params.put("basket", basket);
        params.put("device", device);
        params.put("success_redirect_url", successRedirectUrl);
        params.put("failure_redirect_url", failureRedirectUrl);
        params.put("metadata", metadata);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Idempotency-key", idempotencyKey);
        return DirectDebitPayment.createDirectDebitPaymentRequest(headers, params);
    }

    public static DirectDebitPayment createDirectDebitPayment(Map<String, Object> params, String idempotencyKey) throws XenditException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Idempotency-key", idempotencyKey);
        return DirectDebitPayment.createDirectDebitPaymentRequest(headers, params);
    }

    public static DirectDebitPayment createDirectDebitPayment(Map<String, String> headers, Map<String, Object> params, String idempotencyKey) throws XenditException {
        headers.put("Idempotency-key", idempotencyKey);
        return DirectDebitPayment.createDirectDebitPaymentRequest(headers, params);
    }

    public static DirectDebitPayment validateOTP(String directDebitPaymentId, String otpCode) throws XenditException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("otp_code", otpCode);
        return DirectDebitPayment.validateOTPRequest(directDebitPaymentId, new HashMap<String, String>(), params);
    }

    public static DirectDebitPayment validateOTP(String directDebitPaymentId, Map<String, Object> params) throws XenditException {
        return DirectDebitPayment.validateOTPRequest(directDebitPaymentId, new HashMap<String, String>(), params);
    }

    public static DirectDebitPayment validateOTP(String directDebitPaymentId, Map<String, String> headers, Map<String, Object> params) throws XenditException {
        return DirectDebitPayment.validateOTPRequest(directDebitPaymentId, headers, params);
    }

    public static DirectDebitPayment getDirectDebitPaymentStatusById(String directDebitPaymentId) throws XenditException {
        DirectDebitPaymentClient client = DirectDebitPayment.getClient();
        return client.getDirectDebitPaymentStatusById(directDebitPaymentId);
    }

    public static DirectDebitPayment[] getDirectDebitPaymentStatusByReferenceId(String referenceId) throws XenditException {
        DirectDebitPaymentClient client = DirectDebitPayment.getClient();
        return client.getDirectDebitPaymentStatusByReferenceId(referenceId);
    }

    private static DirectDebitPayment createDirectDebitPaymentRequest(Map<String, String> headers, Map<String, Object> params) throws XenditException {
        DirectDebitPaymentClient client = DirectDebitPayment.getClient();
        return client.createDirectDebitPaymentRequest(headers, params);
    }

    private static DirectDebitPayment validateOTPRequest(String directDebitPaymentId, Map<String, String> headers, Map<String, Object> params) throws XenditException {
        DirectDebitPaymentClient client = DirectDebitPayment.getClient();
        return client.validateOTPRequest(directDebitPaymentId, headers, params);
    }

    protected static DirectDebitPaymentClient getClient() {
        if (DirectDebitPayment.isApiKeyExist()) {
            if (directDebitPaymentClient == null || !directDebitPaymentClient.getOpt().getApiKey().trim().equals(Xendit.apiKey.trim())) {
                directDebitPaymentClient = new DirectDebitPaymentClient(Xendit.Opt.setApiKey(Xendit.apiKey), Xendit.getRequestClient());
                return directDebitPaymentClient;
            }
        } else if (directDebitPaymentClient == null || !directDebitPaymentClient.getOpt().getApiKey().trim().equals(Xendit.Opt.getApiKey().trim())) {
            directDebitPaymentClient = new DirectDebitPaymentClient(Xendit.Opt, Xendit.getRequestClient());
            return directDebitPaymentClient;
        }
        return directDebitPaymentClient;
    }

    private static boolean isApiKeyExist() {
        return Xendit.apiKey != null;
    }

    DirectDebitPayment(String id, String referenceId, LinkedAccountEnum.ChannelCode channelCode, String paymentMethodId, String currency, Number amount, String description, String status, String failureCode, Boolean isOtpRequired, String otpMobileNumber, String otpExpirationTimestamp, String created, String updated, DirectDebitBasketItem[] basket, Map<String, Object> metadata, DirectDebitDevice device, Number refundedAmount, DirectDebitRefunds refunds, String successRedirectUrl, String checkoutUrl, String failureRedirectUrl, String requiredAction) {
        this.id = id;
        this.referenceId = referenceId;
        this.channelCode = channelCode;
        this.paymentMethodId = paymentMethodId;
        this.currency = currency;
        this.amount = amount;
        this.description = description;
        this.status = status;
        this.failureCode = failureCode;
        this.isOtpRequired = isOtpRequired;
        this.otpMobileNumber = otpMobileNumber;
        this.otpExpirationTimestamp = otpExpirationTimestamp;
        this.created = created;
        this.updated = updated;
        this.basket = basket;
        this.metadata = metadata;
        this.device = device;
        this.refundedAmount = refundedAmount;
        this.refunds = refunds;
        this.successRedirectUrl = successRedirectUrl;
        this.checkoutUrl = checkoutUrl;
        this.failureRedirectUrl = failureRedirectUrl;
        this.requiredAction = requiredAction;
    }

    public static DirectDebitPaymentBuilder builder() {
        return new DirectDebitPaymentBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public LinkedAccountEnum.ChannelCode getChannelCode() {
        return this.channelCode;
    }

    public String getPaymentMethodId() {
        return this.paymentMethodId;
    }

    public String getCurrency() {
        return this.currency;
    }

    public Number getAmount() {
        return this.amount;
    }

    public String getDescription() {
        return this.description;
    }

    public String getStatus() {
        return this.status;
    }

    public String getFailureCode() {
        return this.failureCode;
    }

    public Boolean getIsOtpRequired() {
        return this.isOtpRequired;
    }

    public String getOtpMobileNumber() {
        return this.otpMobileNumber;
    }

    public String getOtpExpirationTimestamp() {
        return this.otpExpirationTimestamp;
    }

    public String getCreated() {
        return this.created;
    }

    public String getUpdated() {
        return this.updated;
    }

    public DirectDebitBasketItem[] getBasket() {
        return this.basket;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public DirectDebitDevice getDevice() {
        return this.device;
    }

    public Number getRefundedAmount() {
        return this.refundedAmount;
    }

    public DirectDebitRefunds getRefunds() {
        return this.refunds;
    }

    public String getSuccessRedirectUrl() {
        return this.successRedirectUrl;
    }

    public String getCheckoutUrl() {
        return this.checkoutUrl;
    }

    public String getFailureRedirectUrl() {
        return this.failureRedirectUrl;
    }

    public String getRequiredAction() {
        return this.requiredAction;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public void setChannelCode(LinkedAccountEnum.ChannelCode channelCode) {
        this.channelCode = channelCode;
    }

    public void setPaymentMethodId(String paymentMethodId) {
        this.paymentMethodId = paymentMethodId;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public void setAmount(Number amount) {
        this.amount = amount;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setFailureCode(String failureCode) {
        this.failureCode = failureCode;
    }

    public void setIsOtpRequired(Boolean isOtpRequired) {
        this.isOtpRequired = isOtpRequired;
    }

    public void setOtpMobileNumber(String otpMobileNumber) {
        this.otpMobileNumber = otpMobileNumber;
    }

    public void setOtpExpirationTimestamp(String otpExpirationTimestamp) {
        this.otpExpirationTimestamp = otpExpirationTimestamp;
    }

    public void setCreated(String created) {
        this.created = created;
    }

    public void setUpdated(String updated) {
        this.updated = updated;
    }

    public void setBasket(DirectDebitBasketItem[] basket) {
        this.basket = basket;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public void setDevice(DirectDebitDevice device) {
        this.device = device;
    }

    public void setRefundedAmount(Number refundedAmount) {
        this.refundedAmount = refundedAmount;
    }

    public void setRefunds(DirectDebitRefunds refunds) {
        this.refunds = refunds;
    }

    public void setSuccessRedirectUrl(String successRedirectUrl) {
        this.successRedirectUrl = successRedirectUrl;
    }

    public void setCheckoutUrl(String checkoutUrl) {
        this.checkoutUrl = checkoutUrl;
    }

    public void setFailureRedirectUrl(String failureRedirectUrl) {
        this.failureRedirectUrl = failureRedirectUrl;
    }

    public void setRequiredAction(String requiredAction) {
        this.requiredAction = requiredAction;
    }

    public static class DirectDebitPaymentBuilder {
        private String id;
        private String referenceId;
        private LinkedAccountEnum.ChannelCode channelCode;
        private String paymentMethodId;
        private String currency;
        private Number amount;
        private String description;
        private String status;
        private String failureCode;
        private Boolean isOtpRequired;
        private String otpMobileNumber;
        private String otpExpirationTimestamp;
        private String created;
        private String updated;
        private DirectDebitBasketItem[] basket;
        private Map<String, Object> metadata;
        private DirectDebitDevice device;
        private Number refundedAmount;
        private DirectDebitRefunds refunds;
        private String successRedirectUrl;
        private String checkoutUrl;
        private String failureRedirectUrl;
        private String requiredAction;

        DirectDebitPaymentBuilder() {
        }

        public DirectDebitPaymentBuilder id(String id) {
            this.id = id;
            return this;
        }

        public DirectDebitPaymentBuilder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public DirectDebitPaymentBuilder channelCode(LinkedAccountEnum.ChannelCode channelCode) {
            this.channelCode = channelCode;
            return this;
        }

        public DirectDebitPaymentBuilder paymentMethodId(String paymentMethodId) {
            this.paymentMethodId = paymentMethodId;
            return this;
        }

        public DirectDebitPaymentBuilder currency(String currency) {
            this.currency = currency;
            return this;
        }

        public DirectDebitPaymentBuilder amount(Number amount) {
            this.amount = amount;
            return this;
        }

        public DirectDebitPaymentBuilder description(String description) {
            this.description = description;
            return this;
        }

        public DirectDebitPaymentBuilder status(String status) {
            this.status = status;
            return this;
        }

        public DirectDebitPaymentBuilder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        public DirectDebitPaymentBuilder isOtpRequired(Boolean isOtpRequired) {
            this.isOtpRequired = isOtpRequired;
            return this;
        }

        public DirectDebitPaymentBuilder otpMobileNumber(String otpMobileNumber) {
            this.otpMobileNumber = otpMobileNumber;
            return this;
        }

        public DirectDebitPaymentBuilder otpExpirationTimestamp(String otpExpirationTimestamp) {
            this.otpExpirationTimestamp = otpExpirationTimestamp;
            return this;
        }

        public DirectDebitPaymentBuilder created(String created) {
            this.created = created;
            return this;
        }

        public DirectDebitPaymentBuilder updated(String updated) {
            this.updated = updated;
            return this;
        }

        public DirectDebitPaymentBuilder basket(DirectDebitBasketItem[] basket) {
            this.basket = basket;
            return this;
        }

        public DirectDebitPaymentBuilder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public DirectDebitPaymentBuilder device(DirectDebitDevice device) {
            this.device = device;
            return this;
        }

        public DirectDebitPaymentBuilder refundedAmount(Number refundedAmount) {
            this.refundedAmount = refundedAmount;
            return this;
        }

        public DirectDebitPaymentBuilder refunds(DirectDebitRefunds refunds) {
            this.refunds = refunds;
            return this;
        }

        public DirectDebitPaymentBuilder successRedirectUrl(String successRedirectUrl) {
            this.successRedirectUrl = successRedirectUrl;
            return this;
        }

        public DirectDebitPaymentBuilder checkoutUrl(String checkoutUrl) {
            this.checkoutUrl = checkoutUrl;
            return this;
        }

        public DirectDebitPaymentBuilder failureRedirectUrl(String failureRedirectUrl) {
            this.failureRedirectUrl = failureRedirectUrl;
            return this;
        }

        public DirectDebitPaymentBuilder requiredAction(String requiredAction) {
            this.requiredAction = requiredAction;
            return this;
        }

        public DirectDebitPayment build() {
            return new DirectDebitPayment(this.id, this.referenceId, this.channelCode, this.paymentMethodId, this.currency, this.amount, this.description, this.status, this.failureCode, this.isOtpRequired, this.otpMobileNumber, this.otpExpirationTimestamp, this.created, this.updated, this.basket, this.metadata, this.device, this.refundedAmount, this.refunds, this.successRedirectUrl, this.checkoutUrl, this.failureRedirectUrl, this.requiredAction);
        }

        public String toString() {
            return "DirectDebitPayment.DirectDebitPaymentBuilder(id=" + this.id + ", referenceId=" + this.referenceId + ", channelCode=" + (Object)((Object)this.channelCode) + ", paymentMethodId=" + this.paymentMethodId + ", currency=" + this.currency + ", amount=" + this.amount + ", description=" + this.description + ", status=" + this.status + ", failureCode=" + this.failureCode + ", isOtpRequired=" + this.isOtpRequired + ", otpMobileNumber=" + this.otpMobileNumber + ", otpExpirationTimestamp=" + this.otpExpirationTimestamp + ", created=" + this.created + ", updated=" + this.updated + ", basket=" + Arrays.deepToString(this.basket) + ", metadata=" + this.metadata + ", device=" + this.device + ", refundedAmount=" + this.refundedAmount + ", refunds=" + this.refunds + ", successRedirectUrl=" + this.successRedirectUrl + ", checkoutUrl=" + this.checkoutUrl + ", failureRedirectUrl=" + this.failureRedirectUrl + ", requiredAction=" + this.requiredAction + ")";
        }
    }
}

