/*
 * Decompiled with CFR 0.152.
 */
package com.xendit.model;

import com.xendit.Xendit;
import com.xendit.exception.XenditException;
import com.xendit.model.AccessibleLinkedAccount;
import com.xendit.model.DirectDebitBasketItem;
import com.xendit.model.DirectDebitDevice;
import com.xendit.model.DirectDebitPayment;
import com.xendit.model.InitializedLinkedAccount;
import com.xendit.model.LinkedAccountEnum;
import com.xendit.model.PaymentMethod;
import com.xendit.model.UnbindedLinkedAccount;
import com.xendit.model.ValidatedLinkedAccount;
import com.xendit.network.NetworkClient;
import com.xendit.network.RequestResource;
import java.util.HashMap;
import java.util.Map;

public class DirectDebitPaymentClient {
    private Xendit.Option opt;
    private NetworkClient requestClient;

    public Xendit.Option getOpt() {
        return this.opt;
    }

    public DirectDebitPayment createDirectDebitPayment(String referenceId, String paymentMethodId, String currency, Number amount, String callbackUrl, Boolean enableOtp, String description, DirectDebitBasketItem[] basket, DirectDebitDevice device, String successRedirectUrl, String failureRedirectUrl, Map<String, Object> metadata, String idempotencyKey) throws XenditException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("reference_id", referenceId);
        params.put("payment_method_id", paymentMethodId);
        params.put("currency", currency);
        params.put("amount", amount);
        params.put("callback_url", callbackUrl);
        params.put("enable_otp", enableOtp);
        params.put("description", description);
        params.put("basket", basket);
        params.put("device", device);
        params.put("success_redirect_url", successRedirectUrl);
        params.put("failure_redirect_url", failureRedirectUrl);
        params.put("metadata", metadata);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Idempotency-key", idempotencyKey);
        return this.createDirectDebitPaymentRequest(headers, params);
    }

    public DirectDebitPayment createDirectDebitPayment(Map<String, Object> params, String idempotencyKey) throws XenditException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Idempotency-key", idempotencyKey);
        return this.createDirectDebitPaymentRequest(headers, params);
    }

    public DirectDebitPayment createDirectDebitPayment(Map<String, String> headers, Map<String, Object> params, String idempotencyKey) throws XenditException {
        headers.put("Idempotency-key", idempotencyKey);
        return this.createDirectDebitPaymentRequest(headers, params);
    }

    public DirectDebitPayment validateOTP(String directDebitPaymentId, String otpCode) throws XenditException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("otp_code", otpCode);
        return this.validateOTPRequest(directDebitPaymentId, new HashMap<String, String>(), params);
    }

    public DirectDebitPayment validateOTP(String directDebitPaymentId, Map<String, Object> params) throws XenditException {
        return this.validateOTPRequest(directDebitPaymentId, new HashMap<String, String>(), params);
    }

    public DirectDebitPayment validateOTP(String directDebitPaymentId, Map<String, String> headers, Map<String, Object> params) throws XenditException {
        return this.validateOTPRequest(directDebitPaymentId, headers, params);
    }

    public DirectDebitPayment getDirectDebitPaymentStatusById(String directDebitPaymentId) throws XenditException {
        String url = String.format("%s%s%s%s", Xendit.Opt.getXenditURL(), "/direct_debits/", directDebitPaymentId, "/");
        return this.requestClient.request(RequestResource.Method.GET, url, null, this.opt.getApiKey(), DirectDebitPayment.class);
    }

    public DirectDebitPayment[] getDirectDebitPaymentStatusByReferenceId(String referenceId) throws XenditException {
        String url = String.format("%s%s%s", Xendit.Opt.getXenditURL(), "/direct_debits?reference_id=", referenceId);
        return this.requestClient.request(RequestResource.Method.GET, url, null, this.opt.getApiKey(), DirectDebitPayment[].class);
    }

    public DirectDebitPayment createDirectDebitPaymentRequest(Map<String, String> headers, Map<String, Object> params) throws XenditException {
        String url = String.format("%s%s", Xendit.Opt.getXenditURL(), "/direct_debits");
        return this.requestClient.request(RequestResource.Method.POST, url, headers, params, this.opt.getApiKey(), DirectDebitPayment.class);
    }

    public DirectDebitPayment validateOTPRequest(String directDebitPaymentId, Map<String, String> headers, Map<String, Object> params) throws XenditException {
        String url = String.format("%s%s%s%s", Xendit.Opt.getXenditURL(), "/direct_debits/", directDebitPaymentId, "/validate_otp/");
        return this.requestClient.request(RequestResource.Method.POST, url, headers, params, this.opt.getApiKey(), DirectDebitPayment.class);
    }

    public PaymentMethod createPaymentMethod(String customerId, LinkedAccountEnum.AccountType type, Map<String, Object> properties, Map<String, Object> metadata) throws XenditException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("customer_id", customerId);
        params.put("type", (Object)type);
        params.put("properties", properties);
        params.put("metadata", metadata);
        return this.createPaymentMethodRequest(new HashMap<String, String>(), params);
    }

    public PaymentMethod createPaymentMethod(Map<String, Object> params) throws XenditException {
        return this.createPaymentMethodRequest(new HashMap<String, String>(), params);
    }

    public PaymentMethod createPaymentMethod(Map<String, String> headers, Map<String, Object> params) throws XenditException {
        return this.createPaymentMethodRequest(headers, params);
    }

    public PaymentMethod[] getPaymentMethodsByCustomerId(String customerId) throws XenditException {
        String url = String.format("%s%s%s", Xendit.Opt.getXenditURL(), "/payment_methods?customer_id=", customerId);
        return this.requestClient.request(RequestResource.Method.GET, url, null, this.opt.getApiKey(), PaymentMethod[].class);
    }

    public PaymentMethod createPaymentMethodRequest(Map<String, String> headers, Map<String, Object> params) throws XenditException {
        String url = String.format("%s%s", Xendit.Opt.getXenditURL(), "/payment_methods");
        return this.requestClient.request(RequestResource.Method.POST, url, headers, params, this.opt.getApiKey(), PaymentMethod.class);
    }

    public InitializedLinkedAccount initializeLinkedAccountTokenization(String customerId, LinkedAccountEnum.ChannelCode channelCode, Map<String, Object> properties, Map<String, Object> metadata) throws XenditException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("customer_id", customerId);
        params.put("channel_code", (Object)channelCode);
        params.put("properties", properties);
        params.put("metadata", metadata);
        return this.initializeLinkedAccountTokenizationRequest(new HashMap<String, String>(), params);
    }

    public InitializedLinkedAccount initializeLinkedAccountTokenization(Map<String, Object> params) throws XenditException {
        return this.initializeLinkedAccountTokenizationRequest(new HashMap<String, String>(), params);
    }

    public InitializedLinkedAccount initializeLinkedAccountTokenization(Map<String, String> headers, Map<String, Object> params) throws XenditException {
        return this.initializeLinkedAccountTokenizationRequest(headers, params);
    }

    public InitializedLinkedAccount initializeLinkedAccountTokenizationRequest(Map<String, String> headers, Map<String, Object> params) throws XenditException {
        String url = String.format("%s%s", Xendit.Opt.getXenditURL(), "/linked_account_tokens/auth");
        return this.requestClient.request(RequestResource.Method.POST, url, headers, params, this.opt.getApiKey(), InitializedLinkedAccount.class);
    }

    public ValidatedLinkedAccount validateOTPWithToken(String tokenId, String otpCode) throws XenditException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("otp_code", otpCode);
        return this.validateOTPRequestWithToken(tokenId, new HashMap<String, String>(), params);
    }

    public ValidatedLinkedAccount validateOTPWithToken(String tokenId, Map<String, Object> params) throws XenditException {
        return this.validateOTPRequestWithToken(tokenId, new HashMap<String, String>(), params);
    }

    public ValidatedLinkedAccount validateOTPWithToken(String tokenId, Map<String, String> headers, Map<String, Object> params) throws XenditException {
        return this.validateOTPRequestWithToken(tokenId, headers, params);
    }

    public ValidatedLinkedAccount validateOTPRequestWithToken(String tokenId, Map<String, String> headers, Map<String, Object> params) throws XenditException {
        String url = String.format("%s%s%s%s", Xendit.Opt.getXenditURL(), "/linked_account_tokens/", tokenId, "/validate_otp");
        return this.requestClient.request(RequestResource.Method.POST, url, headers, params, this.opt.getApiKey(), ValidatedLinkedAccount.class);
    }

    public AccessibleLinkedAccount[] retrieveAccessibleLinkedAccounts(String linkedAccountTokenId) throws XenditException {
        String url = String.format("%s%s%s%s", Xendit.Opt.getXenditURL(), "/linked_account_tokens/", linkedAccountTokenId, "/accounts");
        return this.requestClient.request(RequestResource.Method.GET, url, null, this.opt.getApiKey(), AccessibleLinkedAccount[].class);
    }

    public UnbindedLinkedAccount unbindLinkedAccountToken(String linkedAccountTokenId) throws XenditException {
        String url = String.format("%s%s%s", Xendit.Opt.getXenditURL(), "/linked_account_tokens/", linkedAccountTokenId);
        return this.requestClient.request(RequestResource.Method.DELETE, url, null, this.opt.getApiKey(), UnbindedLinkedAccount.class);
    }

    public DirectDebitPaymentClient(Xendit.Option opt, NetworkClient requestClient) {
        this.opt = opt;
        this.requestClient = requestClient;
    }
}

