/*
 * Decompiled with CFR 0.152.
 */
package com.xendit.model;

import com.google.gson.annotations.SerializedName;
import com.xendit.Xendit;
import com.xendit.exception.XenditException;
import com.xendit.model.AvailableBank;
import com.xendit.model.DisbursementClient;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class Disbursement {
    @SerializedName(value="id")
    private String id;
    @SerializedName(value="user_id")
    private String userId;
    @SerializedName(value="external_id")
    private String externalId;
    @SerializedName(value="amount")
    private BigInteger amount;
    @SerializedName(value="bank_code")
    private String bankCode;
    @SerializedName(value="account_holder_name")
    private String accountHolderName;
    @SerializedName(value="disbursement_description")
    private String disbursementDescription;
    @SerializedName(value="status")
    private String status;
    @SerializedName(value="email_to")
    private String[] emailTo;
    @SerializedName(value="email_cc")
    private String[] emailCC;
    @SerializedName(value="email_bcc")
    private String[] emailBcc;
    private static DisbursementClient disbursementClient;

    public static Disbursement create(Map<String, Object> params) throws XenditException {
        return Disbursement.createRequest(new HashMap<String, String>(), params);
    }

    public static Disbursement create(Map<String, String> headers, Map<String, Object> params) throws XenditException {
        return Disbursement.createRequest(headers, params);
    }

    public static Disbursement create(String externalId, String bankCode, String accountHolderName, String accountNumber, String description, BigInteger amount) throws XenditException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("external_id", externalId);
        params.put("bank_code", bankCode);
        params.put("account_holder_name", accountHolderName);
        params.put("account_number", accountNumber);
        params.put("description", description);
        params.put("amount", amount);
        return Disbursement.createRequest(new HashMap<String, String>(), params);
    }

    public static Disbursement create(String externalId, String bankCode, String accountHolderName, String accountNumber, String description, BigInteger amount, String[] emailTo) throws XenditException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("external_id", externalId);
        params.put("bank_code", bankCode);
        params.put("account_holder_name", accountHolderName);
        params.put("account_number", accountNumber);
        params.put("description", description);
        params.put("amount", amount);
        params.put("email_to", emailTo);
        return Disbursement.createRequest(new HashMap<String, String>(), params);
    }

    public static Disbursement create(String externalId, String bankCode, String accountHolderName, String accountNumber, String description, BigInteger amount, String[] emailTo, String[] emailCc) throws XenditException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("external_id", externalId);
        params.put("bank_code", bankCode);
        params.put("account_holder_name", accountHolderName);
        params.put("account_number", accountNumber);
        params.put("description", description);
        params.put("amount", amount);
        params.put("email_to", emailTo);
        params.put("email_cc", emailCc);
        return Disbursement.createRequest(new HashMap<String, String>(), params);
    }

    public static Disbursement create(String externalId, String bankCode, String accountHolderName, String accountNumber, String description, BigInteger amount, String[] emailTo, String[] emailCc, String[] emailBcc) throws XenditException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("external_id", externalId);
        params.put("bank_code", bankCode);
        params.put("account_holder_name", accountHolderName);
        params.put("account_number", accountNumber);
        params.put("description", description);
        params.put("amount", amount);
        params.put("email_to", emailTo);
        params.put("email_cc", emailCc);
        params.put("email_bcc", emailBcc);
        return Disbursement.createRequest(new HashMap<String, String>(), params);
    }

    private static Disbursement createRequest(Map<String, String> headers, Map<String, Object> params) throws XenditException {
        DisbursementClient client = Disbursement.getClient();
        return client.createRequest(headers, params);
    }

    public static AvailableBank[] getAvailableBanks(Map<String, String> headers) throws XenditException {
        DisbursementClient client = Disbursement.getClient();
        return client.getAvailableBanks(headers);
    }

    public static AvailableBank[] getAvailableBanks() throws XenditException {
        return Disbursement.getAvailableBanks(new HashMap<String, String>());
    }

    public static Disbursement[] getByExternalId(Map<String, String> headers, String externalId) throws XenditException {
        DisbursementClient client = Disbursement.getClient();
        return client.getByExternalId(headers, externalId);
    }

    public static Disbursement[] getByExternalId(String externalId) throws XenditException {
        return Disbursement.getByExternalId(new HashMap<String, String>(), externalId);
    }

    public static Disbursement getById(Map<String, String> headers, String id) throws XenditException {
        DisbursementClient client = Disbursement.getClient();
        return client.getById(headers, id);
    }

    public static Disbursement getById(String id) throws XenditException {
        return Disbursement.getById(new HashMap<String, String>(), id);
    }

    private static DisbursementClient getClient() {
        if (Disbursement.isApiKeyExist()) {
            if (disbursementClient == null || !disbursementClient.getOpt().getApiKey().trim().equals(Xendit.apiKey.trim())) {
                disbursementClient = new DisbursementClient(Xendit.Opt.setApiKey(Xendit.apiKey), Xendit.getRequestClient());
                return disbursementClient;
            }
        } else if (disbursementClient == null || !disbursementClient.getOpt().getApiKey().trim().equals(Xendit.Opt.getApiKey().trim())) {
            disbursementClient = new DisbursementClient(Xendit.Opt, Xendit.getRequestClient());
            return disbursementClient;
        }
        return disbursementClient;
    }

    private static boolean isApiKeyExist() {
        return Xendit.apiKey != null;
    }

    Disbursement(String id, String userId, String externalId, BigInteger amount, String bankCode, String accountHolderName, String disbursementDescription, String status, String[] emailTo, String[] emailCC, String[] emailBcc) {
        this.id = id;
        this.userId = userId;
        this.externalId = externalId;
        this.amount = amount;
        this.bankCode = bankCode;
        this.accountHolderName = accountHolderName;
        this.disbursementDescription = disbursementDescription;
        this.status = status;
        this.emailTo = emailTo;
        this.emailCC = emailCC;
        this.emailBcc = emailBcc;
    }

    public static DisbursementBuilder builder() {
        return new DisbursementBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public BigInteger getAmount() {
        return this.amount;
    }

    public String getBankCode() {
        return this.bankCode;
    }

    public String getAccountHolderName() {
        return this.accountHolderName;
    }

    public String getDisbursementDescription() {
        return this.disbursementDescription;
    }

    public String getStatus() {
        return this.status;
    }

    public String[] getEmailTo() {
        return this.emailTo;
    }

    public String[] getEmailCC() {
        return this.emailCC;
    }

    public String[] getEmailBcc() {
        return this.emailBcc;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public void setAmount(BigInteger amount) {
        this.amount = amount;
    }

    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }

    public void setAccountHolderName(String accountHolderName) {
        this.accountHolderName = accountHolderName;
    }

    public void setDisbursementDescription(String disbursementDescription) {
        this.disbursementDescription = disbursementDescription;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setEmailTo(String[] emailTo) {
        this.emailTo = emailTo;
    }

    public void setEmailCC(String[] emailCC) {
        this.emailCC = emailCC;
    }

    public void setEmailBcc(String[] emailBcc) {
        this.emailBcc = emailBcc;
    }

    public static class DisbursementBuilder {
        private String id;
        private String userId;
        private String externalId;
        private BigInteger amount;
        private String bankCode;
        private String accountHolderName;
        private String disbursementDescription;
        private String status;
        private String[] emailTo;
        private String[] emailCC;
        private String[] emailBcc;

        DisbursementBuilder() {
        }

        public DisbursementBuilder id(String id) {
            this.id = id;
            return this;
        }

        public DisbursementBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public DisbursementBuilder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public DisbursementBuilder amount(BigInteger amount) {
            this.amount = amount;
            return this;
        }

        public DisbursementBuilder bankCode(String bankCode) {
            this.bankCode = bankCode;
            return this;
        }

        public DisbursementBuilder accountHolderName(String accountHolderName) {
            this.accountHolderName = accountHolderName;
            return this;
        }

        public DisbursementBuilder disbursementDescription(String disbursementDescription) {
            this.disbursementDescription = disbursementDescription;
            return this;
        }

        public DisbursementBuilder status(String status) {
            this.status = status;
            return this;
        }

        public DisbursementBuilder emailTo(String[] emailTo) {
            this.emailTo = emailTo;
            return this;
        }

        public DisbursementBuilder emailCC(String[] emailCC) {
            this.emailCC = emailCC;
            return this;
        }

        public DisbursementBuilder emailBcc(String[] emailBcc) {
            this.emailBcc = emailBcc;
            return this;
        }

        public Disbursement build() {
            return new Disbursement(this.id, this.userId, this.externalId, this.amount, this.bankCode, this.accountHolderName, this.disbursementDescription, this.status, this.emailTo, this.emailCC, this.emailBcc);
        }

        public String toString() {
            return "Disbursement.DisbursementBuilder(id=" + this.id + ", userId=" + this.userId + ", externalId=" + this.externalId + ", amount=" + this.amount + ", bankCode=" + this.bankCode + ", accountHolderName=" + this.accountHolderName + ", disbursementDescription=" + this.disbursementDescription + ", status=" + this.status + ", emailTo=" + Arrays.deepToString(this.emailTo) + ", emailCC=" + Arrays.deepToString(this.emailCC) + ", emailBcc=" + Arrays.deepToString(this.emailBcc) + ")";
        }
    }
}

