/*
 * Decompiled with CFR 0.152.
 */
package com.xendit.model;

import com.xendit.Xendit;
import com.xendit.exception.XenditException;
import com.xendit.model.AvailableBank;
import com.xendit.model.Disbursement;
import com.xendit.network.NetworkClient;
import com.xendit.network.RequestResource;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public class DisbursementClient {
    private Xendit.Option opt;
    private NetworkClient requestClient;

    public Xendit.Option getOpt() {
        return this.opt;
    }

    public Disbursement create(Map<String, Object> params) throws XenditException {
        return this.createRequest(new HashMap<String, String>(), params);
    }

    public Disbursement create(Map<String, String> headers, Map<String, Object> params) throws XenditException {
        return this.createRequest(headers, params);
    }

    public Disbursement create(String externalId, String bankCode, String accountHolderName, String accountNumber, String description, BigInteger amount) throws XenditException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("external_id", externalId);
        params.put("bank_code", bankCode);
        params.put("account_holder_name", accountHolderName);
        params.put("account_number", accountNumber);
        params.put("description", description);
        params.put("amount", amount);
        return this.createRequest(new HashMap<String, String>(), params);
    }

    public Disbursement create(String externalId, String bankCode, String accountHolderName, String accountNumber, String description, BigInteger amount, String[] emailTo) throws XenditException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("external_id", externalId);
        params.put("bank_code", bankCode);
        params.put("account_holder_name", accountHolderName);
        params.put("account_number", accountNumber);
        params.put("description", description);
        params.put("amount", amount);
        params.put("email_to", emailTo);
        return this.createRequest(new HashMap<String, String>(), params);
    }

    public Disbursement create(String externalId, String bankCode, String accountHolderName, String accountNumber, String description, BigInteger amount, String[] emailTo, String[] emailCc) throws XenditException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("external_id", externalId);
        params.put("bank_code", bankCode);
        params.put("account_holder_name", accountHolderName);
        params.put("account_number", accountNumber);
        params.put("description", description);
        params.put("amount", amount);
        params.put("email_to", emailTo);
        params.put("email_cc", emailCc);
        return this.createRequest(new HashMap<String, String>(), params);
    }

    public Disbursement create(String externalId, String bankCode, String accountHolderName, String accountNumber, String description, BigInteger amount, String[] emailTo, String[] emailCc, String[] emailBcc) throws XenditException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("external_id", externalId);
        params.put("bank_code", bankCode);
        params.put("account_holder_name", accountHolderName);
        params.put("account_number", accountNumber);
        params.put("description", description);
        params.put("amount", amount);
        params.put("email_to", emailTo);
        params.put("email_cc", emailCc);
        params.put("email_bcc", emailBcc);
        return this.createRequest(new HashMap<String, String>(), params);
    }

    public Disbursement createRequest(Map<String, String> headers, Map<String, Object> params) throws XenditException {
        String url = String.format("%s%s", this.opt.getXenditURL(), "/disbursements");
        return this.requestClient.request(RequestResource.Method.POST, url, headers, params, this.opt.getApiKey(), Disbursement.class);
    }

    public AvailableBank[] getAvailableBanks() throws XenditException {
        return this.getAvailableBanks(new HashMap<String, String>());
    }

    public AvailableBank[] getAvailableBanks(Map<String, String> headers) throws XenditException {
        String url = String.format("%s%s", this.opt.getXenditURL(), "/available_disbursements_banks");
        return this.requestClient.request(RequestResource.Method.GET, url, headers, null, this.opt.getApiKey(), AvailableBank[].class);
    }

    public Disbursement[] getByExternalId(String externalId) throws XenditException {
        return this.getByExternalId(new HashMap<String, String>(), externalId);
    }

    public Disbursement[] getByExternalId(Map<String, String> headers, String externalId) throws XenditException {
        String url = String.format("%s%s%s", this.opt.getXenditURL(), "/disbursements?external_id=", externalId);
        return this.requestClient.request(RequestResource.Method.GET, url, headers, null, this.opt.getApiKey(), Disbursement[].class);
    }

    public Disbursement getById(String id) throws XenditException {
        return this.getById(new HashMap<String, String>(), id);
    }

    public Disbursement getById(Map<String, String> headers, String id) throws XenditException {
        String url = String.format("%s%s%s", Xendit.Opt.getXenditURL(), "/disbursements/", id);
        return this.requestClient.request(RequestResource.Method.GET, url, headers, null, this.opt.getApiKey(), Disbursement.class);
    }

    public DisbursementClient(Xendit.Option opt, NetworkClient requestClient) {
        this.opt = opt;
        this.requestClient = requestClient;
    }
}

