/*
 * Decompiled with CFR 0.152.
 */
package com.xendit.model;

import com.google.gson.annotations.SerializedName;
import com.xendit.Xendit;
import com.xendit.exception.XenditException;
import com.xendit.model.EWalletBasketItem;
import com.xendit.model.EWalletClient;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class EWalletCharge {
    @SerializedName(value="id")
    private String id;
    @SerializedName(value="business_id")
    private String businessId;
    @SerializedName(value="reference_id")
    private String referenceId;
    @SerializedName(value="status")
    private String status;
    @SerializedName(value="currency")
    private String currency;
    @SerializedName(value="charge_amount")
    private String chargeAmount;
    @SerializedName(value="capture_amount")
    private String captureAmount;
    @SerializedName(value="checkout_method")
    private String checkoutMethod;
    @SerializedName(value="channel_code")
    private String channelCode;
    @SerializedName(value="channel_properties")
    private Map<String, String> channelProperties;
    @SerializedName(value="actions")
    private Map<String, String> actions;
    @SerializedName(value="is_redirect_required")
    private Boolean isRedirectRequired;
    @SerializedName(value="callback_url")
    private String callbackUrl;
    @SerializedName(value="created")
    private String created;
    @SerializedName(value="updated")
    private String updated;
    @SerializedName(value="voided_at")
    private String voidedAt;
    @SerializedName(value="capture_now")
    private Boolean captureNow;
    @SerializedName(value="customer_id")
    private String customerId;
    @SerializedName(value="payment_method_id")
    private String paymentMethodId;
    @SerializedName(value="failure_code")
    private String failureCode;
    @SerializedName(value="basket")
    private EWalletBasketItem[] basket;
    @SerializedName(value="metadata")
    private Map<String, Object> metadata;
    private static EWalletClient eWalletClient;

    public static EWalletCharge createEWalletCharge(String referenceId, String currency, Number amount, String checkoutMethod, String channelCode, Map<String, String> channelProperties, String customerId, EWalletBasketItem[] basket, Map<String, Object> metadata) throws XenditException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("reference_id", referenceId);
        params.put("currency", currency);
        params.put("amount", amount);
        params.put("checkout_method", checkoutMethod);
        params.put("channel_code", channelCode);
        params.put("channel_properties", channelProperties);
        params.put("customer_id", customerId);
        params.put("basket", basket);
        params.put("metadata", metadata);
        return EWalletCharge.createChargeRequest(new HashMap<String, String>(), params);
    }

    public static EWalletCharge createEWalletCharge(Map<String, Object> params) throws XenditException {
        return EWalletCharge.createChargeRequest(new HashMap<String, String>(), params);
    }

    public static EWalletCharge createEWalletCharge(Map<String, String> headers, Map<String, Object> params) throws XenditException {
        return EWalletCharge.createChargeRequest(headers, params);
    }

    public static EWalletCharge getEWalletChargeStatus(String chargeId) throws XenditException {
        EWalletClient client = EWalletCharge.getClient();
        return client.getEWalletChargeStatus(chargeId);
    }

    public static EWalletCharge createChargeRequest(Map<String, String> headers, Map<String, Object> params) throws XenditException {
        EWalletClient client = EWalletCharge.getClient();
        return client.createChargeRequest(headers, params);
    }

    private static EWalletClient getClient() {
        if (EWalletCharge.isApiKeyExist()) {
            if (eWalletClient == null || !eWalletClient.getOpt().getApiKey().trim().equals(Xendit.apiKey.trim())) {
                eWalletClient = new EWalletClient(Xendit.Opt.setApiKey(Xendit.apiKey), Xendit.getRequestClient());
                return eWalletClient;
            }
        } else if (eWalletClient == null || !eWalletClient.getOpt().getApiKey().trim().equals(Xendit.Opt.getApiKey().trim())) {
            eWalletClient = new EWalletClient(Xendit.Opt, Xendit.getRequestClient());
            return eWalletClient;
        }
        return eWalletClient;
    }

    private static boolean isApiKeyExist() {
        return Xendit.apiKey != null;
    }

    EWalletCharge(String id, String businessId, String referenceId, String status, String currency, String chargeAmount, String captureAmount, String checkoutMethod, String channelCode, Map<String, String> channelProperties, Map<String, String> actions, Boolean isRedirectRequired, String callbackUrl, String created, String updated, String voidedAt, Boolean captureNow, String customerId, String paymentMethodId, String failureCode, EWalletBasketItem[] basket, Map<String, Object> metadata) {
        this.id = id;
        this.businessId = businessId;
        this.referenceId = referenceId;
        this.status = status;
        this.currency = currency;
        this.chargeAmount = chargeAmount;
        this.captureAmount = captureAmount;
        this.checkoutMethod = checkoutMethod;
        this.channelCode = channelCode;
        this.channelProperties = channelProperties;
        this.actions = actions;
        this.isRedirectRequired = isRedirectRequired;
        this.callbackUrl = callbackUrl;
        this.created = created;
        this.updated = updated;
        this.voidedAt = voidedAt;
        this.captureNow = captureNow;
        this.customerId = customerId;
        this.paymentMethodId = paymentMethodId;
        this.failureCode = failureCode;
        this.basket = basket;
        this.metadata = metadata;
    }

    public static EWalletChargeBuilder builder() {
        return new EWalletChargeBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getBusinessId() {
        return this.businessId;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public String getStatus() {
        return this.status;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getChargeAmount() {
        return this.chargeAmount;
    }

    public String getCaptureAmount() {
        return this.captureAmount;
    }

    public String getCheckoutMethod() {
        return this.checkoutMethod;
    }

    public String getChannelCode() {
        return this.channelCode;
    }

    public Map<String, String> getChannelProperties() {
        return this.channelProperties;
    }

    public Map<String, String> getActions() {
        return this.actions;
    }

    public Boolean getIsRedirectRequired() {
        return this.isRedirectRequired;
    }

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public String getCreated() {
        return this.created;
    }

    public String getUpdated() {
        return this.updated;
    }

    public String getVoidedAt() {
        return this.voidedAt;
    }

    public Boolean getCaptureNow() {
        return this.captureNow;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getPaymentMethodId() {
        return this.paymentMethodId;
    }

    public String getFailureCode() {
        return this.failureCode;
    }

    public EWalletBasketItem[] getBasket() {
        return this.basket;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setBusinessId(String businessId) {
        this.businessId = businessId;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public void setChargeAmount(String chargeAmount) {
        this.chargeAmount = chargeAmount;
    }

    public void setCaptureAmount(String captureAmount) {
        this.captureAmount = captureAmount;
    }

    public void setCheckoutMethod(String checkoutMethod) {
        this.checkoutMethod = checkoutMethod;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public void setChannelProperties(Map<String, String> channelProperties) {
        this.channelProperties = channelProperties;
    }

    public void setActions(Map<String, String> actions) {
        this.actions = actions;
    }

    public void setIsRedirectRequired(Boolean isRedirectRequired) {
        this.isRedirectRequired = isRedirectRequired;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public void setCreated(String created) {
        this.created = created;
    }

    public void setUpdated(String updated) {
        this.updated = updated;
    }

    public void setVoidedAt(String voidedAt) {
        this.voidedAt = voidedAt;
    }

    public void setCaptureNow(Boolean captureNow) {
        this.captureNow = captureNow;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public void setPaymentMethodId(String paymentMethodId) {
        this.paymentMethodId = paymentMethodId;
    }

    public void setFailureCode(String failureCode) {
        this.failureCode = failureCode;
    }

    public void setBasket(EWalletBasketItem[] basket) {
        this.basket = basket;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public static class EWalletChargeBuilder {
        private String id;
        private String businessId;
        private String referenceId;
        private String status;
        private String currency;
        private String chargeAmount;
        private String captureAmount;
        private String checkoutMethod;
        private String channelCode;
        private Map<String, String> channelProperties;
        private Map<String, String> actions;
        private Boolean isRedirectRequired;
        private String callbackUrl;
        private String created;
        private String updated;
        private String voidedAt;
        private Boolean captureNow;
        private String customerId;
        private String paymentMethodId;
        private String failureCode;
        private EWalletBasketItem[] basket;
        private Map<String, Object> metadata;

        EWalletChargeBuilder() {
        }

        public EWalletChargeBuilder id(String id) {
            this.id = id;
            return this;
        }

        public EWalletChargeBuilder businessId(String businessId) {
            this.businessId = businessId;
            return this;
        }

        public EWalletChargeBuilder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public EWalletChargeBuilder status(String status) {
            this.status = status;
            return this;
        }

        public EWalletChargeBuilder currency(String currency) {
            this.currency = currency;
            return this;
        }

        public EWalletChargeBuilder chargeAmount(String chargeAmount) {
            this.chargeAmount = chargeAmount;
            return this;
        }

        public EWalletChargeBuilder captureAmount(String captureAmount) {
            this.captureAmount = captureAmount;
            return this;
        }

        public EWalletChargeBuilder checkoutMethod(String checkoutMethod) {
            this.checkoutMethod = checkoutMethod;
            return this;
        }

        public EWalletChargeBuilder channelCode(String channelCode) {
            this.channelCode = channelCode;
            return this;
        }

        public EWalletChargeBuilder channelProperties(Map<String, String> channelProperties) {
            this.channelProperties = channelProperties;
            return this;
        }

        public EWalletChargeBuilder actions(Map<String, String> actions) {
            this.actions = actions;
            return this;
        }

        public EWalletChargeBuilder isRedirectRequired(Boolean isRedirectRequired) {
            this.isRedirectRequired = isRedirectRequired;
            return this;
        }

        public EWalletChargeBuilder callbackUrl(String callbackUrl) {
            this.callbackUrl = callbackUrl;
            return this;
        }

        public EWalletChargeBuilder created(String created) {
            this.created = created;
            return this;
        }

        public EWalletChargeBuilder updated(String updated) {
            this.updated = updated;
            return this;
        }

        public EWalletChargeBuilder voidedAt(String voidedAt) {
            this.voidedAt = voidedAt;
            return this;
        }

        public EWalletChargeBuilder captureNow(Boolean captureNow) {
            this.captureNow = captureNow;
            return this;
        }

        public EWalletChargeBuilder customerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public EWalletChargeBuilder paymentMethodId(String paymentMethodId) {
            this.paymentMethodId = paymentMethodId;
            return this;
        }

        public EWalletChargeBuilder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        public EWalletChargeBuilder basket(EWalletBasketItem[] basket) {
            this.basket = basket;
            return this;
        }

        public EWalletChargeBuilder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public EWalletCharge build() {
            return new EWalletCharge(this.id, this.businessId, this.referenceId, this.status, this.currency, this.chargeAmount, this.captureAmount, this.checkoutMethod, this.channelCode, this.channelProperties, this.actions, this.isRedirectRequired, this.callbackUrl, this.created, this.updated, this.voidedAt, this.captureNow, this.customerId, this.paymentMethodId, this.failureCode, this.basket, this.metadata);
        }

        public String toString() {
            return "EWalletCharge.EWalletChargeBuilder(id=" + this.id + ", businessId=" + this.businessId + ", referenceId=" + this.referenceId + ", status=" + this.status + ", currency=" + this.currency + ", chargeAmount=" + this.chargeAmount + ", captureAmount=" + this.captureAmount + ", checkoutMethod=" + this.checkoutMethod + ", channelCode=" + this.channelCode + ", channelProperties=" + this.channelProperties + ", actions=" + this.actions + ", isRedirectRequired=" + this.isRedirectRequired + ", callbackUrl=" + this.callbackUrl + ", created=" + this.created + ", updated=" + this.updated + ", voidedAt=" + this.voidedAt + ", captureNow=" + this.captureNow + ", customerId=" + this.customerId + ", paymentMethodId=" + this.paymentMethodId + ", failureCode=" + this.failureCode + ", basket=" + Arrays.deepToString(this.basket) + ", metadata=" + this.metadata + ")";
        }
    }
}

