/*
 * Decompiled with CFR 0.152.
 */
package com.xendit.model;

import com.google.gson.annotations.SerializedName;
import com.xendit.Xendit;
import com.xendit.exception.XenditException;
import com.xendit.model.EWalletClient;
import com.xendit.model.EWalletLinkajaItem;
import java.util.HashMap;
import java.util.Map;

public class EWalletPayment {
    @SerializedName(value="id")
    private String id;
    @SerializedName(value="external_id")
    private String externalId;
    @SerializedName(value="business_id")
    private String businessId;
    @SerializedName(value="phone")
    private String phone;
    @SerializedName(value="amount")
    private Number amount;
    @SerializedName(value="expiration_date")
    private String expirationDate;
    @SerializedName(value="ewallet_type")
    private String ewalletType;
    @SerializedName(value="transaction_date")
    private String transactionDate;
    @SerializedName(value="checkout_url")
    private String checkoutUrl;
    @SerializedName(value="status")
    private String status;
    private static EWalletClient eWalletClient;

    public static EWalletPayment createLinkajaPayment(String externalId, Number amount, String phone, EWalletLinkajaItem[] items, String callbackUrl, String redirectUrl) throws XenditException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("external_id", externalId);
        params.put("amount", amount);
        params.put("phone", phone);
        params.put("items", items);
        params.put("ewallet_type", (Object)EWalletType.LINKAJA);
        params.put("callback_url", callbackUrl);
        params.put("redirect_url", redirectUrl);
        return EWalletPayment.createPaymentRequest(new HashMap<String, String>(), params);
    }

    public static EWalletPayment createOvoPayment(String externalId, Number amount, String phone) throws XenditException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("external_id", externalId);
        params.put("amount", amount);
        params.put("phone", phone);
        params.put("ewallet_type", (Object)EWalletType.OVO);
        return EWalletPayment.createPaymentRequest(new HashMap<String, String>(), params);
    }

    public static EWalletPayment createDanaPayment(String externalId, Number amount, String phone, String expirationDate, String callbackUrl, String redirectUrl) throws XenditException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("external_id", externalId);
        params.put("amount", amount);
        params.put("phone", phone);
        params.put("expiration_date", expirationDate);
        params.put("callback_url", callbackUrl);
        params.put("redirect_url", redirectUrl);
        params.put("ewallet_type", (Object)EWalletType.DANA);
        return EWalletPayment.createPaymentRequest(new HashMap<String, String>(), params);
    }

    public static EWalletPayment getPaymentStatus(String externalId, EWalletType ewalletType) throws XenditException {
        EWalletClient client = EWalletPayment.getClient();
        return client.getPaymentStatus(externalId, ewalletType);
    }

    public static EWalletPayment createPaymentRequest(Map<String, String> headers, Map<String, Object> params) throws XenditException {
        EWalletClient client = EWalletPayment.getClient();
        return client.createPaymentRequest(headers, params);
    }

    private static EWalletClient getClient() {
        if (EWalletPayment.isApiKeyExist()) {
            if (eWalletClient == null || !eWalletClient.getOpt().getApiKey().trim().equals(Xendit.apiKey.trim())) {
                eWalletClient = new EWalletClient(Xendit.Opt.setApiKey(Xendit.apiKey), Xendit.getRequestClient());
                return eWalletClient;
            }
        } else if (eWalletClient == null || !eWalletClient.getOpt().getApiKey().trim().equals(Xendit.Opt.getApiKey().trim())) {
            eWalletClient = new EWalletClient(Xendit.Opt, Xendit.getRequestClient());
            return eWalletClient;
        }
        return eWalletClient;
    }

    private static boolean isApiKeyExist() {
        return Xendit.apiKey != null;
    }

    EWalletPayment(String id, String externalId, String businessId, String phone, Number amount, String expirationDate, String ewalletType, String transactionDate, String checkoutUrl, String status) {
        this.id = id;
        this.externalId = externalId;
        this.businessId = businessId;
        this.phone = phone;
        this.amount = amount;
        this.expirationDate = expirationDate;
        this.ewalletType = ewalletType;
        this.transactionDate = transactionDate;
        this.checkoutUrl = checkoutUrl;
        this.status = status;
    }

    public static EWalletPaymentBuilder builder() {
        return new EWalletPaymentBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public String getBusinessId() {
        return this.businessId;
    }

    public String getPhone() {
        return this.phone;
    }

    public Number getAmount() {
        return this.amount;
    }

    public String getExpirationDate() {
        return this.expirationDate;
    }

    public String getEwalletType() {
        return this.ewalletType;
    }

    public String getTransactionDate() {
        return this.transactionDate;
    }

    public String getCheckoutUrl() {
        return this.checkoutUrl;
    }

    public String getStatus() {
        return this.status;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public void setBusinessId(String businessId) {
        this.businessId = businessId;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public void setAmount(Number amount) {
        this.amount = amount;
    }

    public void setExpirationDate(String expirationDate) {
        this.expirationDate = expirationDate;
    }

    public void setEwalletType(String ewalletType) {
        this.ewalletType = ewalletType;
    }

    public void setTransactionDate(String transactionDate) {
        this.transactionDate = transactionDate;
    }

    public void setCheckoutUrl(String checkoutUrl) {
        this.checkoutUrl = checkoutUrl;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public static class EWalletPaymentBuilder {
        private String id;
        private String externalId;
        private String businessId;
        private String phone;
        private Number amount;
        private String expirationDate;
        private String ewalletType;
        private String transactionDate;
        private String checkoutUrl;
        private String status;

        EWalletPaymentBuilder() {
        }

        public EWalletPaymentBuilder id(String id) {
            this.id = id;
            return this;
        }

        public EWalletPaymentBuilder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public EWalletPaymentBuilder businessId(String businessId) {
            this.businessId = businessId;
            return this;
        }

        public EWalletPaymentBuilder phone(String phone) {
            this.phone = phone;
            return this;
        }

        public EWalletPaymentBuilder amount(Number amount) {
            this.amount = amount;
            return this;
        }

        public EWalletPaymentBuilder expirationDate(String expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public EWalletPaymentBuilder ewalletType(String ewalletType) {
            this.ewalletType = ewalletType;
            return this;
        }

        public EWalletPaymentBuilder transactionDate(String transactionDate) {
            this.transactionDate = transactionDate;
            return this;
        }

        public EWalletPaymentBuilder checkoutUrl(String checkoutUrl) {
            this.checkoutUrl = checkoutUrl;
            return this;
        }

        public EWalletPaymentBuilder status(String status) {
            this.status = status;
            return this;
        }

        public EWalletPayment build() {
            return new EWalletPayment(this.id, this.externalId, this.businessId, this.phone, this.amount, this.expirationDate, this.ewalletType, this.transactionDate, this.checkoutUrl, this.status);
        }

        public String toString() {
            return "EWalletPayment.EWalletPaymentBuilder(id=" + this.id + ", externalId=" + this.externalId + ", businessId=" + this.businessId + ", phone=" + this.phone + ", amount=" + this.amount + ", expirationDate=" + this.expirationDate + ", ewalletType=" + this.ewalletType + ", transactionDate=" + this.transactionDate + ", checkoutUrl=" + this.checkoutUrl + ", status=" + this.status + ")";
        }
    }

    public static enum EWalletType {
        DANA,
        OVO,
        LINKAJA;

    }
}

