/*
 * Decompiled with CFR 0.152.
 */
package com.xendit.model;

import com.google.gson.annotations.SerializedName;
import com.xendit.Xendit;
import com.xendit.exception.XenditException;
import com.xendit.model.AvailableBank;
import com.xendit.model.FixedVirtualAccountClient;
import com.xendit.model.FixedVirtualAccountPayment;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class FixedVirtualAccount {
    @SerializedName(value="id")
    private String id;
    @SerializedName(value="owner_id")
    private String ownerId;
    @SerializedName(value="external_id")
    private String externalId;
    @SerializedName(value="merchant_code")
    private String merchantCode;
    @SerializedName(value="account_number")
    private String accountNumber;
    @SerializedName(value="bank_code")
    private String bankCode;
    @SerializedName(value="name")
    private String name;
    @SerializedName(value="is_closed")
    private Boolean isClosed;
    @SerializedName(value="expiration_date")
    private Date expirationDate;
    @SerializedName(value="is_single_use")
    private Boolean isSingleUse;
    @SerializedName(value="status")
    private String status;
    @SerializedName(value="suggested_amount")
    private Long suggestedAmount;
    @SerializedName(value="expected_amount")
    private Long expectedAmount;
    @SerializedName(value="currency")
    private String currency;
    @SerializedName(value="description")
    private String description;
    private static FixedVirtualAccountClient fixedVirtualAccountClient;

    public static FixedVirtualAccount createClosed(Map<String, Object> params) throws XenditException {
        return FixedVirtualAccount.create(new HashMap<String, String>(), params, true);
    }

    public static FixedVirtualAccount createClosed(Map<String, String> headers, Map<String, Object> params) throws XenditException {
        return FixedVirtualAccount.create(headers, params, true);
    }

    public static FixedVirtualAccount createClosed(String externalId, String bankCode, String name, Long expectedAmount) throws XenditException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("external_id", externalId);
        params.put("bank_code", bankCode);
        params.put("name", name);
        params.put("expected_amount", expectedAmount);
        return FixedVirtualAccount.create(new HashMap<String, String>(), params, true);
    }

    public static FixedVirtualAccount createClosed(String externalId, String bankCode, String name, Long expectedAmount, Map<String, Object> additionalParam) throws XenditException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("external_id", externalId);
        params.put("bank_code", bankCode);
        params.put("name", name);
        params.put("expected_amount", expectedAmount);
        params.putAll(additionalParam);
        return FixedVirtualAccount.create(new HashMap<String, String>(), params, true);
    }

    public static FixedVirtualAccount createOpen(Map<String, Object> params) throws XenditException {
        return FixedVirtualAccount.create(new HashMap<String, String>(), params, false);
    }

    public static FixedVirtualAccount createOpen(Map<String, String> headers, Map<String, Object> params) throws XenditException {
        return FixedVirtualAccount.create(headers, params, false);
    }

    public static FixedVirtualAccount createOpen(String externalId, String bankCode, String name) throws XenditException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("external_id", externalId);
        params.put("bank_code", bankCode);
        params.put("name", name);
        return FixedVirtualAccount.create(new HashMap<String, String>(), params, false);
    }

    public static FixedVirtualAccount createOpen(String externalId, String bankCode, String name, Map<String, Object> additionalParam) throws XenditException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("external_id", externalId);
        params.put("bank_code", bankCode);
        params.put("name", name);
        params.putAll(additionalParam);
        return FixedVirtualAccount.create(new HashMap<String, String>(), params, false);
    }

    public static AvailableBank[] getAvailableBanks() throws XenditException {
        FixedVirtualAccountClient client = FixedVirtualAccount.getClient();
        return client.getAvailableBanks();
    }

    public static FixedVirtualAccount getFixedVA(Map<String, String> headers, String id) throws XenditException {
        FixedVirtualAccountClient client = FixedVirtualAccount.getClient();
        return client.getFixedVA(headers, id);
    }

    public static FixedVirtualAccount getFixedVA(String id) throws XenditException {
        return FixedVirtualAccount.getFixedVA(new HashMap<String, String>(), id);
    }

    public static FixedVirtualAccount update(String id, Map<String, Object> params) throws XenditException {
        FixedVirtualAccountClient client = FixedVirtualAccount.getClient();
        return client.update(id, params);
    }

    public static FixedVirtualAccountPayment getPayment(String paymentId) throws XenditException {
        FixedVirtualAccountClient client = FixedVirtualAccount.getClient();
        return client.getPayment(paymentId);
    }

    private static FixedVirtualAccount create(Map<String, String> headers, Map<String, Object> params, Boolean isClosed) throws XenditException {
        FixedVirtualAccountClient client = FixedVirtualAccount.getClient();
        return client.create(headers, params, isClosed);
    }

    private static FixedVirtualAccountClient getClient() {
        if (FixedVirtualAccount.isApiKeyExist()) {
            if (fixedVirtualAccountClient == null || !fixedVirtualAccountClient.getOpt().getApiKey().trim().equals(Xendit.apiKey.trim())) {
                fixedVirtualAccountClient = new FixedVirtualAccountClient(Xendit.Opt.setApiKey(Xendit.apiKey), Xendit.getRequestClient());
                return fixedVirtualAccountClient;
            }
        } else if (fixedVirtualAccountClient == null || !fixedVirtualAccountClient.getOpt().getApiKey().trim().equals(Xendit.Opt.getApiKey().trim())) {
            fixedVirtualAccountClient = new FixedVirtualAccountClient(Xendit.Opt, Xendit.getRequestClient());
            return fixedVirtualAccountClient;
        }
        return fixedVirtualAccountClient;
    }

    private static boolean isApiKeyExist() {
        return Xendit.apiKey != null;
    }

    FixedVirtualAccount(String id, String ownerId, String externalId, String merchantCode, String accountNumber, String bankCode, String name, Boolean isClosed, Date expirationDate, Boolean isSingleUse, String status, Long suggestedAmount, Long expectedAmount, String currency, String description) {
        this.id = id;
        this.ownerId = ownerId;
        this.externalId = externalId;
        this.merchantCode = merchantCode;
        this.accountNumber = accountNumber;
        this.bankCode = bankCode;
        this.name = name;
        this.isClosed = isClosed;
        this.expirationDate = expirationDate;
        this.isSingleUse = isSingleUse;
        this.status = status;
        this.suggestedAmount = suggestedAmount;
        this.expectedAmount = expectedAmount;
        this.currency = currency;
        this.description = description;
    }

    public static FixedVirtualAccountBuilder builder() {
        return new FixedVirtualAccountBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public String getMerchantCode() {
        return this.merchantCode;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public String getBankCode() {
        return this.bankCode;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getIsClosed() {
        return this.isClosed;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public Boolean getIsSingleUse() {
        return this.isSingleUse;
    }

    public String getStatus() {
        return this.status;
    }

    public Long getSuggestedAmount() {
        return this.suggestedAmount;
    }

    public Long getExpectedAmount() {
        return this.expectedAmount;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getDescription() {
        return this.description;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public void setMerchantCode(String merchantCode) {
        this.merchantCode = merchantCode;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setIsClosed(Boolean isClosed) {
        this.isClosed = isClosed;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public void setIsSingleUse(Boolean isSingleUse) {
        this.isSingleUse = isSingleUse;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setSuggestedAmount(Long suggestedAmount) {
        this.suggestedAmount = suggestedAmount;
    }

    public void setExpectedAmount(Long expectedAmount) {
        this.expectedAmount = expectedAmount;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public static class FixedVirtualAccountBuilder {
        private String id;
        private String ownerId;
        private String externalId;
        private String merchantCode;
        private String accountNumber;
        private String bankCode;
        private String name;
        private Boolean isClosed;
        private Date expirationDate;
        private Boolean isSingleUse;
        private String status;
        private Long suggestedAmount;
        private Long expectedAmount;
        private String currency;
        private String description;

        FixedVirtualAccountBuilder() {
        }

        public FixedVirtualAccountBuilder id(String id) {
            this.id = id;
            return this;
        }

        public FixedVirtualAccountBuilder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public FixedVirtualAccountBuilder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public FixedVirtualAccountBuilder merchantCode(String merchantCode) {
            this.merchantCode = merchantCode;
            return this;
        }

        public FixedVirtualAccountBuilder accountNumber(String accountNumber) {
            this.accountNumber = accountNumber;
            return this;
        }

        public FixedVirtualAccountBuilder bankCode(String bankCode) {
            this.bankCode = bankCode;
            return this;
        }

        public FixedVirtualAccountBuilder name(String name) {
            this.name = name;
            return this;
        }

        public FixedVirtualAccountBuilder isClosed(Boolean isClosed) {
            this.isClosed = isClosed;
            return this;
        }

        public FixedVirtualAccountBuilder expirationDate(Date expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public FixedVirtualAccountBuilder isSingleUse(Boolean isSingleUse) {
            this.isSingleUse = isSingleUse;
            return this;
        }

        public FixedVirtualAccountBuilder status(String status) {
            this.status = status;
            return this;
        }

        public FixedVirtualAccountBuilder suggestedAmount(Long suggestedAmount) {
            this.suggestedAmount = suggestedAmount;
            return this;
        }

        public FixedVirtualAccountBuilder expectedAmount(Long expectedAmount) {
            this.expectedAmount = expectedAmount;
            return this;
        }

        public FixedVirtualAccountBuilder currency(String currency) {
            this.currency = currency;
            return this;
        }

        public FixedVirtualAccountBuilder description(String description) {
            this.description = description;
            return this;
        }

        public FixedVirtualAccount build() {
            return new FixedVirtualAccount(this.id, this.ownerId, this.externalId, this.merchantCode, this.accountNumber, this.bankCode, this.name, this.isClosed, this.expirationDate, this.isSingleUse, this.status, this.suggestedAmount, this.expectedAmount, this.currency, this.description);
        }

        public String toString() {
            return "FixedVirtualAccount.FixedVirtualAccountBuilder(id=" + this.id + ", ownerId=" + this.ownerId + ", externalId=" + this.externalId + ", merchantCode=" + this.merchantCode + ", accountNumber=" + this.accountNumber + ", bankCode=" + this.bankCode + ", name=" + this.name + ", isClosed=" + this.isClosed + ", expirationDate=" + this.expirationDate + ", isSingleUse=" + this.isSingleUse + ", status=" + this.status + ", suggestedAmount=" + this.suggestedAmount + ", expectedAmount=" + this.expectedAmount + ", currency=" + this.currency + ", description=" + this.description + ")";
        }
    }
}

