/*
 * Decompiled with CFR 0.152.
 */
package com.xendit.model;

import com.xendit.Xendit;
import com.xendit.exception.ParamException;
import com.xendit.exception.XenditException;
import com.xendit.model.AvailableBank;
import com.xendit.model.FixedVirtualAccount;
import com.xendit.model.FixedVirtualAccountPayment;
import com.xendit.network.NetworkClient;
import com.xendit.network.RequestResource;
import java.util.HashMap;
import java.util.Map;

public class FixedVirtualAccountClient {
    private Xendit.Option opt;
    private NetworkClient requestClient;

    public Xendit.Option getOpt() {
        return this.opt;
    }

    public FixedVirtualAccount createClosed(Map<String, Object> params) throws XenditException {
        return this.create(new HashMap<String, String>(), params, true);
    }

    public FixedVirtualAccount createClosed(Map<String, String> headers, Map<String, Object> params) throws XenditException {
        return this.create(headers, params, true);
    }

    public FixedVirtualAccount createClosed(String externalId, String bankCode, String name, Long expectedAmount) throws XenditException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("external_id", externalId);
        params.put("bank_code", bankCode);
        params.put("name", name);
        params.put("expected_amount", expectedAmount);
        return this.create(new HashMap<String, String>(), params, true);
    }

    public FixedVirtualAccount createClosed(String externalId, String bankCode, String name, Long expectedAmount, Map<String, Object> additionalParam) throws XenditException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("external_id", externalId);
        params.put("bank_code", bankCode);
        params.put("name", name);
        params.put("expected_amount", expectedAmount);
        params.putAll(additionalParam);
        return this.create(new HashMap<String, String>(), params, true);
    }

    public FixedVirtualAccount createOpen(Map<String, Object> params) throws XenditException {
        return this.create(new HashMap<String, String>(), params, false);
    }

    public FixedVirtualAccount createOpen(Map<String, String> headers, Map<String, Object> params) throws XenditException {
        return this.create(headers, params, false);
    }

    public FixedVirtualAccount createOpen(String externalId, String bankCode, String name) throws XenditException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("external_id", externalId);
        params.put("bank_code", bankCode);
        params.put("name", name);
        return this.create(new HashMap<String, String>(), params, false);
    }

    public FixedVirtualAccount createOpen(String externalId, String bankCode, String name, Map<String, Object> additionalParam) throws XenditException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("external_id", externalId);
        params.put("bank_code", bankCode);
        params.put("name", name);
        params.putAll(additionalParam);
        return this.create(new HashMap<String, String>(), params, false);
    }

    public AvailableBank[] getAvailableBanks() throws XenditException {
        String url = String.format("%s%s", Xendit.Opt.getXenditURL(), "/available_virtual_account_banks");
        return this.requestClient.request(RequestResource.Method.GET, url, null, this.opt.getApiKey(), AvailableBank[].class);
    }

    public FixedVirtualAccount getFixedVA(Map<String, String> headers, String id) throws XenditException {
        String url = String.format("%s%s%s", Xendit.Opt.getXenditURL(), "/callback_virtual_accounts/", id);
        return this.requestClient.request(RequestResource.Method.GET, url, headers, null, this.opt.getApiKey(), FixedVirtualAccount.class);
    }

    public FixedVirtualAccount getFixedVA(String id) throws XenditException {
        return this.getFixedVA(new HashMap<String, String>(), id);
    }

    public FixedVirtualAccount update(String id, Map<String, Object> params) throws XenditException {
        String url = String.format("%s%s%s", Xendit.Opt.getXenditURL(), "/callback_virtual_accounts/", id);
        return this.requestClient.request(RequestResource.Method.PATCH, url, params, this.opt.getApiKey(), FixedVirtualAccount.class);
    }

    public FixedVirtualAccountPayment getPayment(String paymentId) throws XenditException {
        String url = String.format("%s%s%s", Xendit.Opt.getXenditURL(), "/callback_virtual_account_payments/payment_id=", paymentId);
        return this.requestClient.request(RequestResource.Method.GET, url, null, this.opt.getApiKey(), FixedVirtualAccountPayment.class);
    }

    public FixedVirtualAccount create(Map<String, String> headers, Map<String, Object> params, Boolean isClosed) throws XenditException {
        String url = String.format("%s%s", Xendit.Opt.getXenditURL(), "/callback_virtual_accounts");
        params.put("is_closed", isClosed);
        if (isClosed.booleanValue() && params.containsKey("suggested_amount")) {
            throw new ParamException("Suggested amount is not supported for closed VA");
        }
        return this.requestClient.request(RequestResource.Method.POST, url, headers, params, this.opt.getApiKey(), FixedVirtualAccount.class);
    }

    public FixedVirtualAccountClient(Xendit.Option opt, NetworkClient requestClient) {
        this.opt = opt;
        this.requestClient = requestClient;
    }
}

