/*
 * Decompiled with CFR 0.152.
 */
package com.xendit.model;

import com.google.gson.annotations.SerializedName;
import com.xendit.exception.XenditException;
import com.xendit.model.DirectDebitPayment;
import com.xendit.model.DirectDebitPaymentClient;
import com.xendit.model.LinkedAccountEnum;
import java.util.HashMap;
import java.util.Map;

public class InitializedLinkedAccount {
    @SerializedName(value="id")
    private String id;
    @SerializedName(value="customer_id")
    private String customerId;
    @SerializedName(value="channel_code")
    private LinkedAccountEnum.ChannelCode channelCode;
    @SerializedName(value="authorizer_url")
    private String authorizerUrl;
    @SerializedName(value="status")
    private String status;
    @SerializedName(value="metadata")
    private Map<String, Object> metadata;

    public static InitializedLinkedAccount initializeLinkedAccountTokenization(String customerId, LinkedAccountEnum.ChannelCode channelCode, Map<String, Object> properties, Map<String, Object> metadata) throws XenditException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("customer_id", customerId);
        params.put("channel_code", (Object)channelCode);
        params.put("properties", properties);
        params.put("metadata", metadata);
        return InitializedLinkedAccount.initializeLinkedAccountTokenizationRequest(new HashMap<String, String>(), params);
    }

    public static InitializedLinkedAccount initializeLinkedAccountTokenization(Map<String, Object> params) throws XenditException {
        return InitializedLinkedAccount.initializeLinkedAccountTokenizationRequest(new HashMap<String, String>(), params);
    }

    public static InitializedLinkedAccount initializeLinkedAccountTokenization(Map<String, String> headers, Map<String, Object> params) throws XenditException {
        return InitializedLinkedAccount.initializeLinkedAccountTokenizationRequest(headers, params);
    }

    private static InitializedLinkedAccount initializeLinkedAccountTokenizationRequest(Map<String, String> headers, Map<String, Object> params) throws XenditException {
        DirectDebitPaymentClient client = DirectDebitPayment.getClient();
        return client.initializeLinkedAccountTokenizationRequest(headers, params);
    }

    InitializedLinkedAccount(String id, String customerId, LinkedAccountEnum.ChannelCode channelCode, String authorizerUrl, String status, Map<String, Object> metadata) {
        this.id = id;
        this.customerId = customerId;
        this.channelCode = channelCode;
        this.authorizerUrl = authorizerUrl;
        this.status = status;
        this.metadata = metadata;
    }

    public static InitializedLinkedAccountBuilder builder() {
        return new InitializedLinkedAccountBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public LinkedAccountEnum.ChannelCode getChannelCode() {
        return this.channelCode;
    }

    public String getAuthorizerUrl() {
        return this.authorizerUrl;
    }

    public String getStatus() {
        return this.status;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public void setChannelCode(LinkedAccountEnum.ChannelCode channelCode) {
        this.channelCode = channelCode;
    }

    public void setAuthorizerUrl(String authorizerUrl) {
        this.authorizerUrl = authorizerUrl;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public static class InitializedLinkedAccountBuilder {
        private String id;
        private String customerId;
        private LinkedAccountEnum.ChannelCode channelCode;
        private String authorizerUrl;
        private String status;
        private Map<String, Object> metadata;

        InitializedLinkedAccountBuilder() {
        }

        public InitializedLinkedAccountBuilder id(String id) {
            this.id = id;
            return this;
        }

        public InitializedLinkedAccountBuilder customerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public InitializedLinkedAccountBuilder channelCode(LinkedAccountEnum.ChannelCode channelCode) {
            this.channelCode = channelCode;
            return this;
        }

        public InitializedLinkedAccountBuilder authorizerUrl(String authorizerUrl) {
            this.authorizerUrl = authorizerUrl;
            return this;
        }

        public InitializedLinkedAccountBuilder status(String status) {
            this.status = status;
            return this;
        }

        public InitializedLinkedAccountBuilder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public InitializedLinkedAccount build() {
            return new InitializedLinkedAccount(this.id, this.customerId, this.channelCode, this.authorizerUrl, this.status, this.metadata);
        }

        public String toString() {
            return "InitializedLinkedAccount.InitializedLinkedAccountBuilder(id=" + this.id + ", customerId=" + this.customerId + ", channelCode=" + (Object)((Object)this.channelCode) + ", authorizerUrl=" + this.authorizerUrl + ", status=" + this.status + ", metadata=" + this.metadata + ")";
        }
    }
}

