/*
 * Decompiled with CFR 0.152.
 */
package com.xendit.model;

import com.google.gson.annotations.SerializedName;
import com.xendit.Xendit;
import com.xendit.exception.XenditException;
import com.xendit.model.AvailableBankInvoice;
import com.xendit.model.AvailableEwalletInvoice;
import com.xendit.model.AvailableRetailOutletInvoice;
import com.xendit.model.InvoiceClient;
import com.xendit.model.ItemInvoice;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class Invoice {
    @SerializedName(value="id")
    private String id;
    @SerializedName(value="external_id")
    private String externalId;
    @SerializedName(value="user_id")
    private String userId;
    @SerializedName(value="status")
    private String status;
    @SerializedName(value="merchant_name")
    private String merchantName;
    @SerializedName(value="merchant_profile_picture_url")
    private String merchantProfilePictureUrl;
    @SerializedName(value="bank_code")
    private String bankCode;
    @SerializedName(value="amount")
    private Number amount;
    @SerializedName(value="initial_amount")
    private Number initialAmount;
    @SerializedName(value="payer_email")
    private String payerEmail;
    @SerializedName(value="description")
    private String description;
    @SerializedName(value="expiry_date")
    private String expiryDate;
    @SerializedName(value="invoice_url")
    private String invoiceUrl;
    @SerializedName(value="available_banks")
    private AvailableBankInvoice[] availableBanks;
    @SerializedName(value="available_retail_outlets")
    private AvailableRetailOutletInvoice[] availableRetailOutlets;
    @SerializedName(value="available_ewallets")
    private AvailableEwalletInvoice[] availableEwallets;
    @SerializedName(value="paid_at")
    private String paidAt;
    @SerializedName(value="paid_amount")
    private Number paidAmount;
    @SerializedName(value="adjusted_received_amount")
    private Number adjustedReceivedAmount;
    @SerializedName(value="should_exclude_credit_card")
    private Boolean shouldExcludeCreditCard;
    @SerializedName(value="should_send_email")
    private Boolean shouldSendEmail;
    @SerializedName(value="created")
    private String created;
    @SerializedName(value="updated")
    private String updated;
    @SerializedName(value="currency")
    private String currency;
    @SerializedName(value="initial_currency")
    private String initialCurrency;
    @SerializedName(value="on_demand_link")
    private String onDemandLink;
    @SerializedName(value="on_demand_payload")
    private Object onDemandPayload;
    @SerializedName(value="recurring_payment_id")
    private String recurringPaymentId;
    @SerializedName(value="credit_card_charge_id")
    private String creditCardChargeId;
    @SerializedName(value="mid_label")
    private String midLabel;
    @SerializedName(value="payment_channel")
    private String paymentChannel;
    @SerializedName(value="payment_method")
    private String paymentMethod;
    @SerializedName(value="payment_destination")
    private String paymentDestination;
    @SerializedName(value="success_redirect_url")
    private String successRedirectUrl;
    @SerializedName(value="failure_redirect_url")
    private String failureRedirectUrl;
    @SerializedName(value="items")
    private ItemInvoice[] items;
    @SerializedName(value="fixed_va")
    private Boolean fixedVa;
    private static InvoiceClient invoiceClient;

    public static Invoice create(String externalId, Number amount, String payerEmail, String description) throws XenditException {
        InvoiceClient client = Invoice.getClient();
        return client.create(externalId, amount, payerEmail, description);
    }

    public static Invoice create(Map<String, Object> params) throws XenditException {
        return Invoice.create(new HashMap<String, String>(), params);
    }

    public static Invoice create(Map<String, String> headers, Map<String, Object> params) throws XenditException {
        InvoiceClient client = Invoice.getClient();
        return client.create(headers, params);
    }

    public static Invoice getById(Map<String, String> headers, String id) throws XenditException {
        InvoiceClient client = Invoice.getClient();
        return client.getById(headers, id);
    }

    public static Invoice getById(String id) throws XenditException {
        return Invoice.getById(new HashMap<String, String>(), id);
    }

    public static Invoice[] getAll(Map<String, String> headers, Map<String, Object> params) throws XenditException {
        InvoiceClient client = Invoice.getClient();
        return client.getAll(headers, params);
    }

    public static Invoice[] getAll(Map<String, Object> params) throws XenditException {
        return Invoice.getAll(new HashMap<String, String>(), params);
    }

    public static Invoice expire(Map<String, String> headers, String id) throws XenditException {
        InvoiceClient client = Invoice.getClient();
        return client.expire(headers, id);
    }

    public static Invoice expire(String id) throws XenditException {
        return Invoice.expire(new HashMap<String, String>(), id);
    }

    private static InvoiceClient getClient() {
        if (Invoice.isApiKeyExist()) {
            if (invoiceClient == null || !invoiceClient.getOpt().getApiKey().trim().equals(Xendit.apiKey.trim())) {
                invoiceClient = new InvoiceClient(Xendit.Opt.setApiKey(Xendit.apiKey), Xendit.getRequestClient());
                return invoiceClient;
            }
        } else if (invoiceClient == null || !invoiceClient.getOpt().getApiKey().trim().equals(Xendit.Opt.getApiKey().trim())) {
            invoiceClient = new InvoiceClient(Xendit.Opt, Xendit.getRequestClient());
            return invoiceClient;
        }
        return invoiceClient;
    }

    private static boolean isApiKeyExist() {
        return Xendit.apiKey != null;
    }

    Invoice(String id, String externalId, String userId, String status, String merchantName, String merchantProfilePictureUrl, String bankCode, Number amount, Number initialAmount, String payerEmail, String description, String expiryDate, String invoiceUrl, AvailableBankInvoice[] availableBanks, AvailableRetailOutletInvoice[] availableRetailOutlets, AvailableEwalletInvoice[] availableEwallets, String paidAt, Number paidAmount, Number adjustedReceivedAmount, Boolean shouldExcludeCreditCard, Boolean shouldSendEmail, String created, String updated, String currency, String initialCurrency, String onDemandLink, Object onDemandPayload, String recurringPaymentId, String creditCardChargeId, String midLabel, String paymentChannel, String paymentMethod, String paymentDestination, String successRedirectUrl, String failureRedirectUrl, ItemInvoice[] items, Boolean fixedVa) {
        this.id = id;
        this.externalId = externalId;
        this.userId = userId;
        this.status = status;
        this.merchantName = merchantName;
        this.merchantProfilePictureUrl = merchantProfilePictureUrl;
        this.bankCode = bankCode;
        this.amount = amount;
        this.initialAmount = initialAmount;
        this.payerEmail = payerEmail;
        this.description = description;
        this.expiryDate = expiryDate;
        this.invoiceUrl = invoiceUrl;
        this.availableBanks = availableBanks;
        this.availableRetailOutlets = availableRetailOutlets;
        this.availableEwallets = availableEwallets;
        this.paidAt = paidAt;
        this.paidAmount = paidAmount;
        this.adjustedReceivedAmount = adjustedReceivedAmount;
        this.shouldExcludeCreditCard = shouldExcludeCreditCard;
        this.shouldSendEmail = shouldSendEmail;
        this.created = created;
        this.updated = updated;
        this.currency = currency;
        this.initialCurrency = initialCurrency;
        this.onDemandLink = onDemandLink;
        this.onDemandPayload = onDemandPayload;
        this.recurringPaymentId = recurringPaymentId;
        this.creditCardChargeId = creditCardChargeId;
        this.midLabel = midLabel;
        this.paymentChannel = paymentChannel;
        this.paymentMethod = paymentMethod;
        this.paymentDestination = paymentDestination;
        this.successRedirectUrl = successRedirectUrl;
        this.failureRedirectUrl = failureRedirectUrl;
        this.items = items;
        this.fixedVa = fixedVa;
    }

    public static InvoiceBuilder builder() {
        return new InvoiceBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getStatus() {
        return this.status;
    }

    public String getMerchantName() {
        return this.merchantName;
    }

    public String getMerchantProfilePictureUrl() {
        return this.merchantProfilePictureUrl;
    }

    public String getBankCode() {
        return this.bankCode;
    }

    public Number getAmount() {
        return this.amount;
    }

    public Number getInitialAmount() {
        return this.initialAmount;
    }

    public String getPayerEmail() {
        return this.payerEmail;
    }

    public String getDescription() {
        return this.description;
    }

    public String getExpiryDate() {
        return this.expiryDate;
    }

    public String getInvoiceUrl() {
        return this.invoiceUrl;
    }

    public AvailableBankInvoice[] getAvailableBanks() {
        return this.availableBanks;
    }

    public AvailableRetailOutletInvoice[] getAvailableRetailOutlets() {
        return this.availableRetailOutlets;
    }

    public AvailableEwalletInvoice[] getAvailableEwallets() {
        return this.availableEwallets;
    }

    public String getPaidAt() {
        return this.paidAt;
    }

    public Number getPaidAmount() {
        return this.paidAmount;
    }

    public Number getAdjustedReceivedAmount() {
        return this.adjustedReceivedAmount;
    }

    public Boolean getShouldExcludeCreditCard() {
        return this.shouldExcludeCreditCard;
    }

    public Boolean getShouldSendEmail() {
        return this.shouldSendEmail;
    }

    public String getCreated() {
        return this.created;
    }

    public String getUpdated() {
        return this.updated;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getInitialCurrency() {
        return this.initialCurrency;
    }

    public String getOnDemandLink() {
        return this.onDemandLink;
    }

    public Object getOnDemandPayload() {
        return this.onDemandPayload;
    }

    public String getRecurringPaymentId() {
        return this.recurringPaymentId;
    }

    public String getCreditCardChargeId() {
        return this.creditCardChargeId;
    }

    public String getMidLabel() {
        return this.midLabel;
    }

    public String getPaymentChannel() {
        return this.paymentChannel;
    }

    public String getPaymentMethod() {
        return this.paymentMethod;
    }

    public String getPaymentDestination() {
        return this.paymentDestination;
    }

    public String getSuccessRedirectUrl() {
        return this.successRedirectUrl;
    }

    public String getFailureRedirectUrl() {
        return this.failureRedirectUrl;
    }

    public ItemInvoice[] getItems() {
        return this.items;
    }

    public Boolean getFixedVa() {
        return this.fixedVa;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setMerchantName(String merchantName) {
        this.merchantName = merchantName;
    }

    public void setMerchantProfilePictureUrl(String merchantProfilePictureUrl) {
        this.merchantProfilePictureUrl = merchantProfilePictureUrl;
    }

    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }

    public void setAmount(Number amount) {
        this.amount = amount;
    }

    public void setInitialAmount(Number initialAmount) {
        this.initialAmount = initialAmount;
    }

    public void setPayerEmail(String payerEmail) {
        this.payerEmail = payerEmail;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setExpiryDate(String expiryDate) {
        this.expiryDate = expiryDate;
    }

    public void setInvoiceUrl(String invoiceUrl) {
        this.invoiceUrl = invoiceUrl;
    }

    public void setAvailableBanks(AvailableBankInvoice[] availableBanks) {
        this.availableBanks = availableBanks;
    }

    public void setAvailableRetailOutlets(AvailableRetailOutletInvoice[] availableRetailOutlets) {
        this.availableRetailOutlets = availableRetailOutlets;
    }

    public void setAvailableEwallets(AvailableEwalletInvoice[] availableEwallets) {
        this.availableEwallets = availableEwallets;
    }

    public void setPaidAt(String paidAt) {
        this.paidAt = paidAt;
    }

    public void setPaidAmount(Number paidAmount) {
        this.paidAmount = paidAmount;
    }

    public void setAdjustedReceivedAmount(Number adjustedReceivedAmount) {
        this.adjustedReceivedAmount = adjustedReceivedAmount;
    }

    public void setShouldExcludeCreditCard(Boolean shouldExcludeCreditCard) {
        this.shouldExcludeCreditCard = shouldExcludeCreditCard;
    }

    public void setShouldSendEmail(Boolean shouldSendEmail) {
        this.shouldSendEmail = shouldSendEmail;
    }

    public void setCreated(String created) {
        this.created = created;
    }

    public void setUpdated(String updated) {
        this.updated = updated;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public void setInitialCurrency(String initialCurrency) {
        this.initialCurrency = initialCurrency;
    }

    public void setOnDemandLink(String onDemandLink) {
        this.onDemandLink = onDemandLink;
    }

    public void setOnDemandPayload(Object onDemandPayload) {
        this.onDemandPayload = onDemandPayload;
    }

    public void setRecurringPaymentId(String recurringPaymentId) {
        this.recurringPaymentId = recurringPaymentId;
    }

    public void setCreditCardChargeId(String creditCardChargeId) {
        this.creditCardChargeId = creditCardChargeId;
    }

    public void setMidLabel(String midLabel) {
        this.midLabel = midLabel;
    }

    public void setPaymentChannel(String paymentChannel) {
        this.paymentChannel = paymentChannel;
    }

    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public void setPaymentDestination(String paymentDestination) {
        this.paymentDestination = paymentDestination;
    }

    public void setSuccessRedirectUrl(String successRedirectUrl) {
        this.successRedirectUrl = successRedirectUrl;
    }

    public void setFailureRedirectUrl(String failureRedirectUrl) {
        this.failureRedirectUrl = failureRedirectUrl;
    }

    public void setItems(ItemInvoice[] items) {
        this.items = items;
    }

    public void setFixedVa(Boolean fixedVa) {
        this.fixedVa = fixedVa;
    }

    public static class InvoiceBuilder {
        private String id;
        private String externalId;
        private String userId;
        private String status;
        private String merchantName;
        private String merchantProfilePictureUrl;
        private String bankCode;
        private Number amount;
        private Number initialAmount;
        private String payerEmail;
        private String description;
        private String expiryDate;
        private String invoiceUrl;
        private AvailableBankInvoice[] availableBanks;
        private AvailableRetailOutletInvoice[] availableRetailOutlets;
        private AvailableEwalletInvoice[] availableEwallets;
        private String paidAt;
        private Number paidAmount;
        private Number adjustedReceivedAmount;
        private Boolean shouldExcludeCreditCard;
        private Boolean shouldSendEmail;
        private String created;
        private String updated;
        private String currency;
        private String initialCurrency;
        private String onDemandLink;
        private Object onDemandPayload;
        private String recurringPaymentId;
        private String creditCardChargeId;
        private String midLabel;
        private String paymentChannel;
        private String paymentMethod;
        private String paymentDestination;
        private String successRedirectUrl;
        private String failureRedirectUrl;
        private ItemInvoice[] items;
        private Boolean fixedVa;

        InvoiceBuilder() {
        }

        public InvoiceBuilder id(String id) {
            this.id = id;
            return this;
        }

        public InvoiceBuilder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public InvoiceBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public InvoiceBuilder status(String status) {
            this.status = status;
            return this;
        }

        public InvoiceBuilder merchantName(String merchantName) {
            this.merchantName = merchantName;
            return this;
        }

        public InvoiceBuilder merchantProfilePictureUrl(String merchantProfilePictureUrl) {
            this.merchantProfilePictureUrl = merchantProfilePictureUrl;
            return this;
        }

        public InvoiceBuilder bankCode(String bankCode) {
            this.bankCode = bankCode;
            return this;
        }

        public InvoiceBuilder amount(Number amount) {
            this.amount = amount;
            return this;
        }

        public InvoiceBuilder initialAmount(Number initialAmount) {
            this.initialAmount = initialAmount;
            return this;
        }

        public InvoiceBuilder payerEmail(String payerEmail) {
            this.payerEmail = payerEmail;
            return this;
        }

        public InvoiceBuilder description(String description) {
            this.description = description;
            return this;
        }

        public InvoiceBuilder expiryDate(String expiryDate) {
            this.expiryDate = expiryDate;
            return this;
        }

        public InvoiceBuilder invoiceUrl(String invoiceUrl) {
            this.invoiceUrl = invoiceUrl;
            return this;
        }

        public InvoiceBuilder availableBanks(AvailableBankInvoice[] availableBanks) {
            this.availableBanks = availableBanks;
            return this;
        }

        public InvoiceBuilder availableRetailOutlets(AvailableRetailOutletInvoice[] availableRetailOutlets) {
            this.availableRetailOutlets = availableRetailOutlets;
            return this;
        }

        public InvoiceBuilder availableEwallets(AvailableEwalletInvoice[] availableEwallets) {
            this.availableEwallets = availableEwallets;
            return this;
        }

        public InvoiceBuilder paidAt(String paidAt) {
            this.paidAt = paidAt;
            return this;
        }

        public InvoiceBuilder paidAmount(Number paidAmount) {
            this.paidAmount = paidAmount;
            return this;
        }

        public InvoiceBuilder adjustedReceivedAmount(Number adjustedReceivedAmount) {
            this.adjustedReceivedAmount = adjustedReceivedAmount;
            return this;
        }

        public InvoiceBuilder shouldExcludeCreditCard(Boolean shouldExcludeCreditCard) {
            this.shouldExcludeCreditCard = shouldExcludeCreditCard;
            return this;
        }

        public InvoiceBuilder shouldSendEmail(Boolean shouldSendEmail) {
            this.shouldSendEmail = shouldSendEmail;
            return this;
        }

        public InvoiceBuilder created(String created) {
            this.created = created;
            return this;
        }

        public InvoiceBuilder updated(String updated) {
            this.updated = updated;
            return this;
        }

        public InvoiceBuilder currency(String currency) {
            this.currency = currency;
            return this;
        }

        public InvoiceBuilder initialCurrency(String initialCurrency) {
            this.initialCurrency = initialCurrency;
            return this;
        }

        public InvoiceBuilder onDemandLink(String onDemandLink) {
            this.onDemandLink = onDemandLink;
            return this;
        }

        public InvoiceBuilder onDemandPayload(Object onDemandPayload) {
            this.onDemandPayload = onDemandPayload;
            return this;
        }

        public InvoiceBuilder recurringPaymentId(String recurringPaymentId) {
            this.recurringPaymentId = recurringPaymentId;
            return this;
        }

        public InvoiceBuilder creditCardChargeId(String creditCardChargeId) {
            this.creditCardChargeId = creditCardChargeId;
            return this;
        }

        public InvoiceBuilder midLabel(String midLabel) {
            this.midLabel = midLabel;
            return this;
        }

        public InvoiceBuilder paymentChannel(String paymentChannel) {
            this.paymentChannel = paymentChannel;
            return this;
        }

        public InvoiceBuilder paymentMethod(String paymentMethod) {
            this.paymentMethod = paymentMethod;
            return this;
        }

        public InvoiceBuilder paymentDestination(String paymentDestination) {
            this.paymentDestination = paymentDestination;
            return this;
        }

        public InvoiceBuilder successRedirectUrl(String successRedirectUrl) {
            this.successRedirectUrl = successRedirectUrl;
            return this;
        }

        public InvoiceBuilder failureRedirectUrl(String failureRedirectUrl) {
            this.failureRedirectUrl = failureRedirectUrl;
            return this;
        }

        public InvoiceBuilder items(ItemInvoice[] items) {
            this.items = items;
            return this;
        }

        public InvoiceBuilder fixedVa(Boolean fixedVa) {
            this.fixedVa = fixedVa;
            return this;
        }

        public Invoice build() {
            return new Invoice(this.id, this.externalId, this.userId, this.status, this.merchantName, this.merchantProfilePictureUrl, this.bankCode, this.amount, this.initialAmount, this.payerEmail, this.description, this.expiryDate, this.invoiceUrl, this.availableBanks, this.availableRetailOutlets, this.availableEwallets, this.paidAt, this.paidAmount, this.adjustedReceivedAmount, this.shouldExcludeCreditCard, this.shouldSendEmail, this.created, this.updated, this.currency, this.initialCurrency, this.onDemandLink, this.onDemandPayload, this.recurringPaymentId, this.creditCardChargeId, this.midLabel, this.paymentChannel, this.paymentMethod, this.paymentDestination, this.successRedirectUrl, this.failureRedirectUrl, this.items, this.fixedVa);
        }

        public String toString() {
            return "Invoice.InvoiceBuilder(id=" + this.id + ", externalId=" + this.externalId + ", userId=" + this.userId + ", status=" + this.status + ", merchantName=" + this.merchantName + ", merchantProfilePictureUrl=" + this.merchantProfilePictureUrl + ", bankCode=" + this.bankCode + ", amount=" + this.amount + ", initialAmount=" + this.initialAmount + ", payerEmail=" + this.payerEmail + ", description=" + this.description + ", expiryDate=" + this.expiryDate + ", invoiceUrl=" + this.invoiceUrl + ", availableBanks=" + Arrays.deepToString(this.availableBanks) + ", availableRetailOutlets=" + Arrays.deepToString(this.availableRetailOutlets) + ", availableEwallets=" + Arrays.deepToString(this.availableEwallets) + ", paidAt=" + this.paidAt + ", paidAmount=" + this.paidAmount + ", adjustedReceivedAmount=" + this.adjustedReceivedAmount + ", shouldExcludeCreditCard=" + this.shouldExcludeCreditCard + ", shouldSendEmail=" + this.shouldSendEmail + ", created=" + this.created + ", updated=" + this.updated + ", currency=" + this.currency + ", initialCurrency=" + this.initialCurrency + ", onDemandLink=" + this.onDemandLink + ", onDemandPayload=" + this.onDemandPayload + ", recurringPaymentId=" + this.recurringPaymentId + ", creditCardChargeId=" + this.creditCardChargeId + ", midLabel=" + this.midLabel + ", paymentChannel=" + this.paymentChannel + ", paymentMethod=" + this.paymentMethod + ", paymentDestination=" + this.paymentDestination + ", successRedirectUrl=" + this.successRedirectUrl + ", failureRedirectUrl=" + this.failureRedirectUrl + ", items=" + Arrays.deepToString(this.items) + ", fixedVa=" + this.fixedVa + ")";
        }
    }
}

