/*
 * Decompiled with CFR 0.152.
 */
package com.xendit.model;

import com.xendit.Xendit;
import com.xendit.exception.XenditException;
import com.xendit.model.Invoice;
import com.xendit.network.NetworkClient;
import com.xendit.network.RequestResource;
import java.util.HashMap;
import java.util.Map;

public class InvoiceClient {
    private Xendit.Option opt;
    private NetworkClient requestClient;

    public Xendit.Option getOpt() {
        return this.opt;
    }

    public Invoice create(String externalId, Number amount, String payerEmail, String description) throws XenditException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("external_id", externalId);
        params.put("amount", amount);
        params.put("payer_email", payerEmail);
        params.put("description", description);
        String url = String.format("%s%s", this.opt.getXenditURL(), "/v2/invoices");
        return this.requestClient.request(RequestResource.Method.POST, url, params, this.opt.getApiKey(), Invoice.class);
    }

    public Invoice create(Map<String, Object> params) throws XenditException {
        return this.create(new HashMap<String, String>(), params);
    }

    public Invoice create(Map<String, String> headers, Map<String, Object> params) throws XenditException {
        String url = String.format("%s%s", this.opt.getXenditURL(), "/v2/invoices");
        return this.requestClient.request(RequestResource.Method.POST, url, headers, params, this.opt.getApiKey(), Invoice.class);
    }

    public Invoice getById(String id) throws XenditException {
        return this.getById(new HashMap<String, String>(), id);
    }

    public Invoice getById(Map<String, String> headers, String id) throws XenditException {
        String url = String.format("%s%s%s", Xendit.Opt.getXenditURL(), "/v2/invoices/", id);
        return this.requestClient.request(RequestResource.Method.GET, url, headers, null, this.opt.getApiKey(), Invoice.class);
    }

    public Invoice[] getAll(Map<String, Object> params) throws XenditException {
        return this.getAll(new HashMap<String, String>(), params);
    }

    public Invoice[] getAll(Map<String, String> headers, Map<String, Object> params) throws XenditException {
        String[] paramList;
        StringBuilder parameters = new StringBuilder();
        for (String key : paramList = new String[]{"statuses", "limit", "created_after", "created_before", "paid_after", "paid_before", "expired_after", "expired_before", "last_invoice_id", "client_types", "payment_channels", "on_demand_link", "recurring_payment_id"}) {
            if (!params.containsKey(key)) continue;
            parameters.append(String.format("%s%s%s%s", "&", key, "=", params.get(key)));
        }
        String url = String.format("%s%s%s", Xendit.Opt.getXenditURL(), "/v2/invoices?", parameters.toString());
        return this.requestClient.request(RequestResource.Method.GET, url, headers, null, this.opt.getApiKey(), Invoice[].class);
    }

    public Invoice expire(String id) throws XenditException {
        return this.expire(new HashMap<String, String>(), id);
    }

    public Invoice expire(Map<String, String> headers, String id) throws XenditException {
        String url = String.format("%s%s%s%s", Xendit.Opt.getXenditURL(), "/invoices/", id, "/expire!");
        return this.requestClient.request(RequestResource.Method.POST, url, headers, null, this.opt.getApiKey(), Invoice.class);
    }

    public InvoiceClient(Xendit.Option opt, NetworkClient requestClient) {
        this.opt = opt;
        this.requestClient = requestClient;
    }
}

