/*
 * Decompiled with CFR 0.152.
 */
package com.xendit.model;

import com.google.gson.annotations.SerializedName;
import com.xendit.exception.XenditException;
import com.xendit.model.DirectDebitPayment;
import com.xendit.model.DirectDebitPaymentClient;
import com.xendit.model.LinkedAccountEnum;
import java.util.HashMap;
import java.util.Map;

public class PaymentMethod {
    @SerializedName(value="id")
    private String id;
    @SerializedName(value="type")
    private LinkedAccountEnum.AccountType type;
    @SerializedName(value="properties")
    private Map<String, Object> properties;
    @SerializedName(value="customer_id")
    private String customerId;
    @SerializedName(value="status")
    private String status;
    @SerializedName(value="created")
    private String created;
    @SerializedName(value="updated")
    private String updated;
    @SerializedName(value="metadata")
    private Map<String, Object> metadata;
    private static DirectDebitPaymentClient directDebitPaymentClient;

    public static PaymentMethod createPaymentMethod(String customerId, LinkedAccountEnum.AccountType type, Map<String, Object> properties, Map<String, Object> metadata) throws XenditException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("customer_id", customerId);
        params.put("type", (Object)type);
        params.put("properties", properties);
        params.put("metadata", metadata);
        return PaymentMethod.createPaymentMethodRequest(new HashMap<String, String>(), params);
    }

    public static PaymentMethod createPaymentMethod(Map<String, Object> params) throws XenditException {
        return PaymentMethod.createPaymentMethodRequest(new HashMap<String, String>(), params);
    }

    public static PaymentMethod createPaymentMethod(Map<String, String> headers, Map<String, Object> params) throws XenditException {
        return PaymentMethod.createPaymentMethodRequest(headers, params);
    }

    public static PaymentMethod[] getPaymentMethodsByCustomerId(String customerId) throws XenditException {
        DirectDebitPaymentClient client = DirectDebitPayment.getClient();
        return client.getPaymentMethodsByCustomerId(customerId);
    }

    private static PaymentMethod createPaymentMethodRequest(Map<String, String> headers, Map<String, Object> params) throws XenditException {
        DirectDebitPaymentClient client = DirectDebitPayment.getClient();
        return client.createPaymentMethodRequest(headers, params);
    }

    PaymentMethod(String id, LinkedAccountEnum.AccountType type, Map<String, Object> properties, String customerId, String status, String created, String updated, Map<String, Object> metadata) {
        this.id = id;
        this.type = type;
        this.properties = properties;
        this.customerId = customerId;
        this.status = status;
        this.created = created;
        this.updated = updated;
        this.metadata = metadata;
    }

    public static PaymentMethodBuilder builder() {
        return new PaymentMethodBuilder();
    }

    public String getId() {
        return this.id;
    }

    public LinkedAccountEnum.AccountType getType() {
        return this.type;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getStatus() {
        return this.status;
    }

    public String getCreated() {
        return this.created;
    }

    public String getUpdated() {
        return this.updated;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setType(LinkedAccountEnum.AccountType type) {
        this.type = type;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setCreated(String created) {
        this.created = created;
    }

    public void setUpdated(String updated) {
        this.updated = updated;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public static class PaymentMethodBuilder {
        private String id;
        private LinkedAccountEnum.AccountType type;
        private Map<String, Object> properties;
        private String customerId;
        private String status;
        private String created;
        private String updated;
        private Map<String, Object> metadata;

        PaymentMethodBuilder() {
        }

        public PaymentMethodBuilder id(String id) {
            this.id = id;
            return this;
        }

        public PaymentMethodBuilder type(LinkedAccountEnum.AccountType type) {
            this.type = type;
            return this;
        }

        public PaymentMethodBuilder properties(Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        public PaymentMethodBuilder customerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public PaymentMethodBuilder status(String status) {
            this.status = status;
            return this;
        }

        public PaymentMethodBuilder created(String created) {
            this.created = created;
            return this;
        }

        public PaymentMethodBuilder updated(String updated) {
            this.updated = updated;
            return this;
        }

        public PaymentMethodBuilder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public PaymentMethod build() {
            return new PaymentMethod(this.id, this.type, this.properties, this.customerId, this.status, this.created, this.updated, this.metadata);
        }

        public String toString() {
            return "PaymentMethod.PaymentMethodBuilder(id=" + this.id + ", type=" + (Object)((Object)this.type) + ", properties=" + this.properties + ", customerId=" + this.customerId + ", status=" + this.status + ", created=" + this.created + ", updated=" + this.updated + ", metadata=" + this.metadata + ")";
        }
    }
}

