/*
 * Decompiled with CFR 0.152.
 */
package com.xendit.model;

import com.google.gson.annotations.SerializedName;
import com.xendit.Xendit;
import com.xendit.exception.XenditException;
import com.xendit.model.PayoutClient;
import java.util.HashMap;
import java.util.Map;

public class Payout {
    @SerializedName(value="id")
    private String id;
    @SerializedName(value="external_id")
    private String externalId;
    @SerializedName(value="amount")
    private Number amount;
    @SerializedName(value="passcode")
    private String passcode;
    @SerializedName(value="merchant_name")
    private String merchantName;
    @SerializedName(value="status")
    private String status;
    @SerializedName(value="expiration_timestamp")
    private String expirationTimestamp;
    @SerializedName(value="created")
    private String created;
    @SerializedName(value="payout_url")
    private String payoutUrl;
    @SerializedName(value="email")
    private String email;
    @SerializedName(value="bank_code")
    private String bankCode;
    @SerializedName(value="account_holder_name")
    private String accountHolderName;
    @SerializedName(value="account_number")
    private String accountNumber;
    @SerializedName(value="disbursement_id")
    private String disbursementId;
    @SerializedName(value="failure_reason")
    private String failureReason;
    @SerializedName(value="claimed_timestamp")
    private String claimedTimestamp;
    @SerializedName(value="completed_timestamp")
    private String completedTimestamp;
    @SerializedName(value="failed_timestamp")
    private String failedTimestamp;
    @SerializedName(value="payment_id")
    private String paymentId;
    private static PayoutClient payoutClient;

    public static Payout createPayout(String externalId, Number amount) throws XenditException {
        PayoutClient client = Payout.getClient();
        return client.createPayout(externalId, amount);
    }

    public static Payout createPayout(Map<String, Object> params) throws XenditException {
        return Payout.createPayout(new HashMap<String, String>(), params);
    }

    public static Payout createPayout(Map<String, String> headers, Map<String, Object> params) throws XenditException {
        PayoutClient client = Payout.getClient();
        return client.createPayout(headers, params);
    }

    public static Payout getPayout(String id) throws XenditException {
        PayoutClient client = Payout.getClient();
        return client.getPayout(id);
    }

    public static Payout voidPayout(String id) throws XenditException {
        PayoutClient client = Payout.getClient();
        return client.voidPayout(id);
    }

    private static PayoutClient getClient() {
        if (Payout.isApiKeyExist()) {
            if (payoutClient == null || !payoutClient.getOpt().getApiKey().trim().equals(Xendit.apiKey.trim())) {
                payoutClient = new PayoutClient(Xendit.Opt.setApiKey(Xendit.apiKey), Xendit.getRequestClient());
                return payoutClient;
            }
        } else if (payoutClient == null || !payoutClient.getOpt().getApiKey().trim().equals(Xendit.Opt.getApiKey().trim())) {
            payoutClient = new PayoutClient(Xendit.Opt, Xendit.getRequestClient());
            return payoutClient;
        }
        return payoutClient;
    }

    private static boolean isApiKeyExist() {
        return Xendit.apiKey != null;
    }

    Payout(String id, String externalId, Number amount, String passcode, String merchantName, String status, String expirationTimestamp, String created, String payoutUrl, String email, String bankCode, String accountHolderName, String accountNumber, String disbursementId, String failureReason, String claimedTimestamp, String completedTimestamp, String failedTimestamp, String paymentId) {
        this.id = id;
        this.externalId = externalId;
        this.amount = amount;
        this.passcode = passcode;
        this.merchantName = merchantName;
        this.status = status;
        this.expirationTimestamp = expirationTimestamp;
        this.created = created;
        this.payoutUrl = payoutUrl;
        this.email = email;
        this.bankCode = bankCode;
        this.accountHolderName = accountHolderName;
        this.accountNumber = accountNumber;
        this.disbursementId = disbursementId;
        this.failureReason = failureReason;
        this.claimedTimestamp = claimedTimestamp;
        this.completedTimestamp = completedTimestamp;
        this.failedTimestamp = failedTimestamp;
        this.paymentId = paymentId;
    }

    public static PayoutBuilder builder() {
        return new PayoutBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public Number getAmount() {
        return this.amount;
    }

    public String getPasscode() {
        return this.passcode;
    }

    public String getMerchantName() {
        return this.merchantName;
    }

    public String getStatus() {
        return this.status;
    }

    public String getExpirationTimestamp() {
        return this.expirationTimestamp;
    }

    public String getCreated() {
        return this.created;
    }

    public String getPayoutUrl() {
        return this.payoutUrl;
    }

    public String getEmail() {
        return this.email;
    }

    public String getBankCode() {
        return this.bankCode;
    }

    public String getAccountHolderName() {
        return this.accountHolderName;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public String getDisbursementId() {
        return this.disbursementId;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public String getClaimedTimestamp() {
        return this.claimedTimestamp;
    }

    public String getCompletedTimestamp() {
        return this.completedTimestamp;
    }

    public String getFailedTimestamp() {
        return this.failedTimestamp;
    }

    public String getPaymentId() {
        return this.paymentId;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public void setAmount(Number amount) {
        this.amount = amount;
    }

    public void setPasscode(String passcode) {
        this.passcode = passcode;
    }

    public void setMerchantName(String merchantName) {
        this.merchantName = merchantName;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setExpirationTimestamp(String expirationTimestamp) {
        this.expirationTimestamp = expirationTimestamp;
    }

    public void setCreated(String created) {
        this.created = created;
    }

    public void setPayoutUrl(String payoutUrl) {
        this.payoutUrl = payoutUrl;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }

    public void setAccountHolderName(String accountHolderName) {
        this.accountHolderName = accountHolderName;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public void setDisbursementId(String disbursementId) {
        this.disbursementId = disbursementId;
    }

    public void setFailureReason(String failureReason) {
        this.failureReason = failureReason;
    }

    public void setClaimedTimestamp(String claimedTimestamp) {
        this.claimedTimestamp = claimedTimestamp;
    }

    public void setCompletedTimestamp(String completedTimestamp) {
        this.completedTimestamp = completedTimestamp;
    }

    public void setFailedTimestamp(String failedTimestamp) {
        this.failedTimestamp = failedTimestamp;
    }

    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }

    public static class PayoutBuilder {
        private String id;
        private String externalId;
        private Number amount;
        private String passcode;
        private String merchantName;
        private String status;
        private String expirationTimestamp;
        private String created;
        private String payoutUrl;
        private String email;
        private String bankCode;
        private String accountHolderName;
        private String accountNumber;
        private String disbursementId;
        private String failureReason;
        private String claimedTimestamp;
        private String completedTimestamp;
        private String failedTimestamp;
        private String paymentId;

        PayoutBuilder() {
        }

        public PayoutBuilder id(String id) {
            this.id = id;
            return this;
        }

        public PayoutBuilder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public PayoutBuilder amount(Number amount) {
            this.amount = amount;
            return this;
        }

        public PayoutBuilder passcode(String passcode) {
            this.passcode = passcode;
            return this;
        }

        public PayoutBuilder merchantName(String merchantName) {
            this.merchantName = merchantName;
            return this;
        }

        public PayoutBuilder status(String status) {
            this.status = status;
            return this;
        }

        public PayoutBuilder expirationTimestamp(String expirationTimestamp) {
            this.expirationTimestamp = expirationTimestamp;
            return this;
        }

        public PayoutBuilder created(String created) {
            this.created = created;
            return this;
        }

        public PayoutBuilder payoutUrl(String payoutUrl) {
            this.payoutUrl = payoutUrl;
            return this;
        }

        public PayoutBuilder email(String email) {
            this.email = email;
            return this;
        }

        public PayoutBuilder bankCode(String bankCode) {
            this.bankCode = bankCode;
            return this;
        }

        public PayoutBuilder accountHolderName(String accountHolderName) {
            this.accountHolderName = accountHolderName;
            return this;
        }

        public PayoutBuilder accountNumber(String accountNumber) {
            this.accountNumber = accountNumber;
            return this;
        }

        public PayoutBuilder disbursementId(String disbursementId) {
            this.disbursementId = disbursementId;
            return this;
        }

        public PayoutBuilder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public PayoutBuilder claimedTimestamp(String claimedTimestamp) {
            this.claimedTimestamp = claimedTimestamp;
            return this;
        }

        public PayoutBuilder completedTimestamp(String completedTimestamp) {
            this.completedTimestamp = completedTimestamp;
            return this;
        }

        public PayoutBuilder failedTimestamp(String failedTimestamp) {
            this.failedTimestamp = failedTimestamp;
            return this;
        }

        public PayoutBuilder paymentId(String paymentId) {
            this.paymentId = paymentId;
            return this;
        }

        public Payout build() {
            return new Payout(this.id, this.externalId, this.amount, this.passcode, this.merchantName, this.status, this.expirationTimestamp, this.created, this.payoutUrl, this.email, this.bankCode, this.accountHolderName, this.accountNumber, this.disbursementId, this.failureReason, this.claimedTimestamp, this.completedTimestamp, this.failedTimestamp, this.paymentId);
        }

        public String toString() {
            return "Payout.PayoutBuilder(id=" + this.id + ", externalId=" + this.externalId + ", amount=" + this.amount + ", passcode=" + this.passcode + ", merchantName=" + this.merchantName + ", status=" + this.status + ", expirationTimestamp=" + this.expirationTimestamp + ", created=" + this.created + ", payoutUrl=" + this.payoutUrl + ", email=" + this.email + ", bankCode=" + this.bankCode + ", accountHolderName=" + this.accountHolderName + ", accountNumber=" + this.accountNumber + ", disbursementId=" + this.disbursementId + ", failureReason=" + this.failureReason + ", claimedTimestamp=" + this.claimedTimestamp + ", completedTimestamp=" + this.completedTimestamp + ", failedTimestamp=" + this.failedTimestamp + ", paymentId=" + this.paymentId + ")";
        }
    }
}

