/*
 * Decompiled with CFR 0.152.
 */
package com.xendit.model;

import com.xendit.Xendit;
import com.xendit.exception.XenditException;
import com.xendit.model.Payout;
import com.xendit.network.NetworkClient;
import com.xendit.network.RequestResource;
import java.util.HashMap;
import java.util.Map;

public class PayoutClient {
    private Xendit.Option opt;
    private NetworkClient requestClient;

    public Xendit.Option getOpt() {
        return this.opt;
    }

    public Payout createPayout(Map<String, Object> params) throws XenditException {
        return this.createPayout(new HashMap<String, String>(), params);
    }

    public Payout createPayout(String externalId, Number amount) throws XenditException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("external_id", externalId);
        params.put("amount", amount);
        String url = String.format("%s%s", this.opt.getXenditURL(), "/payouts");
        return this.requestClient.request(RequestResource.Method.POST, url, params, this.opt.getApiKey(), Payout.class);
    }

    public Payout createPayout(Map<String, String> headers, Map<String, Object> params) throws XenditException {
        String url = String.format("%s%s", this.opt.getXenditURL(), "/payouts");
        return this.requestClient.request(RequestResource.Method.POST, url, headers, params, this.opt.getApiKey(), Payout.class);
    }

    public Payout getPayout(String id) throws XenditException {
        String url = String.format("%s%s%s", this.opt.getXenditURL(), "/payouts/", id);
        return this.requestClient.request(RequestResource.Method.GET, url, null, this.opt.getApiKey(), Payout.class);
    }

    public Payout voidPayout(String id) throws XenditException {
        String url = String.format("%s%s%s%s", this.opt.getXenditURL(), "/payouts/", id, "/void");
        return this.requestClient.request(RequestResource.Method.POST, url, null, this.opt.getApiKey(), Payout.class);
    }

    public PayoutClient(Xendit.Option opt, NetworkClient requestClient) {
        this.opt = opt;
        this.requestClient = requestClient;
    }
}

