/*
 * Decompiled with CFR 0.152.
 */
package com.xendit.model;

import com.google.gson.annotations.SerializedName;
import com.xendit.Xendit;
import com.xendit.exception.XenditException;
import com.xendit.model.QRCodeClient;
import java.util.HashMap;
import java.util.Map;

public class QRCode {
    @SerializedName(value="id")
    private String id;
    @SerializedName(value="external_id")
    private String externalId;
    @SerializedName(value="amount")
    private Number amount;
    @SerializedName(value="qr_string")
    private String qrString;
    @SerializedName(value="callback_url")
    private String callbackUrl;
    @SerializedName(value="type")
    private String type;
    @SerializedName(value="status")
    private String status;
    @SerializedName(value="created")
    private String created;
    @SerializedName(value="updated")
    private String updated;
    private static QRCodeClient qrCodeClient;

    public static QRCode createQRCode(String externalId, QRCodeType type, String callbackUrl, Number amount) throws XenditException {
        QRCodeClient client = QRCode.getClient();
        return client.createQRCode(externalId, type, callbackUrl, amount);
    }

    public static QRCode createQRCode(Map<String, Object> params) throws XenditException {
        return QRCode.createQRCode(new HashMap<String, String>(), params);
    }

    public static QRCode createQRCode(Map<String, String> headers, Map<String, Object> params) throws XenditException {
        QRCodeClient client = QRCode.getClient();
        return client.createQRCode(headers, params);
    }

    public static QRCode getQRCode(String externalId) throws XenditException {
        QRCodeClient client = QRCode.getClient();
        return client.getQRCode(externalId);
    }

    private static QRCodeClient getClient() {
        if (QRCode.isApiKeyExist()) {
            if (qrCodeClient == null || !qrCodeClient.getOpt().getApiKey().trim().equals(Xendit.apiKey.trim())) {
                qrCodeClient = new QRCodeClient(Xendit.Opt.setApiKey(Xendit.apiKey), Xendit.getRequestClient());
                return qrCodeClient;
            }
        } else if (qrCodeClient == null || !qrCodeClient.getOpt().getApiKey().trim().equals(Xendit.Opt.getApiKey().trim())) {
            qrCodeClient = new QRCodeClient(Xendit.Opt, Xendit.getRequestClient());
            return qrCodeClient;
        }
        return qrCodeClient;
    }

    private static boolean isApiKeyExist() {
        return Xendit.apiKey != null;
    }

    QRCode(String id, String externalId, Number amount, String qrString, String callbackUrl, String type, String status, String created, String updated) {
        this.id = id;
        this.externalId = externalId;
        this.amount = amount;
        this.qrString = qrString;
        this.callbackUrl = callbackUrl;
        this.type = type;
        this.status = status;
        this.created = created;
        this.updated = updated;
    }

    public static QRCodeBuilder builder() {
        return new QRCodeBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public Number getAmount() {
        return this.amount;
    }

    public String getQrString() {
        return this.qrString;
    }

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public String getType() {
        return this.type;
    }

    public String getStatus() {
        return this.status;
    }

    public String getCreated() {
        return this.created;
    }

    public String getUpdated() {
        return this.updated;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public void setAmount(Number amount) {
        this.amount = amount;
    }

    public void setQrString(String qrString) {
        this.qrString = qrString;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setCreated(String created) {
        this.created = created;
    }

    public void setUpdated(String updated) {
        this.updated = updated;
    }

    public static class QRCodeBuilder {
        private String id;
        private String externalId;
        private Number amount;
        private String qrString;
        private String callbackUrl;
        private String type;
        private String status;
        private String created;
        private String updated;

        QRCodeBuilder() {
        }

        public QRCodeBuilder id(String id) {
            this.id = id;
            return this;
        }

        public QRCodeBuilder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public QRCodeBuilder amount(Number amount) {
            this.amount = amount;
            return this;
        }

        public QRCodeBuilder qrString(String qrString) {
            this.qrString = qrString;
            return this;
        }

        public QRCodeBuilder callbackUrl(String callbackUrl) {
            this.callbackUrl = callbackUrl;
            return this;
        }

        public QRCodeBuilder type(String type) {
            this.type = type;
            return this;
        }

        public QRCodeBuilder status(String status) {
            this.status = status;
            return this;
        }

        public QRCodeBuilder created(String created) {
            this.created = created;
            return this;
        }

        public QRCodeBuilder updated(String updated) {
            this.updated = updated;
            return this;
        }

        public QRCode build() {
            return new QRCode(this.id, this.externalId, this.amount, this.qrString, this.callbackUrl, this.type, this.status, this.created, this.updated);
        }

        public String toString() {
            return "QRCode.QRCodeBuilder(id=" + this.id + ", externalId=" + this.externalId + ", amount=" + this.amount + ", qrString=" + this.qrString + ", callbackUrl=" + this.callbackUrl + ", type=" + this.type + ", status=" + this.status + ", created=" + this.created + ", updated=" + this.updated + ")";
        }
    }

    public static enum QRCodeStatus {
        ACTIVE,
        INACTIVE;

    }

    public static enum QRCodeType {
        DYNAMIC,
        STATIC;

    }
}

