/*
 * Decompiled with CFR 0.152.
 */
package com.xendit.model;

import com.xendit.Xendit;
import com.xendit.exception.XenditException;
import com.xendit.model.QRCode;
import com.xendit.network.NetworkClient;
import com.xendit.network.RequestResource;
import java.util.HashMap;
import java.util.Map;

public class QRCodeClient {
    private Xendit.Option opt;
    private NetworkClient requestClient;

    public Xendit.Option getOpt() {
        return this.opt;
    }

    public QRCode createQRCode(String externalId, QRCode.QRCodeType type, String callbackUrl, Number amount) throws XenditException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("external_id", externalId);
        params.put("type", type.toString());
        params.put("callback_url", callbackUrl);
        params.put("amount", amount);
        String url = String.format("%s%s", this.opt.getXenditURL(), "/qr_codes");
        return this.requestClient.request(RequestResource.Method.POST, url, params, this.opt.getApiKey(), QRCode.class);
    }

    public QRCode createQRCode(Map<String, Object> params) throws XenditException {
        return this.createQRCode(new HashMap<String, String>(), params);
    }

    public QRCode createQRCode(Map<String, String> headers, Map<String, Object> params) throws XenditException {
        String url = String.format("%s%s", this.opt.getXenditURL(), "/qr_codes");
        return this.requestClient.request(RequestResource.Method.POST, url, headers, params, this.opt.getApiKey(), QRCode.class);
    }

    public QRCode getQRCode(String externalId) throws XenditException {
        String url = String.format("%s%s%s", this.opt.getXenditURL(), "/qr_codes/", externalId);
        return this.requestClient.request(RequestResource.Method.GET, url, null, this.opt.getApiKey(), QRCode.class);
    }

    public QRCodeClient(Xendit.Option opt, NetworkClient requestClient) {
        this.opt = opt;
        this.requestClient = requestClient;
    }
}

