/*
 * Decompiled with CFR 0.152.
 */
package com.xendit.model;

import com.google.gson.annotations.SerializedName;
import com.xendit.Xendit;
import com.xendit.exception.XenditException;
import com.xendit.model.Invoice;
import com.xendit.model.RecurringPaymentClient;
import java.util.HashMap;
import java.util.Map;

public class RecurringPayment {
    @SerializedName(value="id")
    private String id;
    @SerializedName(value="external_id")
    private String externalId;
    @SerializedName(value="payer_email")
    private String payerEmail;
    @SerializedName(value="description")
    private String description;
    @SerializedName(value="amount")
    private Number amount;
    @SerializedName(value="interval")
    private String interval;
    @SerializedName(value="interval_count")
    private Number intervalCount;
    @SerializedName(value="status")
    private String status;
    @SerializedName(value="total_recurrence")
    private Number totalRecurrence;
    @SerializedName(value="invoice_duration")
    private Number invoiceDuration;
    @SerializedName(value="should_send_email")
    private Boolean shouldSendEmail;
    @SerializedName(value="missed_payment_action")
    private String missedPaymentAction;
    @SerializedName(value="credit_card_token")
    private String creditCardToken;
    @SerializedName(value="start_date")
    private String startDate;
    @SerializedName(value="success_redirect_url")
    private String successRedirectUrl;
    @SerializedName(value="failure_redirect_url")
    private String failureRedirectUrl;
    @SerializedName(value="recharge")
    private Boolean recharge;
    @SerializedName(value="charge_immediately")
    private Boolean chargeImmediately;
    @SerializedName(value="currency")
    private String currency;
    private static RecurringPaymentClient recurringPaymentClient;

    public static RecurringPayment create(String externalId, String payerEmail, String interval, Number intervalCount, String description, Number amount) throws XenditException {
        RecurringPaymentClient client = RecurringPayment.getClient();
        return client.create(externalId, payerEmail, interval, intervalCount, description, amount);
    }

    public static RecurringPayment create(Map<String, Object> params) throws XenditException {
        return RecurringPayment.create(new HashMap<String, String>(), params);
    }

    public static RecurringPayment create(Map<String, String> headers, Map<String, Object> params) throws XenditException {
        RecurringPaymentClient client = RecurringPayment.getClient();
        return client.create(headers, params);
    }

    public static RecurringPayment edit(String id, Map<String, Object> params) throws XenditException {
        RecurringPaymentClient client = RecurringPayment.getClient();
        return client.edit(id, params);
    }

    public static RecurringPayment get(String id) throws XenditException {
        RecurringPaymentClient client = RecurringPayment.getClient();
        return client.get(id);
    }

    public static RecurringPayment stop(String id) throws XenditException {
        RecurringPaymentClient client = RecurringPayment.getClient();
        return client.stop(id);
    }

    public static RecurringPayment pause(String id) throws XenditException {
        RecurringPaymentClient client = RecurringPayment.getClient();
        return client.pause(id);
    }

    public static RecurringPayment resume(String id) throws XenditException {
        RecurringPaymentClient client = RecurringPayment.getClient();
        return client.resume(id);
    }

    public static Invoice[] getPaymentsById(String id) throws XenditException {
        RecurringPaymentClient client = RecurringPayment.getClient();
        return client.getPaymentsById(id);
    }

    private static RecurringPaymentClient getClient() {
        if (RecurringPayment.isApiKeyExist()) {
            if (recurringPaymentClient == null || !recurringPaymentClient.getOpt().getApiKey().trim().equals(Xendit.apiKey.trim())) {
                recurringPaymentClient = new RecurringPaymentClient(Xendit.Opt.setApiKey(Xendit.apiKey), Xendit.getRequestClient());
                return recurringPaymentClient;
            }
        } else if (recurringPaymentClient == null || !recurringPaymentClient.getOpt().getApiKey().trim().equals(Xendit.Opt.getApiKey().trim())) {
            recurringPaymentClient = new RecurringPaymentClient(Xendit.Opt, Xendit.getRequestClient());
            return recurringPaymentClient;
        }
        return recurringPaymentClient;
    }

    private static boolean isApiKeyExist() {
        return Xendit.apiKey != null;
    }

    RecurringPayment(String id, String externalId, String payerEmail, String description, Number amount, String interval, Number intervalCount, String status, Number totalRecurrence, Number invoiceDuration, Boolean shouldSendEmail, String missedPaymentAction, String creditCardToken, String startDate, String successRedirectUrl, String failureRedirectUrl, Boolean recharge, Boolean chargeImmediately, String currency) {
        this.id = id;
        this.externalId = externalId;
        this.payerEmail = payerEmail;
        this.description = description;
        this.amount = amount;
        this.interval = interval;
        this.intervalCount = intervalCount;
        this.status = status;
        this.totalRecurrence = totalRecurrence;
        this.invoiceDuration = invoiceDuration;
        this.shouldSendEmail = shouldSendEmail;
        this.missedPaymentAction = missedPaymentAction;
        this.creditCardToken = creditCardToken;
        this.startDate = startDate;
        this.successRedirectUrl = successRedirectUrl;
        this.failureRedirectUrl = failureRedirectUrl;
        this.recharge = recharge;
        this.chargeImmediately = chargeImmediately;
        this.currency = currency;
    }

    public static RecurringPaymentBuilder builder() {
        return new RecurringPaymentBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public String getPayerEmail() {
        return this.payerEmail;
    }

    public String getDescription() {
        return this.description;
    }

    public Number getAmount() {
        return this.amount;
    }

    public String getInterval() {
        return this.interval;
    }

    public Number getIntervalCount() {
        return this.intervalCount;
    }

    public String getStatus() {
        return this.status;
    }

    public Number getTotalRecurrence() {
        return this.totalRecurrence;
    }

    public Number getInvoiceDuration() {
        return this.invoiceDuration;
    }

    public Boolean getShouldSendEmail() {
        return this.shouldSendEmail;
    }

    public String getMissedPaymentAction() {
        return this.missedPaymentAction;
    }

    public String getCreditCardToken() {
        return this.creditCardToken;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public String getSuccessRedirectUrl() {
        return this.successRedirectUrl;
    }

    public String getFailureRedirectUrl() {
        return this.failureRedirectUrl;
    }

    public Boolean getRecharge() {
        return this.recharge;
    }

    public Boolean getChargeImmediately() {
        return this.chargeImmediately;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public void setPayerEmail(String payerEmail) {
        this.payerEmail = payerEmail;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setAmount(Number amount) {
        this.amount = amount;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    public void setIntervalCount(Number intervalCount) {
        this.intervalCount = intervalCount;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setTotalRecurrence(Number totalRecurrence) {
        this.totalRecurrence = totalRecurrence;
    }

    public void setInvoiceDuration(Number invoiceDuration) {
        this.invoiceDuration = invoiceDuration;
    }

    public void setShouldSendEmail(Boolean shouldSendEmail) {
        this.shouldSendEmail = shouldSendEmail;
    }

    public void setMissedPaymentAction(String missedPaymentAction) {
        this.missedPaymentAction = missedPaymentAction;
    }

    public void setCreditCardToken(String creditCardToken) {
        this.creditCardToken = creditCardToken;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public void setSuccessRedirectUrl(String successRedirectUrl) {
        this.successRedirectUrl = successRedirectUrl;
    }

    public void setFailureRedirectUrl(String failureRedirectUrl) {
        this.failureRedirectUrl = failureRedirectUrl;
    }

    public void setRecharge(Boolean recharge) {
        this.recharge = recharge;
    }

    public void setChargeImmediately(Boolean chargeImmediately) {
        this.chargeImmediately = chargeImmediately;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public static class RecurringPaymentBuilder {
        private String id;
        private String externalId;
        private String payerEmail;
        private String description;
        private Number amount;
        private String interval;
        private Number intervalCount;
        private String status;
        private Number totalRecurrence;
        private Number invoiceDuration;
        private Boolean shouldSendEmail;
        private String missedPaymentAction;
        private String creditCardToken;
        private String startDate;
        private String successRedirectUrl;
        private String failureRedirectUrl;
        private Boolean recharge;
        private Boolean chargeImmediately;
        private String currency;

        RecurringPaymentBuilder() {
        }

        public RecurringPaymentBuilder id(String id) {
            this.id = id;
            return this;
        }

        public RecurringPaymentBuilder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public RecurringPaymentBuilder payerEmail(String payerEmail) {
            this.payerEmail = payerEmail;
            return this;
        }

        public RecurringPaymentBuilder description(String description) {
            this.description = description;
            return this;
        }

        public RecurringPaymentBuilder amount(Number amount) {
            this.amount = amount;
            return this;
        }

        public RecurringPaymentBuilder interval(String interval) {
            this.interval = interval;
            return this;
        }

        public RecurringPaymentBuilder intervalCount(Number intervalCount) {
            this.intervalCount = intervalCount;
            return this;
        }

        public RecurringPaymentBuilder status(String status) {
            this.status = status;
            return this;
        }

        public RecurringPaymentBuilder totalRecurrence(Number totalRecurrence) {
            this.totalRecurrence = totalRecurrence;
            return this;
        }

        public RecurringPaymentBuilder invoiceDuration(Number invoiceDuration) {
            this.invoiceDuration = invoiceDuration;
            return this;
        }

        public RecurringPaymentBuilder shouldSendEmail(Boolean shouldSendEmail) {
            this.shouldSendEmail = shouldSendEmail;
            return this;
        }

        public RecurringPaymentBuilder missedPaymentAction(String missedPaymentAction) {
            this.missedPaymentAction = missedPaymentAction;
            return this;
        }

        public RecurringPaymentBuilder creditCardToken(String creditCardToken) {
            this.creditCardToken = creditCardToken;
            return this;
        }

        public RecurringPaymentBuilder startDate(String startDate) {
            this.startDate = startDate;
            return this;
        }

        public RecurringPaymentBuilder successRedirectUrl(String successRedirectUrl) {
            this.successRedirectUrl = successRedirectUrl;
            return this;
        }

        public RecurringPaymentBuilder failureRedirectUrl(String failureRedirectUrl) {
            this.failureRedirectUrl = failureRedirectUrl;
            return this;
        }

        public RecurringPaymentBuilder recharge(Boolean recharge) {
            this.recharge = recharge;
            return this;
        }

        public RecurringPaymentBuilder chargeImmediately(Boolean chargeImmediately) {
            this.chargeImmediately = chargeImmediately;
            return this;
        }

        public RecurringPaymentBuilder currency(String currency) {
            this.currency = currency;
            return this;
        }

        public RecurringPayment build() {
            return new RecurringPayment(this.id, this.externalId, this.payerEmail, this.description, this.amount, this.interval, this.intervalCount, this.status, this.totalRecurrence, this.invoiceDuration, this.shouldSendEmail, this.missedPaymentAction, this.creditCardToken, this.startDate, this.successRedirectUrl, this.failureRedirectUrl, this.recharge, this.chargeImmediately, this.currency);
        }

        public String toString() {
            return "RecurringPayment.RecurringPaymentBuilder(id=" + this.id + ", externalId=" + this.externalId + ", payerEmail=" + this.payerEmail + ", description=" + this.description + ", amount=" + this.amount + ", interval=" + this.interval + ", intervalCount=" + this.intervalCount + ", status=" + this.status + ", totalRecurrence=" + this.totalRecurrence + ", invoiceDuration=" + this.invoiceDuration + ", shouldSendEmail=" + this.shouldSendEmail + ", missedPaymentAction=" + this.missedPaymentAction + ", creditCardToken=" + this.creditCardToken + ", startDate=" + this.startDate + ", successRedirectUrl=" + this.successRedirectUrl + ", failureRedirectUrl=" + this.failureRedirectUrl + ", recharge=" + this.recharge + ", chargeImmediately=" + this.chargeImmediately + ", currency=" + this.currency + ")";
        }
    }
}

