/*
 * Decompiled with CFR 0.152.
 */
package com.xendit.model;

import com.xendit.Xendit;
import com.xendit.exception.XenditException;
import com.xendit.model.FixedPaymentCode;
import com.xendit.model.RetailOutletClient;
import java.util.HashMap;
import java.util.Map;

public class RetailOutlet {
    private static RetailOutletClient retailOutletClient;

    public static FixedPaymentCode createFixedPaymentCode(Map<String, Object> params) throws XenditException {
        return RetailOutlet.createFixedPaymentCode(new HashMap<String, String>(), params);
    }

    public static FixedPaymentCode createFixedPaymentCode(Map<String, String> headers, Map<String, Object> params) throws XenditException {
        RetailOutletClient client = RetailOutlet.getClient();
        return client.createFixedPaymentCode(headers, params);
    }

    public static FixedPaymentCode createFixedPaymentCode(String externalId, FixedPaymentCode.RetailOutletName retailOutletName, String name, Number expectedAmount) throws XenditException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("external_id", externalId);
        params.put("retail_outlet_name", (Object)retailOutletName);
        params.put("name", name);
        params.put("expected_amount", expectedAmount);
        RetailOutletClient client = RetailOutlet.getClient();
        return client.createFixedPaymentCode(externalId, retailOutletName, name, expectedAmount);
    }

    public static FixedPaymentCode getFixedPaymentCode(String id) throws XenditException {
        return RetailOutlet.getFixedPaymentCode(id, new HashMap<String, String>());
    }

    public static FixedPaymentCode getFixedPaymentCode(String id, Map<String, String> headers) throws XenditException {
        RetailOutletClient client = RetailOutlet.getClient();
        return client.getFixedPaymentCode(id, headers);
    }

    public static FixedPaymentCode updateFixedPaymentCode(String id, Map<String, Object> params) throws XenditException {
        RetailOutletClient client = RetailOutlet.getClient();
        return client.updateFixedPaymentCode(id, params);
    }

    public static FixedPaymentCode updateFixedPaymentCode(String id, Map<String, String> headers, Map<String, Object> params) throws XenditException {
        RetailOutletClient client = RetailOutlet.getClient();
        return client.updateFixedPaymentCode(id, headers, params);
    }

    public static FixedPaymentCode updateFixedPaymentCode(String id, String name, Number expectedAmount, String expirationDate) throws XenditException {
        RetailOutletClient client = RetailOutlet.getClient();
        return client.updateFixedPaymentCode(id, name, expectedAmount, expirationDate);
    }

    private static RetailOutletClient getClient() {
        if (RetailOutlet.isApiKeyExist()) {
            if (retailOutletClient == null || !retailOutletClient.getOpt().getApiKey().trim().equals(Xendit.apiKey.trim())) {
                retailOutletClient = new RetailOutletClient(Xendit.Opt.setApiKey(Xendit.apiKey), Xendit.getRequestClient());
                return retailOutletClient;
            }
        } else if (retailOutletClient == null || !retailOutletClient.getOpt().getApiKey().trim().equals(Xendit.Opt.getApiKey().trim())) {
            retailOutletClient = new RetailOutletClient(Xendit.Opt, Xendit.getRequestClient());
            return retailOutletClient;
        }
        return retailOutletClient;
    }

    private static boolean isApiKeyExist() {
        return Xendit.apiKey != null;
    }

    RetailOutlet() {
    }

    public static RetailOutletBuilder builder() {
        return new RetailOutletBuilder();
    }

    public static class RetailOutletBuilder {
        RetailOutletBuilder() {
        }

        public RetailOutlet build() {
            return new RetailOutlet();
        }

        public String toString() {
            return "RetailOutlet.RetailOutletBuilder()";
        }
    }
}

