/*
 * Decompiled with CFR 0.152.
 */
package com.xendit.model;

import com.xendit.Xendit;
import com.xendit.exception.XenditException;
import com.xendit.model.FixedPaymentCode;
import com.xendit.network.NetworkClient;
import com.xendit.network.RequestResource;
import java.util.HashMap;
import java.util.Map;

public class RetailOutletClient {
    private Xendit.Option opt;
    private NetworkClient requestClient;

    public Xendit.Option getOpt() {
        return this.opt;
    }

    public FixedPaymentCode createFixedPaymentCode(Map<String, Object> params) throws XenditException {
        return this.createFixedPaymentCode(new HashMap<String, String>(), params);
    }

    public FixedPaymentCode createFixedPaymentCode(Map<String, String> headers, Map<String, Object> params) throws XenditException {
        String url = String.format("%s%s", this.opt.getXenditURL(), "/fixed_payment_code");
        return this.requestClient.request(RequestResource.Method.POST, url, headers, params, this.opt.getApiKey(), FixedPaymentCode.class);
    }

    public FixedPaymentCode createFixedPaymentCode(String externalId, FixedPaymentCode.RetailOutletName retailOutletName, String name, Number expectedAmount) throws XenditException {
        String url = String.format("%s%s", this.opt.getXenditURL(), "/fixed_payment_code");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("external_id", externalId);
        params.put("retail_outlet_name", (Object)retailOutletName);
        params.put("name", name);
        params.put("expected_amount", expectedAmount);
        return this.requestClient.request(RequestResource.Method.POST, url, params, this.opt.getApiKey(), FixedPaymentCode.class);
    }

    public FixedPaymentCode getFixedPaymentCode(String id) throws XenditException {
        return this.getFixedPaymentCode(id, new HashMap<String, String>());
    }

    public FixedPaymentCode getFixedPaymentCode(String id, Map<String, String> headers) throws XenditException {
        String url = String.format("%s%s%s", this.opt.getXenditURL(), "/fixed_payment_code/", id);
        return this.requestClient.request(RequestResource.Method.GET, url, headers, null, this.opt.getApiKey(), FixedPaymentCode.class);
    }

    public FixedPaymentCode updateFixedPaymentCode(String id, Map<String, Object> params) throws XenditException {
        return this.updateFixedPaymentCode(id, new HashMap<String, String>(), params);
    }

    public FixedPaymentCode updateFixedPaymentCode(String id, Map<String, String> headers, Map<String, Object> params) throws XenditException {
        String url = String.format("%s%s%s", this.opt.getXenditURL(), "/fixed_payment_code/", id);
        return this.requestClient.request(RequestResource.Method.PATCH, url, headers, params, this.opt.getApiKey(), FixedPaymentCode.class);
    }

    public FixedPaymentCode updateFixedPaymentCode(String id, String name, Number expectedAmount, String expirationDate) throws XenditException {
        String url = String.format("%s%s%s", this.opt.getXenditURL(), "/fixed_payment_code/", id);
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (name != null) {
            params.put("name", name);
        }
        if (expectedAmount != null) {
            params.put("expected_amount", expectedAmount);
        }
        if (expirationDate != null) {
            params.put("expiration_date", expirationDate);
        }
        return this.requestClient.request(RequestResource.Method.PATCH, url, params, this.opt.getApiKey(), FixedPaymentCode.class);
    }

    public RetailOutletClient(Xendit.Option opt, NetworkClient requestClient) {
        this.opt = opt;
        this.requestClient = requestClient;
    }
}

