/*
 * Decompiled with CFR 0.152.
 */
package com.xendit.model;

import com.google.gson.annotations.SerializedName;
import com.xendit.exception.XenditException;
import com.xendit.model.DirectDebitPayment;
import com.xendit.model.DirectDebitPaymentClient;
import com.xendit.model.LinkedAccountEnum;
import java.util.HashMap;
import java.util.Map;

public class ValidatedLinkedAccount {
    @SerializedName(value="id")
    private String id;
    @SerializedName(value="customer_id")
    private String customerId;
    @SerializedName(value="channel_code")
    private LinkedAccountEnum.ChannelCode channelCode;
    @SerializedName(value="status")
    private String status;

    public static ValidatedLinkedAccount validateOTPWithToken(String tokenId, String otpCode) throws XenditException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("otp_code", otpCode);
        return ValidatedLinkedAccount.validateOTPRequestWithToken(tokenId, new HashMap<String, String>(), params);
    }

    public static ValidatedLinkedAccount validateOTPWithToken(String tokenId, Map<String, Object> params) throws XenditException {
        return ValidatedLinkedAccount.validateOTPRequestWithToken(tokenId, new HashMap<String, String>(), params);
    }

    public static ValidatedLinkedAccount validateOTPWithToken(String tokenId, Map<String, String> headers, Map<String, Object> params) throws XenditException {
        return ValidatedLinkedAccount.validateOTPRequestWithToken(tokenId, headers, params);
    }

    private static ValidatedLinkedAccount validateOTPRequestWithToken(String tokenId, Map<String, String> headers, Map<String, Object> params) throws XenditException {
        DirectDebitPaymentClient client = DirectDebitPayment.getClient();
        return client.validateOTPRequestWithToken(tokenId, headers, params);
    }

    ValidatedLinkedAccount(String id, String customerId, LinkedAccountEnum.ChannelCode channelCode, String status) {
        this.id = id;
        this.customerId = customerId;
        this.channelCode = channelCode;
        this.status = status;
    }

    public static ValidatedLinkedAccountBuilder builder() {
        return new ValidatedLinkedAccountBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public LinkedAccountEnum.ChannelCode getChannelCode() {
        return this.channelCode;
    }

    public String getStatus() {
        return this.status;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public void setChannelCode(LinkedAccountEnum.ChannelCode channelCode) {
        this.channelCode = channelCode;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public static class ValidatedLinkedAccountBuilder {
        private String id;
        private String customerId;
        private LinkedAccountEnum.ChannelCode channelCode;
        private String status;

        ValidatedLinkedAccountBuilder() {
        }

        public ValidatedLinkedAccountBuilder id(String id) {
            this.id = id;
            return this;
        }

        public ValidatedLinkedAccountBuilder customerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public ValidatedLinkedAccountBuilder channelCode(LinkedAccountEnum.ChannelCode channelCode) {
            this.channelCode = channelCode;
            return this;
        }

        public ValidatedLinkedAccountBuilder status(String status) {
            this.status = status;
            return this;
        }

        public ValidatedLinkedAccount build() {
            return new ValidatedLinkedAccount(this.id, this.customerId, this.channelCode, this.status);
        }

        public String toString() {
            return "ValidatedLinkedAccount.ValidatedLinkedAccountBuilder(id=" + this.id + ", customerId=" + this.customerId + ", channelCode=" + (Object)((Object)this.channelCode) + ", status=" + this.status + ")";
        }
    }
}

