/*
 * Decompiled with CFR 0.152.
 */
package com.xendit.network;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.xendit.exception.ApiException;
import com.xendit.exception.AuthException;
import com.xendit.exception.XenditException;
import com.xendit.model.XenditError;
import com.xendit.network.NetworkClient;
import com.xendit.network.RequestResource;
import com.xendit.network.XenditResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class BaseRequest
implements NetworkClient {
    private static final int DEFAULT_CONNECT_TIMEOUT = 60000;

    @Override
    public <T> T request(RequestResource.Method method, String url, Map<String, Object> params, String apiKey, Class<T> clazz) throws XenditException {
        return this.request(method, url, new HashMap<String, String>(), params, apiKey, clazz);
    }

    @Override
    public <T> T request(RequestResource.Method method, String url, Map<String, String> headers, Map<String, Object> params, String apiKey, Class<T> clazz) throws XenditException {
        return BaseRequest.staticRequest(method, url, headers, params, apiKey, clazz);
    }

    private static Map<String, String> getHeaders(String apiKey, Map<String, String> customHeaders) throws XenditException {
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Map.Entry<String, String> header : customHeaders.entrySet()) {
            headers.put(header.getKey(), header.getValue());
        }
        headers.put("User-Agent", "Xendit Java Library/v1");
        headers.put("Accept", "application/json");
        String base64Key = BaseRequest.encodeBase64(apiKey + ":");
        String authorization = customHeaders.getOrDefault("Authorization", "Basic " + base64Key);
        headers.put("Authorization", authorization);
        return headers;
    }

    private static <T> T staticRequest(RequestResource.Method method, String url, Map<String, String> headers, Map<String, Object> params, String apiKey, Class<T> clazz) throws XenditException {
        XenditResponse response = BaseRequest.rawRequest(method, url, headers, params, apiKey);
        int responseCode = response.getStatusCode();
        String responseBody = response.getBody();
        if (responseCode < 200 || responseCode >= 300) {
            BaseRequest.handleApiError(response, params);
        }
        Object resource = null;
        try {
            resource = new Gson().fromJson(responseBody, clazz);
        }
        catch (JsonSyntaxException e) {
            BaseRequest.raiseMalformedJsonError(responseBody, responseCode);
        }
        return (T)resource;
    }

    private static XenditResponse rawRequest(RequestResource.Method method, String url, Map<String, String> headers, Map<String, Object> params, String apiKey) throws XenditException {
        if (apiKey == null || apiKey.trim().isEmpty()) {
            throw new AuthException("No API key is provided yet.");
        }
        String jsonParams = "";
        if (params != null) {
            Gson gson = new GsonBuilder().create();
            jsonParams = gson.toJson(params);
        }
        if (method == RequestResource.Method.PATCH) {
            return BaseRequest.httpPatchXenditConnection(url, apiKey, headers, jsonParams);
        }
        return BaseRequest.defaultHttpXenditConnection(method, url, apiKey, headers, jsonParams);
    }

    private static XenditResponse httpPatchXenditConnection(String url, String apiKey, Map<String, String> headers, String jsonParams) throws XenditException {
        try {
            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(RequestConfig.custom().setCookieSpec("standard").build()).build();
            HttpPatch request = new HttpPatch(url);
            ByteArrayEntity httpEntity = new ByteArrayEntity(jsonParams.getBytes("UTF-8"));
            if (headers.get("Content-Type") == null) {
                request.setHeader("Content-Type", "application/json");
            }
            for (Map.Entry<String, String> header : BaseRequest.getHeaders(apiKey, headers).entrySet()) {
                request.setHeader(header.getKey(), header.getValue());
            }
            request.setEntity((HttpEntity)httpEntity);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
            int responseCode = response.getStatusLine().getStatusCode();
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
            return new XenditResponse(responseCode, responseBody);
        }
        catch (IOException e) {
            throw new XenditException("Connection error");
        }
    }

    private static XenditResponse defaultHttpXenditConnection(RequestResource.Method method, String url, String apiKey, Map<String, String> headers, String jsonParams) throws XenditException {
        HttpURLConnection connection = null;
        try {
            int responseCode;
            connection = BaseRequest.createXenditConnection(url, apiKey, headers);
            connection.setRequestMethod(method.getText());
            if (method == RequestResource.Method.POST) {
                connection.setDoOutput(true);
                connection.setRequestProperty("Accept-Charset", "utf-8");
                connection.setRequestProperty("Content-Type", "application/json;charset=utf-8");
                OutputStream stream = connection.getOutputStream();
                stream.write(jsonParams.getBytes("utf-8"));
                stream.close();
            }
            String responseBody = (responseCode = connection.getResponseCode()) >= 200 && responseCode < 300 ? BaseRequest.getResponseBody(connection.getInputStream()) : BaseRequest.getResponseBody(connection.getErrorStream());
            XenditResponse xenditResponse = new XenditResponse(responseCode, responseBody);
            return xenditResponse;
        }
        catch (IOException e) {
            throw new XenditException("Connection error");
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private static HttpURLConnection createXenditConnection(String url, String apiKey, Map<String, String> headers) throws IOException, XenditException {
        URL xenditUrl = new URL(url);
        HttpURLConnection connection = (HttpURLConnection)xenditUrl.openConnection();
        connection.setConnectTimeout(60000);
        connection.setUseCaches(false);
        for (Map.Entry<String, String> header : BaseRequest.getHeaders(apiKey, headers).entrySet()) {
            connection.setRequestProperty(header.getKey(), header.getValue());
        }
        return connection;
    }

    private static String encodeBase64(String key) throws XenditException {
        try {
            byte[] keyData = key.getBytes(StandardCharsets.UTF_8);
            return Base64.getEncoder().encodeToString(keyData);
        }
        catch (Exception e) {
            throw new XenditException("Failed to encode API key");
        }
    }

    private static String getResponseBody(InputStream responseStream) throws IOException {
        try (Scanner scanner = new Scanner(responseStream, "UTF-8");){
            String responseBody = scanner.useDelimiter("\\A").next();
            responseStream.close();
            String string = responseBody;
            return string;
        }
    }

    private static void handleApiError(XenditResponse response, Map<String, Object> params) throws ApiException {
        Gson gson = new Gson();
        try {
            XenditError xenditError = (XenditError)gson.fromJson(response.getBody(), XenditError.class);
            throw new ApiException(xenditError.getMessage(), xenditError.getErrorCode(), params);
        }
        catch (JsonSyntaxException e) {
            BaseRequest.raiseMalformedJsonError(response.getBody(), response.getStatusCode());
            return;
        }
    }

    private static void raiseMalformedJsonError(String body, int code) throws ApiException {
        throw new ApiException(String.format("Invalid response from Xendit API: %s. HTTP response code: %d", body, code), "500", null);
    }
}

