/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.convert.impl;

import com.xiaoleilu.hutool.convert.Converter;
import com.xiaoleilu.hutool.util.ClassUtil;
import com.xiaoleilu.hutool.util.CollectionUtil;
import com.xiaoleilu.hutool.util.TypeUtil;
import java.lang.reflect.Type;
import java.util.Collection;

public class CollectionConverter
implements Converter<Collection<?>> {
    private final Class<?> collectionType;
    private final Class<?> elementType;

    public CollectionConverter() {
        this(Collection.class);
    }

    public CollectionConverter(Type collectionType) {
        this(collectionType, TypeUtil.getTypeArgument(collectionType));
    }

    public CollectionConverter(Class<?> collectionType) {
        this(collectionType, ClassUtil.getTypeArgument(collectionType));
    }

    public CollectionConverter(Type collectionType, Type elementType) {
        this(TypeUtil.getRowType(collectionType), TypeUtil.getRowType(elementType));
    }

    public CollectionConverter(Class<?> collectionType, Class<?> elementType) {
        this.collectionType = collectionType;
        this.elementType = elementType;
    }

    @Override
    public Collection<?> convert(Object value, Collection<?> defaultValue) throws IllegalArgumentException {
        Collection<?> result = null;
        try {
            result = this.convertInternal(value);
        }
        catch (RuntimeException e) {
            return defaultValue;
        }
        return null == result ? defaultValue : result;
    }

    protected Collection<?> convertInternal(Object value) {
        Collection collection = CollectionUtil.create(this.collectionType);
        return CollectionUtil.addAll(collection, value, this.elementType);
    }
}

