/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db.dialect.impl;

import com.xiaoleilu.hutool.db.DbRuntimeException;
import com.xiaoleilu.hutool.db.DbUtil;
import com.xiaoleilu.hutool.db.Entity;
import com.xiaoleilu.hutool.db.Page;
import com.xiaoleilu.hutool.db.dialect.Dialect;
import com.xiaoleilu.hutool.db.dialect.DialectName;
import com.xiaoleilu.hutool.db.sql.Condition;
import com.xiaoleilu.hutool.db.sql.LogicalOperator;
import com.xiaoleilu.hutool.db.sql.Query;
import com.xiaoleilu.hutool.db.sql.SqlBuilder;
import com.xiaoleilu.hutool.db.sql.Wrapper;
import com.xiaoleilu.hutool.util.ArrayUtil;
import com.xiaoleilu.hutool.util.CollectionUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class AnsiSqlDialect
implements Dialect {
    protected Wrapper wrapper = new Wrapper();

    @Override
    public Wrapper getWrapper() {
        return this.wrapper;
    }

    @Override
    public void setWrapper(Wrapper wrapper) {
        this.wrapper = wrapper;
    }

    @Override
    public PreparedStatement psForInsert(Connection conn, Entity entity) throws SQLException {
        SqlBuilder insert = SqlBuilder.create(this.wrapper).insert(entity, this.dialectName());
        PreparedStatement ps = conn.prepareStatement(insert.build(), 1);
        DbUtil.fillParams(ps, insert.getParamValues());
        return ps;
    }

    @Override
    public PreparedStatement psForInsertBatch(Connection conn, Entity ... entities) throws SQLException {
        if (ArrayUtil.isEmpty(entities)) {
            throw new DbRuntimeException("Entities for batch insert is empty !");
        }
        SqlBuilder insert = SqlBuilder.create(this.wrapper).insert(entities[0], this.dialectName());
        PreparedStatement ps = conn.prepareStatement(insert.build(), 1);
        for (Entity entity : entities) {
            DbUtil.fillParams(ps, CollectionUtil.valuesOfKeys(entity, insert.getFields()));
            ps.addBatch();
        }
        return ps;
    }

    @Override
    public PreparedStatement psForDelete(Connection conn, Query query) throws SQLException {
        if (null == query) {
            throw new NullPointerException("query is null !");
        }
        Condition[] where = query.getWhere();
        if (ArrayUtil.isEmpty(where)) {
            throw new SQLException("No 'WHERE' condition, we can't prepared statement for delete everything.");
        }
        SqlBuilder delete = SqlBuilder.create(this.wrapper).delete(query.getFirstTableName()).where(LogicalOperator.AND, where);
        PreparedStatement ps = conn.prepareStatement(delete.build());
        DbUtil.fillParams(ps, delete.getParamValues());
        return ps;
    }

    @Override
    public PreparedStatement psForUpdate(Connection conn, Entity entity, Query query) throws SQLException {
        if (null == query) {
            throw new NullPointerException("query is null !");
        }
        Condition[] where = query.getWhere();
        if (ArrayUtil.isEmpty(where)) {
            throw new SQLException("No 'WHERE' condition, we can't prepared statement for update everything.");
        }
        SqlBuilder update = SqlBuilder.create(this.wrapper).update(entity).where(LogicalOperator.AND, where);
        PreparedStatement ps = conn.prepareStatement(update.build());
        DbUtil.fillParams(ps, update.getParamValues());
        return ps;
    }

    @Override
    public PreparedStatement psForFind(Connection conn, Query query) throws SQLException {
        if (null == query) {
            throw new NullPointerException("query is null !");
        }
        SqlBuilder find = SqlBuilder.create(this.wrapper).query(query);
        PreparedStatement ps = conn.prepareStatement(find.build());
        DbUtil.fillParams(ps, find.getParamValues());
        return ps;
    }

    @Override
    public PreparedStatement psForPage(Connection conn, Query query) throws SQLException {
        Page page = query.getPage();
        if (null == page) {
            return this.psForFind(conn, query);
        }
        SqlBuilder find = SqlBuilder.create(this.wrapper).query(query).orderBy(page.getOrders());
        find.append(" limit ").append(page.getNumPerPage()).append(" offset ").append(page.getStartPosition());
        PreparedStatement ps = conn.prepareStatement(find.build());
        DbUtil.fillParams(ps, find.getParamValues());
        return ps;
    }

    @Override
    public PreparedStatement psForCount(Connection conn, Query query) throws SQLException {
        query.setFields(CollectionUtil.newArrayList("count(1)"));
        return this.psForFind(conn, query);
    }

    @Override
    public DialectName dialectName() {
        return DialectName.ANSI;
    }
}

