/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.convert;

import com.xiaoleilu.hutool.convert.ConvertException;
import com.xiaoleilu.hutool.convert.Converter;
import com.xiaoleilu.hutool.convert.impl.ArrayConverter;
import com.xiaoleilu.hutool.convert.impl.BooleanArrayConverter;
import com.xiaoleilu.hutool.convert.impl.BooleanConverter;
import com.xiaoleilu.hutool.convert.impl.ByteArrayConverter;
import com.xiaoleilu.hutool.convert.impl.CalendarConverter;
import com.xiaoleilu.hutool.convert.impl.CharArrayConverter;
import com.xiaoleilu.hutool.convert.impl.CharacterConverter;
import com.xiaoleilu.hutool.convert.impl.CharsetConverter;
import com.xiaoleilu.hutool.convert.impl.ClassConverter;
import com.xiaoleilu.hutool.convert.impl.DateConverter;
import com.xiaoleilu.hutool.convert.impl.DateTimeConverter;
import com.xiaoleilu.hutool.convert.impl.DoubleArrayConverter;
import com.xiaoleilu.hutool.convert.impl.FloatArrayConverter;
import com.xiaoleilu.hutool.convert.impl.IntArrayConverter;
import com.xiaoleilu.hutool.convert.impl.LongArrayConverter;
import com.xiaoleilu.hutool.convert.impl.NumberConverter;
import com.xiaoleilu.hutool.convert.impl.PathConverter;
import com.xiaoleilu.hutool.convert.impl.PrimitiveConverter;
import com.xiaoleilu.hutool.convert.impl.ShortArrayConverter;
import com.xiaoleilu.hutool.convert.impl.SqlDateConverter;
import com.xiaoleilu.hutool.convert.impl.SqlTimeConverter;
import com.xiaoleilu.hutool.convert.impl.SqlTimestampConverter;
import com.xiaoleilu.hutool.convert.impl.StringConverter;
import com.xiaoleilu.hutool.convert.impl.TimeZoneConverter;
import com.xiaoleilu.hutool.convert.impl.URIConverter;
import com.xiaoleilu.hutool.convert.impl.URLConverter;
import com.xiaoleilu.hutool.date.DateTime;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;

public class ConverterRegistry {
    private Map<Class<?>, Converter<?>> defaultConverter;
    private Map<Class<?>, Converter<?>> customConverter;

    public static ConverterRegistry getInstance() {
        return SingletonHolder.instance;
    }

    public ConverterRegistry() {
        this.defaultConverter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConverterRegistry putCustom(Class<?> clazz, Converter<?> converter) {
        if (null == this.customConverter) {
            ConverterRegistry converterRegistry = this;
            synchronized (converterRegistry) {
                if (null == this.customConverter) {
                    this.customConverter = new ConcurrentHashMap();
                }
            }
        }
        this.customConverter.put(clazz, converter);
        return this;
    }

    public <T> Converter<T> getConverter(Class<T> type) {
        Converter<Object> converter = this.getCustomConverter(type);
        if (null == converter) {
            converter = this.defaultConverter.get(type);
        }
        return converter;
    }

    public <T> Converter<T> getCustomConverter(Class<T> type) {
        return null == this.customConverter ? null : this.customConverter.get(type);
    }

    public <T> T convert(Class<T> type, Object value, T defaultValue) {
        if (null == type && null == defaultValue) {
            throw new NullPointerException("[type] and [defaultValue] are both null, we can not know what type to convert !");
        }
        if (null == value) {
            return defaultValue;
        }
        if (null == type) {
            type = defaultValue.getClass();
        }
        if (type.isInstance(value)) {
            return (T)value;
        }
        Converter<T> converter = this.getConverter(type);
        if (null == converter) {
            throw new ConvertException("No Converter for type [{}]", type.getName());
        }
        return converter.convert(value, defaultValue);
    }

    public <T> T convert(Class<T> type, Object value) {
        return this.convert(type, value, null);
    }

    private ConverterRegistry defaultConverter() {
        this.defaultConverter = new ConcurrentHashMap();
        this.defaultConverter.put(Byte.TYPE, new PrimitiveConverter(Byte.TYPE));
        this.defaultConverter.put(Short.TYPE, new PrimitiveConverter(Short.TYPE));
        this.defaultConverter.put(Integer.TYPE, new PrimitiveConverter(Integer.TYPE));
        this.defaultConverter.put(Long.TYPE, new PrimitiveConverter(Long.TYPE));
        this.defaultConverter.put(Float.TYPE, new PrimitiveConverter(Float.TYPE));
        this.defaultConverter.put(Double.TYPE, new PrimitiveConverter(Double.TYPE));
        this.defaultConverter.put(Character.TYPE, new PrimitiveConverter(Character.TYPE));
        this.defaultConverter.put(Boolean.TYPE, new PrimitiveConverter(Boolean.TYPE));
        this.defaultConverter.put(String.class, new StringConverter());
        this.defaultConverter.put(Boolean.class, new BooleanConverter());
        this.defaultConverter.put(Character.class, new CharacterConverter());
        this.defaultConverter.put(Number.class, new NumberConverter());
        this.defaultConverter.put(Byte.class, new NumberConverter(Byte.class));
        this.defaultConverter.put(Short.class, new NumberConverter(Short.class));
        this.defaultConverter.put(Integer.class, new NumberConverter(Integer.class));
        this.defaultConverter.put(Long.class, new NumberConverter(Long.class));
        this.defaultConverter.put(Float.class, new NumberConverter(Float.class));
        this.defaultConverter.put(Double.class, new NumberConverter(Double.class));
        this.defaultConverter.put(BigDecimal.class, new NumberConverter(BigDecimal.class));
        this.defaultConverter.put(BigInteger.class, new NumberConverter(BigInteger.class));
        this.defaultConverter.put(Integer[].class, new ArrayConverter<Integer>(Integer.class));
        this.defaultConverter.put(Long[].class, new ArrayConverter<Long>(Long.class));
        this.defaultConverter.put(Byte[].class, new ArrayConverter<Byte>(Byte.class));
        this.defaultConverter.put(Short[].class, new ArrayConverter<Short>(Short.class));
        this.defaultConverter.put(Float[].class, new ArrayConverter<Float>(Float.class));
        this.defaultConverter.put(Double[].class, new ArrayConverter<Double>(Double.class));
        this.defaultConverter.put(Boolean[].class, new ArrayConverter<Boolean>(Boolean.class));
        this.defaultConverter.put(Character[].class, new ArrayConverter<Character>(Character.class));
        this.defaultConverter.put(String[].class, new ArrayConverter<String>(String.class));
        this.defaultConverter.put(byte[].class, new ByteArrayConverter());
        this.defaultConverter.put(short[].class, new ShortArrayConverter());
        this.defaultConverter.put(int[].class, new IntArrayConverter());
        this.defaultConverter.put(long[].class, new LongArrayConverter());
        this.defaultConverter.put(float[].class, new FloatArrayConverter());
        this.defaultConverter.put(double[].class, new DoubleArrayConverter());
        this.defaultConverter.put(boolean[].class, new BooleanArrayConverter());
        this.defaultConverter.put(char[].class, new CharArrayConverter());
        this.defaultConverter.put(URI.class, new URIConverter());
        this.defaultConverter.put(URL.class, new URLConverter());
        this.defaultConverter.put(Calendar.class, new CalendarConverter());
        this.defaultConverter.put(Date.class, new DateConverter());
        this.defaultConverter.put(DateTime.class, new DateTimeConverter());
        this.defaultConverter.put(Date.class, new SqlDateConverter());
        this.defaultConverter.put(Time.class, new SqlTimeConverter());
        this.defaultConverter.put(Timestamp.class, new SqlTimestampConverter());
        this.defaultConverter.put(Class.class, new ClassConverter());
        this.defaultConverter.put(TimeZone.class, new TimeZoneConverter());
        this.defaultConverter.put(Charset.class, new CharsetConverter());
        this.defaultConverter.put(Path.class, new PathConverter());
        return this;
    }

    private static class SingletonHolder {
        private static ConverterRegistry instance = new ConverterRegistry();

        private SingletonHolder() {
        }
    }
}

