/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.util;

import com.xiaoleilu.hutool.exceptions.UtilException;
import com.xiaoleilu.hutool.io.FileUtil;
import com.xiaoleilu.hutool.io.IoUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XmlUtil {
    public static final String INVALID_REGEX = "[\\x00-\\x08\\x0b-\\x0c\\x0e-\\x1f]";

    public static Document readXML(File file) {
        if (file == null) {
            throw new NullPointerException("Xml file is null !");
        }
        if (!file.exists()) {
            throw new UtilException("File [" + file.getAbsolutePath() + "] not a exist!");
        }
        if (!file.isFile()) {
            throw new UtilException("[" + file.getAbsolutePath() + "] not a file!");
        }
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException e) {
            // empty catch block
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = dbf.newDocumentBuilder();
            return builder.parse(file);
        }
        catch (Exception e) {
            throw new UtilException("Parse xml file [" + file.getAbsolutePath() + "] error!", e);
        }
    }

    public static Document readXML(String absoluteFilePath) {
        return XmlUtil.readXML(new File(absoluteFilePath));
    }

    public static Document parseXml(String xmlStr) {
        if (StrUtil.isBlank(xmlStr)) {
            throw new UtilException("Xml content string is empty !");
        }
        xmlStr = XmlUtil.cleanInvalid(xmlStr);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = dbf.newDocumentBuilder();
            return builder.parse(new InputSource(StrUtil.getReader(xmlStr)));
        }
        catch (Exception e) {
            throw new UtilException("Parse xml file [" + xmlStr + "] error!", e);
        }
    }

    public static String toStr(Document doc) {
        return XmlUtil.toStr(doc, "UTF-8");
    }

    public static String toStr(Document doc, String charset) {
        try {
            StringWriter writer = StrUtil.getWriter();
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.setOutputProperty("encoding", charset);
            xformer.setOutputProperty("indent", "yes");
            xformer.transform(new DOMSource(doc), new StreamResult(writer));
            return writer.toString();
        }
        catch (Exception e) {
            throw new UtilException("Trans xml document to string error!", e);
        }
    }

    public static void toFile(Document doc, String absolutePath) {
        XmlUtil.toFile(doc, absolutePath, null);
    }

    public static void toFile(Document doc, String absolutePath, String charset) {
        if (StrUtil.isBlank(charset)) {
            charset = doc.getXmlEncoding();
        }
        if (StrUtil.isBlank(charset)) {
            charset = "UTF-8";
        }
        BufferedWriter writer = null;
        try {
            writer = FileUtil.getWriter(absolutePath, charset, false);
            DOMSource source = new DOMSource(doc);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.setOutputProperty("encoding", charset);
            xformer.setOutputProperty("indent", "yes");
            xformer.transform(source, new StreamResult(writer));
        }
        catch (Exception e) {
            try {
                throw new UtilException("Trans xml document to string error!", e);
            }
            catch (Throwable throwable) {
                IoUtil.close(writer);
                throw throwable;
            }
        }
        IoUtil.close(writer);
    }

    public static Document createXml(String rootElementName) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = dbf.newDocumentBuilder();
        }
        catch (Exception e) {
            throw new UtilException("Create xml document error!", e);
        }
        Document doc = builder.newDocument();
        doc.appendChild(doc.createElement(rootElementName));
        return doc;
    }

    public static String cleanInvalid(String xmlContent) {
        if (xmlContent == null) {
            return null;
        }
        return xmlContent.replaceAll(INVALID_REGEX, "");
    }

    public static List<Element> getElements(Element element, String tagName) {
        NodeList nodeList = element.getElementsByTagName(tagName);
        return XmlUtil.transElements(element, nodeList);
    }

    public static Element getElement(Element element, String tagName) {
        NodeList nodeList = element.getElementsByTagName(tagName);
        if (nodeList == null || nodeList.getLength() < 1) {
            return null;
        }
        int length = nodeList.getLength();
        for (int i = 0; i < length; ++i) {
            Element childEle = (Element)nodeList.item(i);
            if (childEle != null && childEle.getParentNode() != element) continue;
            return childEle;
        }
        return null;
    }

    public static String elementText(Element element, String tagName) {
        Element child = XmlUtil.getElement(element, tagName);
        return child == null ? null : child.getTextContent();
    }

    public static String elementText(Element element, String tagName, String defaultValue) {
        Element child = XmlUtil.getElement(element, tagName);
        return child == null ? defaultValue : child.getTextContent();
    }

    public static List<Element> transElements(NodeList nodeList) {
        return XmlUtil.transElements(null, nodeList);
    }

    public static List<Element> transElements(Element parentEle, NodeList nodeList) {
        ArrayList<Element> elements = new ArrayList<Element>();
        int length = nodeList.getLength();
        for (int i = 0; i < length; ++i) {
            Element element = (Element)nodeList.item(i);
            if (parentEle != null && element.getParentNode() != parentEle) continue;
            elements.add(element);
        }
        return elements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void writeObjectAsXml(File dest, T t) throws IOException {
        FileOutputStream fos = null;
        XMLEncoder xmlenc = null;
        try {
            fos = new FileOutputStream(dest);
            xmlenc = new XMLEncoder(new BufferedOutputStream(fos));
            xmlenc.writeObject(t);
        }
        catch (Throwable throwable) {
            IoUtil.close(fos);
            if (xmlenc != null) {
                xmlenc.close();
            }
            throw throwable;
        }
        IoUtil.close(fos);
        if (xmlenc != null) {
            xmlenc.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T readObjectFromXml(File source) throws IOException {
        Object result = null;
        FileInputStream fis = null;
        XMLDecoder xmldec = null;
        try {
            fis = new FileInputStream(source);
            xmldec = new XMLDecoder(new BufferedInputStream(fis));
            result = xmldec.readObject();
        }
        catch (Throwable throwable) {
            IoUtil.close(fis);
            if (xmldec != null) {
                xmldec.close();
            }
            throw throwable;
        }
        IoUtil.close(fis);
        if (xmldec != null) {
            xmldec.close();
        }
        return (T)result;
    }
}

