/*
 * Decompiled with CFR 0.152.
 */
package com.xkcoding.http;

import com.xkcoding.http.exception.SimpleHttpException;
import com.xkcoding.http.support.Http;
import com.xkcoding.http.support.HttpHeader;
import com.xkcoding.http.support.httpclient.HttpClientImpl;
import com.xkcoding.http.support.hutool.HutoolImpl;
import com.xkcoding.http.support.okhttp3.OkHttp3Impl;
import com.xkcoding.http.util.ClassUtil;
import java.util.Map;

public final class HttpUtil {
    private static Http proxy;

    public static void setHttp(Http http) {
        proxy = http;
    }

    private static void checkHttpNotNull(Http proxy) {
        if (null == proxy) {
            throw new SimpleHttpException("HTTP \u5b9e\u73b0\u7c7b\u672a\u6307\u5b9a\uff01");
        }
    }

    public static String get(String url) {
        HttpUtil.checkHttpNotNull(proxy);
        return proxy.get(url);
    }

    public static String get(String url, Map<String, String> params, boolean encode) {
        HttpUtil.checkHttpNotNull(proxy);
        return proxy.get(url, params, encode);
    }

    public static String get(String url, Map<String, String> params, HttpHeader header, boolean encode) {
        HttpUtil.checkHttpNotNull(proxy);
        return proxy.get(url, params, header, encode);
    }

    public static String post(String url) {
        HttpUtil.checkHttpNotNull(proxy);
        return proxy.post(url);
    }

    public static String post(String url, String data) {
        HttpUtil.checkHttpNotNull(proxy);
        return proxy.post(url, data);
    }

    public static String post(String url, String data, HttpHeader header) {
        HttpUtil.checkHttpNotNull(proxy);
        return proxy.post(url, data, header);
    }

    public static String post(String url, Map<String, String> params, boolean encode) {
        HttpUtil.checkHttpNotNull(proxy);
        return proxy.post(url, params, encode);
    }

    public static String post(String url, Map<String, String> params, HttpHeader header, boolean encode) {
        HttpUtil.checkHttpNotNull(proxy);
        return proxy.post(url, params, header, encode);
    }

    private HttpUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        Http defaultProxy = null;
        ClassLoader classLoader = HttpUtil.class.getClassLoader();
        if (ClassUtil.isPresent("java.net.http.HttpClient", classLoader)) {
            defaultProxy = new com.xkcoding.http.support.java11.HttpClientImpl();
        } else if (ClassUtil.isPresent("okhttp3.OkHttpClient", classLoader)) {
            defaultProxy = new OkHttp3Impl();
        } else if (ClassUtil.isPresent("org.apache.http.impl.client.HttpClients", classLoader)) {
            defaultProxy = new HttpClientImpl();
        } else if (ClassUtil.isPresent("cn.hutool.http.HttpRequest", classLoader)) {
            defaultProxy = new HutoolImpl();
        }
        proxy = defaultProxy;
    }
}

