/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.mq.core.consumer.impl;

import com.xxl.mq.core.consumer.IConsumer;
import java.lang.reflect.Method;

public class MethodConsumer
extends IConsumer {
    private final Object target;
    private final Method method;
    private Method initMethod;
    private Method destroyMethod;

    public MethodConsumer(Object target, Method method, Method initMethod, Method destroyMethod) {
        this.target = target;
        this.method = method;
        this.initMethod = initMethod;
        this.destroyMethod = destroyMethod;
    }

    @Override
    public void consume() throws Exception {
        Class<?>[] paramTypes = this.method.getParameterTypes();
        if (paramTypes.length > 0) {
            this.method.invoke(this.target, new Object[paramTypes.length]);
        } else {
            this.method.invoke(this.target, new Object[0]);
        }
    }

    @Override
    public void init() throws Exception {
        if (this.initMethod != null) {
            this.initMethod.invoke(this.target, new Object[0]);
        }
    }

    @Override
    public void destroy() throws Exception {
        if (this.destroyMethod != null) {
            this.destroyMethod.invoke(this.target, new Object[0]);
        }
    }

    public String toString() {
        return super.toString() + "[" + this.target.getClass() + "#" + this.method.getName() + "]";
    }
}

