/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.mq.core.thread;

import com.xxl.mq.core.bootstrap.XxlMqBootstrap;
import com.xxl.mq.core.openapi.model.RegistryRequest;
import com.xxl.tool.concurrent.CyclicThread;
import com.xxl.tool.response.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryThread {
    private static final Logger logger = LoggerFactory.getLogger(RegistryThread.class);
    public static final int BEAT_TIME_INTERVAL = 30000;
    private final XxlMqBootstrap xxlMqBootstrap;

    public RegistryThread(XxlMqBootstrap xxlMqBootstrap) {
        this.xxlMqBootstrap = xxlMqBootstrap;
    }

    public void start() {
        CyclicThread cyclicRegistryThread = new CyclicThread("cyclicRegistryThread", true, new Runnable(){

            @Override
            public void run() {
                RegistryRequest registryRequest = new RegistryRequest();
                registryRequest.setAccesstoken(RegistryThread.this.xxlMqBootstrap.getAccesstoken());
                registryRequest.setAppname(RegistryThread.this.xxlMqBootstrap.getAppname());
                registryRequest.setInstanceUuid(RegistryThread.this.xxlMqBootstrap.getInstanceUuid());
                registryRequest.setTopicList(RegistryThread.this.xxlMqBootstrap.getAllConsumerTopicList());
                for (int i = 0; i < 3; ++i) {
                    try {
                        Response<String> registryResponse = RegistryThread.this.xxlMqBootstrap.loadBrokerClient().registry(registryRequest);
                        if (registryResponse.isSuccess()) {
                            logger.debug(">>>>>>>>>>> xxl-mq RegistryThread-cyclicRegistryThread registry success, registryRequest:{}, registryResponse:{}", (Object)registryRequest, registryResponse);
                            break;
                        }
                        logger.error(">>>>>>>>>>> xxl-mq RegistryThread-cyclicRegistryThread registry fail, registryRequest:{}, registryResponse:{}", (Object)registryRequest, registryResponse);
                        continue;
                    }
                    catch (Exception e) {
                        logger.error(">>>>>>>>>>> xxl-mq RegistryThread-cyclicRegistryThread registry error, registryRequest:{}", (Object)registryRequest, (Object)e);
                    }
                }
            }
        }, 30000L, true);
        cyclicRegistryThread.start();
    }

    public void stop() {
        RegistryRequest registryRequest = new RegistryRequest();
        registryRequest.setAccesstoken(this.xxlMqBootstrap.getAccesstoken());
        registryRequest.setAppname(this.xxlMqBootstrap.getAppname());
        registryRequest.setInstanceUuid(this.xxlMqBootstrap.getInstanceUuid());
        registryRequest.setTopicList(this.xxlMqBootstrap.getAllConsumerTopicList());
        for (int i = 0; i < 3; ++i) {
            try {
                Response<String> registryResponse = this.xxlMqBootstrap.loadBrokerClient().registryRemove(registryRequest);
                if (!registryResponse.isSuccess()) continue;
                logger.info(">>>>>>>>>>> xxl-mq RegistryThread-cyclicRegistryThread registryRemove success, registryParam:{}", (Object)registryRequest);
                break;
            }
            catch (Exception e) {
                logger.error(">>>>>>>>>>> xxl-mq RegistryThread-cyclicRegistryThread registryRemove error, registryParam:{}", (Object)registryRequest, (Object)e);
            }
        }
    }
}

