/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.rpc.remoting.net.impl.netty.server;

import com.xxl.rpc.remoting.net.Server;
import com.xxl.rpc.remoting.net.impl.netty.codec.NettyDecoder;
import com.xxl.rpc.remoting.net.impl.netty.codec.NettyEncoder;
import com.xxl.rpc.remoting.net.impl.netty.server.NettyServerHandler;
import com.xxl.rpc.remoting.net.params.XxlRpcRequest;
import com.xxl.rpc.remoting.net.params.XxlRpcResponse;
import com.xxl.rpc.remoting.provider.XxlRpcProviderFactory;
import com.xxl.rpc.util.ThreadPoolUtil;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.util.concurrent.ThreadPoolExecutor;

public class NettyServer
extends Server {
    private Thread thread;

    @Override
    public void start(final XxlRpcProviderFactory xxlRpcProviderFactory) throws Exception {
        this.thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                final ThreadPoolExecutor serverHandlerPool = ThreadPoolUtil.makeServerThreadPool(NettyServer.class.getSimpleName());
                NioEventLoopGroup bossGroup = new NioEventLoopGroup();
                NioEventLoopGroup workerGroup = new NioEventLoopGroup();
                try {
                    ServerBootstrap bootstrap = new ServerBootstrap();
                    ((ServerBootstrap)bootstrap.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                        public void initChannel(SocketChannel channel) throws Exception {
                            channel.pipeline().addLast(new ChannelHandler[]{new NettyDecoder(XxlRpcRequest.class, xxlRpcProviderFactory.getSerializer())}).addLast(new ChannelHandler[]{new NettyEncoder(XxlRpcResponse.class, xxlRpcProviderFactory.getSerializer())}).addLast(new ChannelHandler[]{new NettyServerHandler(xxlRpcProviderFactory, serverHandlerPool)});
                        }
                    }).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
                    ChannelFuture future = bootstrap.bind(xxlRpcProviderFactory.getPort()).sync();
                    logger.info(">>>>>>>>>>> xxl-rpc remoting server start success, nettype = {}, port = {}", (Object)NettyServer.class.getName(), (Object)xxlRpcProviderFactory.getPort());
                    NettyServer.this.onStarted();
                    future.channel().closeFuture().sync();
                }
                catch (Exception e) {
                    if (e instanceof InterruptedException) {
                        logger.info(">>>>>>>>>>> xxl-rpc remoting server stop.");
                    } else {
                        logger.error(">>>>>>>>>>> xxl-rpc remoting server error.", (Throwable)e);
                    }
                }
                finally {
                    try {
                        serverHandlerPool.shutdown();
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    try {
                        workerGroup.shutdownGracefully();
                        bossGroup.shutdownGracefully();
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        });
        this.thread.setDaemon(true);
        this.thread.start();
    }

    @Override
    public void stop() throws Exception {
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.interrupt();
        }
        this.onStoped();
        logger.info(">>>>>>>>>>> xxl-rpc remoting server destroy success.");
    }
}

