/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.feed.client.impl;

import ai.vespa.feed.client.FeedClientBuilder;
import ai.vespa.feed.client.HttpResponse;
import ai.vespa.feed.client.impl.Cluster;
import ai.vespa.feed.client.impl.FeedClientBuilderImpl;
import ai.vespa.feed.client.impl.HttpRequest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.client5.http.ssl.ClientTlsStrategyBuilder;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.ssl.TlsCiphers;
import org.apache.hc.core5.http2.config.H2Config;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.util.Timeout;

class ApacheCluster
implements Cluster {
    private final List<Endpoint> endpoints = new ArrayList<Endpoint>();
    private final List<BasicHeader> defaultHeaders = Arrays.asList(new BasicHeader("User-Agent", (Object)String.format("vespa-feed-client/%s", "8.190.2")), new BasicHeader("Vespa-Client-Version", (Object)"8.190.2"));
    private final Header gzipEncodingHeader = new BasicHeader("Content-Encoding", (Object)"gzip");
    private final FeedClientBuilder.Compression compression;
    private int someNumber = 0;
    private final ExecutorService dispatchExecutor = Executors.newFixedThreadPool(8, t -> new Thread(t, "request-dispatch-thread"));
    private final ScheduledExecutorService timeoutExecutor = Executors.newSingleThreadScheduledExecutor(t -> new Thread(t, "request-timeout-thread"));

    ApacheCluster(FeedClientBuilderImpl builder) throws IOException {
        for (int i = 0; i < builder.connectionsPerEndpoint; ++i) {
            for (URI endpoint : builder.endpoints) {
                this.endpoints.add(new Endpoint(ApacheCluster.createHttpClient(builder), endpoint));
            }
        }
        this.compression = builder.compression;
    }

    @Override
    public void dispatch(HttpRequest wrapped, final CompletableFuture<HttpResponse> vessel) {
        Endpoint leastBusy = this.endpoints.get(0);
        int min = Integer.MAX_VALUE;
        int start = ++this.someNumber % this.endpoints.size();
        for (int i = 0; i < this.endpoints.size(); ++i) {
            Endpoint endpoint = this.endpoints.get((i + start) % this.endpoints.size());
            int inflight = endpoint.inflight.get();
            if (inflight >= min) continue;
            leastBusy = endpoint;
            min = inflight;
        }
        Endpoint endpoint = leastBusy;
        endpoint.inflight.incrementAndGet();
        this.dispatchExecutor.execute(() -> {
            try {
                SimpleHttpRequest request = new SimpleHttpRequest(wrapped.method(), wrapped.path());
                request.setScheme(endpoint.url.getScheme());
                request.setAuthority(new URIAuthority(endpoint.url.getHost(), ApacheCluster.portOf(endpoint.url)));
                request.setConfig(RequestConfig.custom().setConnectionRequestTimeout(Timeout.DISABLED).build());
                this.defaultHeaders.forEach(arg_0 -> ((SimpleHttpRequest)request).setHeader(arg_0));
                wrapped.headers().forEach((name, value) -> request.setHeader(name, value.get()));
                if (wrapped.body() != null) {
                    byte[] body = wrapped.body();
                    if (this.compression == FeedClientBuilder.Compression.gzip || this.compression == FeedClientBuilder.Compression.auto && body.length > 512) {
                        request.setHeader(this.gzipEncodingHeader);
                        body = this.gzipped(body);
                    }
                    request.setBody(body, ContentType.APPLICATION_JSON);
                }
                Future future = endpoint.client.execute(request, (FutureCallback)new FutureCallback<SimpleHttpResponse>(){

                    public void completed(SimpleHttpResponse response) {
                        vessel.complete(new ApacheHttpResponse(response));
                    }

                    public void failed(Exception ex) {
                        vessel.completeExceptionally(ex);
                    }

                    public void cancelled() {
                        vessel.cancel(false);
                    }
                });
                long timeoutMillis = wrapped.timeout() == null ? 190000L : wrapped.timeout().toMillis();
                ScheduledFuture<?> cancellation = this.timeoutExecutor.schedule(() -> {
                    vessel.completeExceptionally(new TimeoutException(String.format("Request timed out after %dms", timeoutMillis)));
                    future.cancel(true);
                }, timeoutMillis * 11L / 10L + 1000L, TimeUnit.MILLISECONDS);
                vessel.whenComplete((__, ___) -> cancellation.cancel(true));
            }
            catch (Throwable thrown) {
                vessel.completeExceptionally(thrown);
            }
            vessel.whenComplete((__, ___) -> endpoint.inflight.decrementAndGet());
        });
    }

    private byte[] gzipped(byte[] content) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(1024);
        try (GZIPOutputStream zip = new GZIPOutputStream(buffer);){
            zip.write(content);
        }
        return buffer.toByteArray();
    }

    @Override
    public void close() {
        Throwable thrown = null;
        this.dispatchExecutor.shutdownNow().forEach(Runnable::run);
        for (Endpoint endpoint : this.endpoints) {
            try {
                endpoint.client.close();
            }
            catch (Throwable t) {
                if (thrown == null) {
                    thrown = t;
                    continue;
                }
                thrown.addSuppressed(t);
            }
        }
        this.timeoutExecutor.shutdownNow().forEach(Runnable::run);
        if (thrown != null) {
            throw new RuntimeException(thrown);
        }
    }

    private static CloseableHttpAsyncClient createHttpClient(FeedClientBuilderImpl builder) throws IOException {
        SSLContext sslContext = builder.constructSslContext();
        String[] allowedCiphers = TlsCiphers.excludeH2Blacklisted((String[])TlsCiphers.excludeWeak((String[])sslContext.getSupportedSSLParameters().getCipherSuites()));
        if (allowedCiphers.length == 0) {
            throw new IllegalStateException("No adequate SSL cipher suites supported by the JVM");
        }
        ClientTlsStrategyBuilder tlsStrategyBuilder = ClientTlsStrategyBuilder.create().setCiphers(allowedCiphers).setSslContext(sslContext);
        if (builder.hostnameVerifier != null) {
            tlsStrategyBuilder.setHostnameVerifier(builder.hostnameVerifier);
        }
        Timeout socketTimeout = Timeout.ofMinutes((long)15L);
        ConnectionConfig connCfg = ConnectionConfig.custom().setSocketTimeout(socketTimeout).setConnectTimeout(Timeout.ofSeconds((long)10L)).build();
        return HttpAsyncClients.customHttp2().setH2Config(H2Config.custom().setMaxConcurrentStreams(builder.maxStreamsPerConnection).setCompressionEnabled(true).setPushEnabled(false).setInitialWindowSize(Integer.MAX_VALUE).build()).setIOReactorConfig(IOReactorConfig.custom().setIoThreadCount(Math.max(Math.min(Runtime.getRuntime().availableProcessors(), 8), 2)).setTcpNoDelay(true).setSoTimeout(socketTimeout).build()).setTlsStrategy(tlsStrategyBuilder.build()).setDefaultConnectionConfig(connCfg).disableAutomaticRetries().disableRedirectHandling().disableCookieManagement().build();
    }

    private static int portOf(URI url) {
        return url.getPort() == -1 ? (url.getScheme().equals("http") ? 80 : 443) : url.getPort();
    }

    private static class Endpoint {
        private final CloseableHttpAsyncClient client;
        private final AtomicInteger inflight = new AtomicInteger(0);
        private final URI url;

        private Endpoint(CloseableHttpAsyncClient client, URI url) {
            this.client = client;
            this.url = url;
            this.client.start();
        }
    }

    private static class ApacheHttpResponse
    implements HttpResponse {
        private final SimpleHttpResponse wrapped;

        private ApacheHttpResponse(SimpleHttpResponse wrapped) {
            this.wrapped = wrapped;
        }

        public int code() {
            return this.wrapped.getCode();
        }

        public byte[] body() {
            return this.wrapped.getBodyBytes();
        }

        public String contentType() {
            return this.wrapped.getContentType().getMimeType();
        }

        public String toString() {
            return "HTTP response with code " + this.code() + (this.body() != null ? " and body '" + this.wrapped.getBodyText() + "'" : "");
        }
    }
}

