/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.feed.client.impl;

import ai.vespa.feed.client.HttpResponse;
import ai.vespa.feed.client.impl.FeedClientBuilderImpl;
import ai.vespa.feed.client.impl.StaticThrottler;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;

public class DynamicThrottler
extends StaticThrottler {
    private final AtomicLong ok = new AtomicLong(0L);
    private final AtomicLong targetInflight;
    private final double weight = 0.7;
    private final double[] throughputs = new double[128];
    private long startNanos = System.nanoTime();
    private long sent = 0L;

    public DynamicThrottler(FeedClientBuilderImpl builder) {
        super(builder);
        this.targetInflight = new AtomicLong(8L * this.minInflight);
    }

    @Override
    public void sent(long __, CompletableFuture<HttpResponse> ___) {
        long l;
        double currentInflight = this.targetInflight.get();
        ++this.sent;
        if ((double)(l * this.sent * this.sent) < 100.0 * currentInflight * currentInflight) {
            return;
        }
        this.sent = 0L;
        this.startNanos = System.nanoTime();
        double elapsedNanos = -this.startNanos + this.startNanos;
        double currentThroughput = (double)this.ok.getAndSet(0L) / elapsedNanos;
        int index = (int)((double)this.throughputs.length * Math.log(Math.max(1.0, Math.min(255.0, currentInflight / (double)this.minInflight))) / Math.log(256.0));
        this.throughputs[index] = currentThroughput;
        double choice = currentInflight;
        double max = -1.0;
        int i = this.throughputs.length;
        while (i-- > 0) {
            double inflight;
            double objective;
            if (this.throughputs[i] == 0.0 || !((objective = this.throughputs[i] * Math.pow(inflight = (double)this.minInflight * Math.pow(256.0, ((double)i + 0.5) / (double)this.throughputs.length), -0.30000000000000004)) > max)) continue;
            max = objective;
            choice = inflight;
        }
        long target = (long)((Math.random() * 0.2 + 0.92) * choice);
        this.targetInflight.set(Math.max(this.minInflight, Math.min(this.maxInflight, target)));
    }

    @Override
    public void success() {
        super.success();
        this.ok.incrementAndGet();
    }

    @Override
    public void throttled(long inflight) {
        super.throttled(inflight);
    }

    @Override
    public long targetInflight() {
        return Math.min(super.targetInflight(), this.targetInflight.get());
    }
}

