/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.http.impl.apache;

import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpInetConnection;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YopServerResponseInterceptor
implements HttpResponseInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(YopServerResponseInterceptor.class);
    public static final YopServerResponseInterceptor INSTANCE = new YopServerResponseInterceptor();

    private YopServerResponseInterceptor() {
    }

    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        try {
            Header alreadyUsed = response.getFirstHeader("x-yop-server-ip");
            if (null == alreadyUsed) {
                response.addHeader("x-yop-server-ip", ((HttpInetConnection)context.getAttribute("http.connection")).getRemoteAddress().getHostAddress());
            }
        }
        catch (Exception e) {
            LOGGER.error("error when get yop server info, ex:", (Throwable)e);
        }
    }
}

