/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.flow;

import cn.hutool.core.collection.ListUtil;
import com.yomahub.liteflow.exception.LiteFlowException;
import com.yomahub.liteflow.flow.entity.CmpStep;
import com.yomahub.liteflow.slot.Slot;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;

public class LiteflowResponse {
    private String chainId;
    private boolean success;
    private String code;
    private String message;
    private Exception cause;
    private Slot slot;

    public static LiteflowResponse newMainResponse(Slot slot) {
        return LiteflowResponse.newResponse(slot, slot.getException());
    }

    public static LiteflowResponse newInnerResponse(String chainId, Slot slot) {
        return LiteflowResponse.newResponse(slot, slot.getSubException(chainId));
    }

    private static LiteflowResponse newResponse(Slot slot, Exception e) {
        LiteflowResponse response = new LiteflowResponse();
        response.setChainId(slot.getChainId());
        if (e != null) {
            response.setSuccess(false);
            response.setCause(e);
            response.setMessage(response.getCause().getMessage());
            response.setCode(response.getCause() instanceof LiteFlowException ? ((LiteFlowException)response.getCause()).getCode() : null);
        } else {
            response.setSuccess(true);
        }
        response.setSlot(slot);
        return response;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Exception getCause() {
        return this.cause;
    }

    public void setCause(Exception cause) {
        this.cause = cause;
    }

    public Slot getSlot() {
        return this.slot;
    }

    public void setSlot(Slot slot) {
        this.slot = slot;
    }

    public <T> T getFirstContextBean() {
        return this.getSlot().getFirstContextBean();
    }

    public <T> T getContextBean(Class<T> contextBeanClazz) {
        return this.getSlot().getContextBean(contextBeanClazz);
    }

    public <T> T getContextBean(String contextName) {
        return this.getSlot().getContextBean(contextName);
    }

    public Map<String, List<CmpStep>> getExecuteSteps() {
        LinkedHashMap<String, List<CmpStep>> map = new LinkedHashMap<String, List<CmpStep>>();
        this.getSlot().getExecuteSteps().forEach(cmpStep -> {
            if (map.containsKey(cmpStep.getNodeId())) {
                ((List)map.get(cmpStep.getNodeId())).add(cmpStep);
            } else {
                map.put(cmpStep.getNodeId(), ListUtil.toList((Object[])new CmpStep[]{cmpStep}));
            }
        });
        return map;
    }

    public Queue<CmpStep> getRollbackStepQueue() {
        return this.getSlot().getRollbackSteps();
    }

    public String getRollbackStepStr() {
        return this.getRollbackStepStrWithoutTime();
    }

    public String getRollbackStepStrWithTime() {
        return this.getSlot().getRollbackStepStr(true);
    }

    public String getRollbackStepStrWithoutTime() {
        return this.getSlot().getRollbackStepStr(false);
    }

    public Map<String, List<CmpStep>> getRollbackSteps() {
        LinkedHashMap<String, List<CmpStep>> map = new LinkedHashMap<String, List<CmpStep>>();
        this.getSlot().getRollbackSteps().forEach(cmpStep -> {
            if (map.containsKey(cmpStep.getNodeId())) {
                ((List)map.get(cmpStep.getNodeId())).add(cmpStep);
            } else {
                map.put(cmpStep.getNodeId(), ListUtil.toList((Object[])new CmpStep[]{cmpStep}));
            }
        });
        return map;
    }

    public Queue<CmpStep> getExecuteStepQueue() {
        return this.getSlot().getExecuteSteps();
    }

    public String getExecuteStepStr() {
        return this.getExecuteStepStrWithoutTime();
    }

    public String getExecuteStepStrWithTime() {
        return this.getSlot().getExecuteStepStr(true);
    }

    public String getExecuteStepStrWithoutTime() {
        return this.getSlot().getExecuteStepStr(false);
    }

    public String getRequestId() {
        return this.getSlot().getRequestId();
    }

    public String getChainId() {
        return this.chainId;
    }

    public void setChainId(String chainId) {
        this.chainId = chainId;
    }
}

