/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.thread;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.enums.ConditionTypeEnum;
import com.yomahub.liteflow.exception.ThreadExecutorServiceCreateException;
import com.yomahub.liteflow.flow.FlowBus;
import com.yomahub.liteflow.flow.element.Chain;
import com.yomahub.liteflow.flow.element.Condition;
import com.yomahub.liteflow.log.LFLog;
import com.yomahub.liteflow.log.LFLoggerManager;
import com.yomahub.liteflow.property.LiteflowConfig;
import com.yomahub.liteflow.property.LiteflowConfigGetter;
import com.yomahub.liteflow.slot.DataBus;
import com.yomahub.liteflow.spi.holder.ContextAwareHolder;
import com.yomahub.liteflow.thread.ExecutorBuilder;
import com.yomahub.liteflow.thread.ExecutorCondition.ExecutorCondition;
import com.yomahub.liteflow.thread.ExecutorCondition.ExecutorConditionBuilder;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public class ExecutorHelper {
    private final LFLog LOG = LFLoggerManager.getLogger(ExecutorHelper.class);
    private final Map<String, ExecutorService> executorServiceMap = MapUtil.newConcurrentHashMap();

    private ExecutorHelper() {
    }

    public static ExecutorHelper loadInstance() {
        return Holder.INSTANCE;
    }

    public void shutdownAwaitTermination(ExecutorService pool) {
        this.shutdownAwaitTermination(pool, 60L);
    }

    public void shutdownAwaitTermination(ExecutorService pool, long timeout) {
        pool.shutdown();
        try {
            if (!pool.awaitTermination(timeout, TimeUnit.SECONDS)) {
                pool.shutdownNow();
                if (!pool.awaitTermination(timeout, TimeUnit.SECONDS)) {
                    this.LOG.error("Pool did not terminate.");
                }
            }
        }
        catch (InterruptedException ie) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public ExecutorService buildWhenExecutor() {
        LiteflowConfig liteflowConfig = LiteflowConfigGetter.get();
        return this.buildWhenExecutor(liteflowConfig.getGlobalThreadPoolExecutorClass());
    }

    public ExecutorService buildWhenExecutor(String clazz) {
        if (StrUtil.isBlank((CharSequence)clazz)) {
            return this.buildWhenExecutor();
        }
        return this.getExecutorService(clazz);
    }

    public ExecutorService buildWhenExecutorWithHash(String hash) {
        LiteflowConfig liteflowConfig = LiteflowConfigGetter.get();
        return this.buildWhenExecutorWithHash(liteflowConfig.getGlobalThreadPoolExecutorClass(), hash);
    }

    public ExecutorService buildWhenExecutorWithHash(String clazz, String hash) {
        if (StrUtil.isBlank((CharSequence)clazz)) {
            return this.buildWhenExecutorWithHash(hash);
        }
        return this.getExecutorService(clazz, hash);
    }

    public ExecutorService buildMainExecutor() {
        LiteflowConfig liteflowConfig = LiteflowConfigGetter.get();
        return this.buildMainExecutor(liteflowConfig.getMainExecutorClass());
    }

    public ExecutorService buildMainExecutor(String clazz) {
        if (StrUtil.isBlank((CharSequence)clazz)) {
            return this.buildMainExecutor();
        }
        return this.getExecutorService(clazz);
    }

    private ExecutorService getExecutorService(String clazz) {
        return this.getExecutorService(clazz, null);
    }

    private ExecutorService getExecutorService(String clazz, String hash) {
        try {
            String key = StrUtil.isBlank((CharSequence)hash) ? clazz : StrUtil.format((CharSequence)"{}_{}", (Object[])new Object[]{clazz, hash});
            ExecutorService executorServiceFromCache = this.executorServiceMap.get(key);
            if (ObjectUtil.isNotNull((Object)executorServiceFromCache)) {
                return executorServiceFromCache;
            }
            Class<?> executorClass = Class.forName(clazz);
            ExecutorBuilder executorBuilder = (ExecutorBuilder)ContextAwareHolder.loadContextAware().registerBean(executorClass);
            ExecutorService executorService = executorBuilder.buildExecutor();
            this.executorServiceMap.put(key, executorService);
            return executorService;
        }
        catch (Exception e) {
            this.LOG.error(e.getMessage());
            throw new ThreadExecutorServiceCreateException(e.getMessage());
        }
    }

    public void clearExecutorServiceMap() {
        if (MapUtil.isNotEmpty(this.executorServiceMap)) {
            this.executorServiceMap.clear();
        }
    }

    public ExecutorService buildExecutorService(Condition condition, Integer slotIndex, ConditionTypeEnum type) {
        LiteflowConfig liteflowConfig = LiteflowConfigGetter.get();
        String chainId = DataBus.getSlot(slotIndex).getChainId();
        Chain chain = FlowBus.getChain(chainId);
        ExecutorCondition execCondition = ExecutorConditionBuilder.buildExecutorCondition(condition, chain, liteflowConfig, type);
        ExecutorService executor = execCondition.isConditionLevel() ? this.getExecutorService(execCondition.getConditionExecutorClass(), String.valueOf(condition.hashCode())) : (execCondition.isChainLevel() ? this.getExecutorService(chain.getThreadPoolExecutorClass(), String.valueOf(chain.hashCode())) : this.getExecutorService(liteflowConfig.getGlobalThreadPoolExecutorClass()));
        return executor;
    }

    private static class Holder {
        static final ExecutorHelper INSTANCE = new ExecutorHelper();

        private Holder() {
        }
    }
}

