/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.flow.element.condition;

import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.enums.ConditionTypeEnum;
import com.yomahub.liteflow.flow.element.Condition;
import com.yomahub.liteflow.flow.element.Executable;
import com.yomahub.liteflow.log.LFLog;
import com.yomahub.liteflow.log.LFLoggerManager;
import com.yomahub.liteflow.slot.DataBus;
import com.yomahub.liteflow.slot.Slot;

public class NotCondition
extends Condition {
    private final LFLog LOG = LFLoggerManager.getLogger(this.getClass());

    @Override
    public void executeCondition(Integer slotIndex) throws Exception {
        Executable item = this.getItem();
        item.setCurrChainId(this.getCurrChainId());
        item.execute(slotIndex);
        boolean flag = (Boolean)item.getItemResultMetaValue(slotIndex);
        this.LOG.info("the result of boolean component [{}] is [{}]", (Object)item.getId(), (Object)flag);
        Slot slot = DataBus.getSlot(slotIndex);
        String resultKey = StrUtil.format((CharSequence)"{}_{}", (Object[])new Object[]{this.getClass().getName(), this.hashCode()});
        slot.setNotResult(resultKey, !flag);
    }

    public Boolean getItemResultMetaValue(Integer slotIndex) {
        Slot slot = DataBus.getSlot(slotIndex);
        String resultKey = StrUtil.format((CharSequence)"{}_{}", (Object[])new Object[]{this.getClass().getName(), this.hashCode()});
        return BooleanUtil.isTrue((Boolean)slot.getNotResult(resultKey));
    }

    @Override
    public ConditionTypeEnum getConditionType() {
        return ConditionTypeEnum.TYPE_NOT_OPT;
    }

    public void setItem(Executable item) {
        this.addExecutable("NOT_ITEM_KEY", item);
    }

    public Executable getItem() {
        return this.getExecutableOne("NOT_ITEM_KEY");
    }
}

